﻿using UnityEngine;
using System.Collections;

public class Vijand : MonoBehaviour {

	//Onderstaande informatie hebben we nodig om goede beslissingen te kunnen nemen.
	public int waarde = 10;

	public float bewegingsSnelheid = -1f;

	public Transform zichtStart, zichtEind, kwetsbaarGrens;

	private bool isInBotsing;

	private Rigidbody2D rb2d;

	private GameController gameController;

	// Use this for initialization
	void Start () {
		rb2d = GetComponent<Rigidbody2D> ();

		//We zoeken hier naar de gamecontroller in het spel om te zorgen dat de score verhoogd kan worden.
		gameController = GameObject.FindGameObjectWithTag ("GameController").GetComponent<GameController> ();
	}
	
	// Update is called once per frame
	void Update () {
	
		//We zorgen dat de vijand loopt.
		rb2d.velocity = new Vector2 (bewegingsSnelheid, rb2d.velocity.y);

		//We checken of de vijand in botsing is of niet (true of false) en die waarde slaan we op.
		isInBotsing = Physics2D.Linecast (zichtStart.position, zichtEind.position);

		//Als de vijand in botsing is, dan moet hij gespiegeld worden en de andere kant op gaan lopen.
		if (isInBotsing) {
			//Spiegelen
			transform.localScale = new Vector2 (transform.localScale.x * -1, transform.localScale.y);

			//Andere kant op lopen
			bewegingsSnelheid *= -1;
		}

	}

	/*Als de y van het punt waarop we geraakt zijn hoger is dan de kwetsbaarGrens (als die is ingesteld), dan moet:
		*	- De vijand onschadelijk worden door een andere tag in te stellen
		*	- De speler een terugslag krijgen door omhoog te veren
		*	- De score verhoogd worden
		*	- De vijand verdwijnen.
		*/
	void OnCollisionEnter2D(Collision2D other) {
		if (kwetsbaarGrens) {
			//Opvragen waar de vijand geraakt is
			float geraakt = other.contacts [0].point.y;

			if (geraakt > kwetsbaarGrens.position.y) {
				//Onschadelijk maken
				gameObject.tag = "Onschadelijk";

				//Terugslag geven aan de speler
				Rigidbody2D rb2dOther = other.gameObject.GetComponent<Rigidbody2D> ();
				rb2dOther.AddForce (new Vector2 (0, 400));

				//Score verhogen
				gameController.VerhoogScore (waarde);

				//Speler vernietigen
				Destroy (gameObject);
			}
		}

		//Anders hoeven we niks te doen.
	}

	/* OnDrawGizmos tekent de lijntjes in de scene view, in dit geval van het zicht van de vijand (groen) en de kwetsbaargrens (rood).
	 * Deze code is niet verplicht om het spel te laten werken.
	 * 
	 */
	void OnDrawGizmos() {
		Gizmos.color = Color.green;

		Gizmos.DrawLine (zichtStart.position, zichtEind.position);
		Gizmos.DrawSphere (zichtStart.position, 0.02f);
		Gizmos.DrawSphere (zichtEind.position, 0.02f);

		Gizmos.color = Color.red;

		if (kwetsbaarGrens) {
			Vector3 kwetsbaarGrensBegin = new Vector3 (kwetsbaarGrens.position.x - 0.5f, kwetsbaarGrens.position.y, kwetsbaarGrens.position.z);
			Vector3 kwetsbaarGrensEind = new Vector3 (kwetsbaarGrens.position.x + 0.5f, kwetsbaarGrens.position.y, kwetsbaarGrens.position.z);

			Gizmos.DrawLine (kwetsbaarGrensBegin, kwetsbaarGrensEind);
			Gizmos.DrawSphere (kwetsbaarGrensBegin, 0.02f);
			Gizmos.DrawSphere (kwetsbaarGrensEind, 0.02f);
		}
	}
}
