﻿using UnityEngine;
using UnityEngine.SceneManagement;
using System.Collections;

public class Speler : MonoBehaviour {

	public float beweegKracht = 50f;
	public float maxSnelheid = 2f;
	public float springkracht = 200f;
	public float dubbelspringkracht = 100f; 
	public LayerMask platformlaag;
	public Transform grondCheck;
	public ParticleSystem geraakt;

	private Rigidbody2D rb2d;
	private bool kijktNaarRechts = true;
	private bool opdegrond = false;
	private bool dubbelSpringen = false;
	private float grondRadius = 0.2f;


	// Use this for initialization
	void Start () {
		rb2d = GetComponent<Rigidbody2D> ();
	}
	
	// Update is called once per frame
	void Update () {
		//Springen mag als de speler op de grond staat en op de spatiebalk wordt ingedrukt.
		if (opdegrond && Input.GetKeyDown (KeyCode.Space)) {
			rb2d.AddForce (new Vector2 (0, springkracht));
			//Eventueel mag er nu nog een keer gesprongen worden.
			dubbelSpringen = true;
		//Dubbelspringen mag als er al een keer gesprongen is en er op de spatiebalk wordt gedrukt.
		} else if (dubbelSpringen && Input.GetKeyDown (KeyCode.Space)) {
			//De dubbelspringkracht is lager dan de eerste springkracht.
			rb2d.AddForce (new Vector2 (0, dubbelspringkracht));
			//Dubbelspringen mag maar één keer.
			dubbelSpringen = false;
		}
	}

	void FixedUpdate() {
		opdegrond = Physics2D.OverlapCircle (grondCheck.position, grondRadius, platformlaag);

		float beweging = Input.GetAxis ("Horizontal");

		if (beweging * rb2d.velocity.x < maxSnelheid) {
			rb2d.AddForce (Vector2.right * beweging * beweegKracht);
		}

		if (Mathf.Abs (rb2d.velocity.x) > maxSnelheid) {
			rb2d.velocity = new Vector2 (Mathf.Sign (rb2d.velocity.x) * maxSnelheid, rb2d.velocity.y);
		}

		if (beweging > 0 && !kijktNaarRechts) {
			//speler keek naar links, maar moet nu naar rechts gaan kijken
			Flip ();
		} else if (beweging < 0 && kijktNaarRechts) {
			//speler keek naar rechts, maar moet nu naar links gaan kijken
			Flip();
		}

	}

	void Flip() {
		kijktNaarRechts = !kijktNaarRechts;
		Vector3 schaal = transform.localScale;
		schaal.x *= -1;
		transform.localScale = schaal;
	}

	void OnDestroy() {
		Instantiate (geraakt, transform.position, transform.rotation);
	}
}
