/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.KnownFunction;

public class UserFunction
implements KnownFunction {
    protected String name;
    protected String[] paramNames = new String[0];
    protected double[] paramValues = new double[0];
    protected String expression = "";
    protected String dummyVar = "dummy";
    protected MultiVarFunction function = null;
    protected String var = "x";

    public UserFunction(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getIndependentVariable() {
        return this.var;
    }

    public String getExpression() {
        return this.expression.replaceAll(this.dummyVar, this.var);
    }

    public String getExpression(String string) {
        this.var = string;
        return this.getExpression();
    }

    public boolean setExpression(String string, String string2) {
        this.var = string2;
        string = string.replaceAll(this.var, this.dummyVar);
        int n = this.paramNames.length + 1;
        String[] stringArray = new String[n];
        stringArray[0] = this.dummyVar;
        for (int i = 1; i < n; ++i) {
            stringArray[i] = this.paramNames[i - 1];
        }
        try {
            this.function = new ParsedMultiVarFunction(string, stringArray);
            if (string.indexOf("=") == -1) {
                this.expression = string;
                return true;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        return false;
    }

    public int getParameterCount() {
        return this.paramNames.length;
    }

    public String getParameterName(int n) {
        return this.paramNames[n];
    }

    public double getParameterValue(int n) {
        return this.paramValues[n];
    }

    public void setParameterValue(int n, double d) {
        this.paramValues[n] = d;
    }

    public void setParameters(String[] stringArray, double[] dArray) {
        this.paramNames = stringArray;
        this.paramValues = dArray;
    }

    public double evaluate(double d) {
        if (this.function == null) {
            return Double.NaN;
        }
        int n = this.paramValues.length + 1;
        double[] dArray = new double[n];
        dArray[0] = d;
        System.arraycopy(this.paramValues, 0, dArray, 1, n - 1);
        return this.function.evaluate(dArray);
    }
}

