/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.RemoteJob;
import org.opensourcephysics.tools.Tool;

public class RemoteTool
extends UnicastRemoteObject
implements Tool {
    Tool child;
    Map replies = new HashMap();
    Map jobs = new HashMap();

    public RemoteTool(Tool tool) throws RemoteException {
        OSPLog.finest("Wrapping tool " + tool.getClass().getName());
        this.child = tool;
    }

    public void send(Job job, Tool tool) throws RemoteException {
        this.save(job, tool);
        job = this.convert(job);
        if (this.child.equals(tool)) {
            this.sendReplies(job);
        } else {
            this.forward(job);
        }
    }

    private void save(Job job, Tool tool) {
        if (tool == null || this.child.equals(tool)) {
            return;
        }
        HashSet<Tool> hashSet = (HashSet<Tool>)this.replies.get(job);
        if (hashSet == null) {
            hashSet = new HashSet<Tool>();
            this.replies.put(job, hashSet);
        }
        hashSet.add(tool);
    }

    private void sendReplies(Job job) throws RemoteException {
        Collection collection = (Collection)this.replies.get(job);
        if (collection == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tool tool = (Tool)iterator.next();
            tool.send(job, this);
        }
    }

    private void forward(Job job) throws RemoteException {
        this.child.send(job, this);
    }

    private Job convert(Job job) throws RemoteException {
        if (job instanceof LocalJob) {
            RemoteJob remoteJob = new RemoteJob(job);
            this.jobs.put(remoteJob, job);
            return remoteJob;
        }
        Job job2 = (Job)this.jobs.get(job);
        if (job2 == null) {
            return job;
        }
        return job2;
    }
}

