/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;

public class Parameter {
    final String paramName;
    final String funcStr;
    double value = Double.NaN;
    boolean editable = true;

    public Parameter(String string, String string2) {
        this.paramName = string;
        this.funcStr = string2;
    }

    public String getName() {
        return this.paramName;
    }

    public String getFunctionString() {
        return this.funcStr;
    }

    public double getValue() {
        return this.value;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    protected double evaluate(ArrayList arrayList) {
        int n = arrayList.contains(this) ? arrayList.size() - 1 : arrayList.size();
        Parameter[] parameterArray = new Parameter[n];
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Parameter parameter = (Parameter)arrayList.get(i);
            if (parameter == this) continue;
            parameterArray[n2++] = parameter;
        }
        return this.evaluate(parameterArray);
    }

    public double evaluate(Parameter[] parameterArray) {
        int n = parameterArray.length;
        String[] stringArray = new String[n];
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = parameterArray[i].paramName;
            dArray[i] = parameterArray[i].value;
        }
        try {
            ParsedMultiVarFunction parsedMultiVarFunction = new ParsedMultiVarFunction(this.funcStr, stringArray);
            this.value = parsedMultiVarFunction.evaluate(dArray);
        }
        catch (ParserException parserException) {
            this.value = Double.NaN;
        }
        return this.value;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Parameter parameter = (Parameter)object;
            xMLControl.setValue("name", parameter.getName());
            xMLControl.setValue("function", parameter.getFunctionString());
            xMLControl.setValue("editable", parameter.isEditable());
        }

        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            String string2 = xMLControl.getString("function");
            return new Parameter(string, string2);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Parameter parameter = (Parameter)object;
            if (xMLControl.getPropertyNames().contains("editable")) {
                parameter.setEditable(xMLControl.getBoolean("editable"));
            }
            return object;
        }
    }
}

