/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.HighlightableDataset;

public class DatasetDataTable
extends DataTable {
    final HighlightableDataset dataset;
    HighlightableDataset data = new HighlightableDataset();
    HighlightableDataset workingData = new HighlightableDataset();

    public DatasetDataTable(HighlightableDataset highlightableDataset) {
        this.dataset = highlightableDataset;
        this.add(highlightableDataset);
        this.setRowNumberVisible(true);
        this.setSelectionMode(2);
    }

    protected HighlightableDataset getData() {
        this.data.clear();
        if (this.isXYColumnsReversed()) {
            this.data.append(this.dataset.getYPoints(), this.dataset.getXPoints());
            this.data.setXYColumnNames(this.dataset.getColumnName(1), this.dataset.getColumnName(0));
        } else {
            this.data.append(this.dataset.getXPoints(), this.dataset.getYPoints());
            this.data.setXYColumnNames(this.dataset.getColumnName(0), this.dataset.getColumnName(1));
        }
        this.data.setMarkerShape(this.dataset.getMarkerShape());
        this.data.setMarkerSize(this.dataset.getMarkerSize());
        this.data.setConnected(this.dataset.isConnected());
        this.data.setLineColor(this.dataset.getLineColor());
        this.data.setName(this.dataset.getName());
        this.data.setMarkerColor(this.dataset.getFillColor(), this.dataset.getEdgeColor());
        for (int i = 0; i < this.dataset.getRowCount(); ++i) {
            this.data.setHighlighted(i, this.dataset.isHighlighted(i));
        }
        return this.data;
    }

    protected HighlightableDataset getWorkingData() {
        double[] dArray;
        double[] dArray2;
        double[] dArray3 = this.dataset.getXPoints();
        double[] dArray4 = this.dataset.getYPoints();
        this.dataset.clearHighlights();
        this.data.clearHighlights();
        if (this.getSelectedRowCount() == 0) {
            dArray2 = dArray3;
            dArray = dArray4;
        } else {
            int[] nArray = this.getSelectedRows();
            dArray2 = new double[nArray.length];
            dArray = new double[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                dArray2[i] = dArray3[nArray[i]];
                dArray[i] = dArray4[nArray[i]];
                this.dataset.setHighlighted(nArray[i], true);
                this.data.setHighlighted(nArray[i], true);
            }
        }
        this.workingData.clear();
        if (this.isXYColumnsReversed()) {
            this.workingData.append(dArray, dArray2);
            this.workingData.setXYColumnNames(this.dataset.getColumnName(1), this.dataset.getColumnName(0));
        } else {
            this.workingData.append(dArray2, dArray);
            this.workingData.setXYColumnNames(this.dataset.getColumnName(0), this.dataset.getColumnName(1));
        }
        this.workingData.setMarkerShape(this.dataset.getMarkerShape());
        this.workingData.setMarkerSize(this.dataset.getMarkerSize());
        this.workingData.setConnected(this.dataset.isConnected());
        this.workingData.setLineColor(this.dataset.getLineColor());
        this.workingData.setName(this.dataset.getName());
        this.workingData.setMarkerColor(this.dataset.getFillColor(), this.dataset.getEdgeColor());
        return this.workingData;
    }

    protected boolean isXYColumnsReversed() {
        int n = this.isRowNumberVisible() ? 1 : 0;
        return this.convertColumnIndexToView(n) > this.convertColumnIndexToView(n + 1);
    }

    public void clearSelection() {
        if (this.dataset != null) {
            this.dataset.clearHighlights();
            this.data.clearHighlights();
        }
        super.clearSelection();
    }
}

