/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.AbstractSpinnerModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.FunctionDrawer;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.HessianMinimize;
import org.opensourcephysics.numerics.LevenbergMarquardt;
import org.opensourcephysics.numerics.MultiVarFunction;
import org.opensourcephysics.numerics.PolynomialLeastSquareFit;
import org.opensourcephysics.tools.KnownFunction;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DatasetCurveFitter
extends JPanel {
    Dataset dataset;
    KnownFunction fit;
    HessianMinimize hessian = new HessianMinimize();
    LevenbergMarquardt levmar = new LevenbergMarquardt();
    FunctionDrawer drawer;
    Color color = Color.red;
    JCheckBox autofitCheckBox;
    String[] fitNames;
    JComboBox fitDropDown;
    JTextField equation;
    JLabel rmsLabel;
    NumberField rmsField;
    JToolBar toolbar = new JToolBar();
    JTable paramTable;
    TableCellRenderer cellRenderer;
    SpinCellEditor spinCellEditor;
    Map namedFits = new HashMap();
    Map fitEditors = new HashMap();
    int fitNumber = 1;
    JButton editButton;
    int prevFit;

    public DatasetCurveFitter(Dataset dataset) {
        this.dataset = dataset;
        this.createGUI();
        this.fit(this.fit);
    }

    public Drawable getDrawer() {
        return this.drawer;
    }

    public Dataset getData() {
        return this.dataset;
    }

    public void setData(Dataset dataset) {
        this.dataset = dataset;
        this.fit(this.fit);
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.drawer != null) {
            this.drawer.setColor(color);
        }
    }

    public void fit(Function function) {
        if (this.drawer == null) {
            this.selectFit((String)this.fitDropDown.getSelectedItem());
        }
        if (function == null) {
            return;
        }
        double[] dArray = this.dataset.getValidXPoints();
        double[] dArray2 = this.dataset.getValidYPoints();
        double d = 0.0;
        double[] dArray3 = null;
        double d2 = this.getDevSquared(function, dArray, dArray2);
        if (this.autofitCheckBox.isSelected()) {
            UserFunction userFunction;
            double[] dArray4;
            if (function instanceof KnownPolynomial) {
                KnownPolynomial knownPolynomial = (KnownPolynomial)function;
                knownPolynomial.fitData(dArray, dArray2);
            } else if (function instanceof UserFunction && (dArray4 = new double[(userFunction = (UserFunction)function).getParameterCount()]).length > 0) {
                int n;
                MinimizeUserFunction minimizeUserFunction = new MinimizeUserFunction(userFunction, dArray, dArray2);
                dArray3 = new double[dArray4.length];
                for (int i = 0; i < dArray4.length; ++i) {
                    dArray4[i] = dArray3[i] = userFunction.getParameterValue(i);
                }
                double d3 = 1.0E-6;
                int n2 = 20;
                this.hessian.minimize(minimizeUserFunction, dArray4, n2, d3);
                d = this.getDevSquared(function, dArray, dArray2);
                if (d > d2) {
                    for (n = 0; n < dArray3.length; ++n) {
                        userFunction.setParameterValue(n, dArray3[n]);
                    }
                    this.levmar.minimize(minimizeUserFunction, dArray4, n2, d3);
                    d = this.getDevSquared(function, dArray, dArray2);
                }
                if (d > d2) {
                    for (n = 0; n < dArray3.length; ++n) {
                        userFunction.setParameterValue(n, dArray3[n]);
                    }
                    d = d2;
                    this.autofitCheckBox.setSelected(false);
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            this.drawer.functionChanged = true;
            this.paramTable.repaint();
        }
        if (d == 0.0) {
            d = this.getDevSquared(function, dArray, dArray2);
        }
        this.rmsField.setValue(Math.sqrt(d / (double)dArray.length));
        this.firePropertyChange("fit", null, null);
    }

    protected void createGUI() {
        this.setLayout(new BorderLayout());
        this.autofitCheckBox = new JCheckBox("", true);
        this.autofitCheckBox.setSelected(false);
        this.autofitCheckBox.setOpaque(false);
        this.autofitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetCurveFitter.this.spinCellEditor.stopCellEditing();
                DatasetCurveFitter.this.paramTable.clearSelection();
                DatasetCurveFitter.this.fit(DatasetCurveFitter.this.fit);
            }
        });
        this.fitNames = new String[]{ToolsRes.getString("Function.Poly1.Name"), ToolsRes.getString("Function.Poly2.Name"), ToolsRes.getString("Function.Poly3.Name"), ToolsRes.getString("Function.Custom")};
        this.prevFit = 0;
        this.fitDropDown = new JComboBox<String>(this.fitNames);
        this.fitDropDown.setMaximumSize(this.fitDropDown.getMinimumSize());
        this.fitDropDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)DatasetCurveFitter.this.fitDropDown.getSelectedItem();
                if (string.equals(ToolsRes.getString("Function.Custom"))) {
                    DatasetCurveFitter.this.createFit(ToolsRes.getString("Function.Custom.Name") + DatasetCurveFitter.this.fitNumber);
                } else {
                    DatasetCurveFitter.this.selectFit(string);
                }
            }
        });
        this.equation = new JTextField();
        this.equation.setEditable(false);
        this.equation.setEnabled(true);
        this.equation.setBackground(Color.white);
        this.rmsField = new NumberField(5){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.width = 32;
                return dimension;
            }
        };
        this.rmsField.setEditable(false);
        this.rmsField.setEnabled(true);
        this.rmsField.setBackground(Color.white);
        this.rmsLabel = new JLabel();
        this.rmsLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 2));
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "North");
        this.cellRenderer = new ParamCellRenderer();
        this.spinCellEditor = new SpinCellEditor();
        this.paramTable = new ParamTable(new ParamTableModel());
        this.paramTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DatasetCurveFitter.this.paramTable.getSelectedColumn() == 0) {
                    DatasetCurveFitter.this.paramTable.clearSelection();
                }
            }
        });
        this.add((Component)new JScrollPane(this.paramTable), "Center");
        this.editButton = new JButton();
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UserFunction userFunction = (UserFunction)DatasetCurveFitter.this.fit;
                UserFunctionEditor userFunctionEditor = (UserFunctionEditor)DatasetCurveFitter.this.fitEditors.get(userFunction);
                userFunctionEditor.refresh();
                userFunctionEditor.setVisible(true);
                if (userFunctionEditor.isDeleted()) {
                    DatasetCurveFitter.this.namedFits.remove(userFunction.getName());
                    DatasetCurveFitter.this.fitDropDown.removeItem(userFunction.getName());
                }
            }
        });
        this.refreshGUI();
    }

    protected void refreshGUI() {
        this.autofitCheckBox.setText(ToolsRes.getString("Checkbox.Autofit.Label"));
        this.rmsLabel.setText(ToolsRes.getString("DatasetCurveFitter.Label.RMSDeviation"));
        this.editButton.setText(ToolsRes.getString("DatasetCurveFitter.Button.Edit"));
        this.paramTable.tableChanged(null);
        int n = this.fitDropDown.getItemCount();
        Object[] objectArray = new Object[n];
        this.fitNames = new String[]{ToolsRes.getString("Function.Poly1.Name"), ToolsRes.getString("Function.Poly2.Name"), ToolsRes.getString("Function.Poly3.Name"), ToolsRes.getString("Function.Custom")};
        int n2 = n - this.fitNames.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = i < n2 ? this.fitDropDown.getItemAt(i) : this.fitNames[i - n2];
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        int n3 = this.fitDropDown.getSelectedIndex();
        this.fitDropDown.setModel(defaultComboBoxModel);
        this.fitDropDown.setSelectedIndex(n3);
    }

    protected void selectFit(String string) {
        this.fit = (KnownFunction)this.namedFits.get(string);
        if (this.fit == null) {
            if (string.equals(ToolsRes.getString("Function.Poly1.Name"))) {
                this.fit = new KnownPolynomial(new double[]{0.0, 0.0});
            } else if (string.equals(ToolsRes.getString("Function.Poly2.Name"))) {
                this.fit = new KnownPolynomial(new double[]{0.0, 0.0, 0.0});
            } else if (string.equals(ToolsRes.getString("Function.Poly3.Name"))) {
                this.fit = new KnownPolynomial(new double[]{0.0, 0.0, 0.0, 0.0});
            }
            if (this.fit != null) {
                this.namedFits.put(string, this.fit);
            }
        }
        this.toolbar.removeAll();
        this.toolbar.add(this.fitDropDown);
        this.toolbar.addSeparator();
        if (this.fit instanceof UserFunction) {
            this.toolbar.add(this.editButton);
            this.toolbar.addSeparator();
        }
        this.toolbar.add(this.equation);
        if (this.fit != null) {
            for (int i = 0; i < this.fitDropDown.getItemCount(); ++i) {
                if (!this.fitDropDown.getItemAt(i).equals(string)) continue;
                this.prevFit = i;
                break;
            }
            this.toolbar.add(this.rmsLabel);
            this.toolbar.add(this.rmsField);
            this.toolbar.add(this.autofitCheckBox);
            FunctionDrawer functionDrawer = this.drawer;
            this.drawer = new FunctionDrawer(this.fit);
            this.drawer.setColor(this.color);
            this.paramTable.tableChanged(null);
            String string2 = GUIUtils.removeSubscripting(this.dataset.getColumnName(1));
            String string3 = GUIUtils.removeSubscripting(this.dataset.getColumnName(0));
            this.equation.setText(string2 + " = " + this.fit.getExpression(string3));
            this.firePropertyChange("drawer", functionDrawer, this.drawer);
            this.fit(this.fit);
        }
    }

    protected void createFit(String string) {
        int n = this.prevFit;
        this.autofitCheckBox.setSelected(false);
        UserFunction userFunction = new UserFunction(string);
        String string2 = GUIUtils.removeSubscripting(this.dataset.getColumnName(0));
        userFunction.setExpression("0", string2);
        this.namedFits.put(string, userFunction);
        this.fitDropDown.insertItemAt(string, 0);
        this.fitDropDown.setSelectedItem(string);
        this.selectFit(string);
        UserFunctionEditor userFunctionEditor = new UserFunctionEditor(userFunction, this);
        this.fitEditors.put(userFunction, userFunctionEditor);
        userFunctionEditor.setVisible(true);
        if (userFunctionEditor.isDeleted()) {
            this.namedFits.remove(string);
            this.fitDropDown.removeItem(string);
            this.fitDropDown.setSelectedIndex(n);
            this.selectFit((String)this.fitDropDown.getItemAt(n));
        } else {
            ++this.fitNumber;
        }
    }

    private double getDevSquared(Function function, double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = function.evaluate(dArray[i]);
            double d3 = d2 - dArray2[i];
            d += d3 * d3;
        }
        return d;
    }

    class NumberField
    extends JTextField {
        protected NumberFormat format;
        protected double prevValue;

        public NumberField(int n) {
            super(n);
            this.format = NumberFormat.getInstance();
            if (this.format instanceof DecimalFormat) {
                ((DecimalFormat)this.format).applyPattern("0.000E0");
            }
            this.setForeground(Color.black);
        }

        public double getValue() {
            double d;
            if (this.getText().equals(this.format.format(this.prevValue))) {
                return this.prevValue;
            }
            try {
                d = this.format.parse(this.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                Toolkit.getDefaultToolkit().beep();
                this.setValue(this.prevValue);
                return this.prevValue;
            }
            return d;
        }

        public void setValue(double d) {
            if (!this.isVisible()) {
                return;
            }
            this.setText(this.format.format(d));
            this.prevValue = d;
        }
    }

    public class MinimizeUserFunction
    implements MultiVarFunction {
        UserFunction f;
        double[] x;
        double[] y;

        MinimizeUserFunction(UserFunction userFunction, double[] dArray, double[] dArray2) {
            this.f = userFunction;
            this.x = dArray;
            this.y = dArray2;
        }

        public double evaluate(double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                this.f.setParameterValue(i, dArray[i]);
            }
            double d = 0.0;
            for (int i = 0; i < this.x.length; ++i) {
                double d2 = this.y[i] - this.f.evaluate(this.x[i]);
                d += d2 * d2;
            }
            return d;
        }
    }

    public class MinimizeMultiVarFunction
    implements MultiVarFunction {
        MultiVarFunction f;
        double[] x;
        double[] y;
        double[] vars = new double[5];

        MinimizeMultiVarFunction(MultiVarFunction multiVarFunction, double[] dArray, double[] dArray2) {
            this.f = multiVarFunction;
            this.x = dArray;
            this.y = dArray2;
        }

        public double evaluate(double[] dArray) {
            System.arraycopy(dArray, 0, this.vars, 1, 4);
            double d = 0.0;
            int n = this.x.length;
            for (int i = 0; i < n; ++i) {
                this.vars[0] = this.x[i];
                double d2 = this.y[i] - this.f.evaluate(this.vars);
                d += d2 * d2;
            }
            return d;
        }
    }

    class KnownPolynomial
    extends PolynomialLeastSquareFit
    implements KnownFunction {
        String[] names;

        KnownPolynomial(double[] dArray, double[] dArray2, int n) {
            super(dArray, dArray2, n);
            this.names = new String[]{"a", "b", "c", "d", "e", "f"};
        }

        KnownPolynomial(double[] dArray) {
            super(dArray);
            this.names = new String[]{"a", "b", "c", "d", "e", "f"};
        }

        public int getParameterCount() {
            return this.coefficients.length;
        }

        public String getParameterName(int n) {
            return this.names[n];
        }

        public double getParameterValue(int n) {
            return this.coefficients[this.coefficients.length - n - 1];
        }

        public void setParameterValue(int n, double d) {
            this.coefficients[this.coefficients.length - n - 1] = d;
        }

        public String getExpression(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.coefficients.length - 1;
            for (int i = 0; i <= n; ++i) {
                stringBuffer.append(this.getParameterName(i));
                if (n - i <= 0) continue;
                stringBuffer.append("*");
                stringBuffer.append(string);
                if (n - i > 1) {
                    stringBuffer.append("^");
                    stringBuffer.append(n - i);
                }
                stringBuffer.append(" + ");
            }
            return stringBuffer.toString();
        }
    }

    class SpinnerNumberCrawlerModel
    extends AbstractSpinnerModel {
        double val = 0.0;
        double delta;
        double percentDelta = 10.0;

        public SpinnerNumberCrawlerModel(double d) {
            this.delta = d;
        }

        public Object getValue() {
            return new Double(this.val);
        }

        public Object getNextValue() {
            return new Double(this.val + this.delta);
        }

        public Object getPreviousValue() {
            return new Double(this.val - this.delta);
        }

        public void setValue(Object object) {
            if (object != null) {
                this.val = (Double)object;
                this.fireStateChanged();
            }
        }

        public void setPercentDelta(double d) {
            this.percentDelta = d;
        }

        public double getPercentDelta() {
            return this.percentDelta;
        }

        public void refreshDelta() {
            if (this.val != 0.0) {
                this.delta = Math.abs(this.val * this.percentDelta / 100.0);
            }
        }
    }

    class SpinCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JPanel panel = new JPanel(new BorderLayout());
        SpinnerNumberCrawlerModel crawlerModel = new SpinnerNumberCrawlerModel(1.0);
        JSpinner spinner;
        NumberField field;
        int index;
        JLabel stepSizeLabel = new JLabel("10%");

        SpinCellEditor() {
            this.panel.setOpaque(false);
            this.spinner = new JSpinner(this.crawlerModel);
            this.spinner.setToolTipText(ToolsRes.getString("Table.Spinner.ToolTip"));
            this.spinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.autofitCheckBox.setSelected(false);
                    double d = (Double)SpinCellEditor.this.spinner.getValue();
                    SpinCellEditor.this.field.setValue(d);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit.setParameterValue(SpinCellEditor.this.index, d);
                    ((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.drawer.functionChanged = true;
                    DatasetCurveFitter.this.fit(((SpinCellEditor)SpinCellEditor.this).DatasetCurveFitter.this.fit);
                }
            });
            this.field = new NumberField(10);
            this.spinner.setBorder(BorderFactory.createEmptyBorder(0, 1, 1, 0));
            this.spinner.setEditor(this.field);
            this.stepSizeLabel.addMouseListener(new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            double d = Double.parseDouble(actionEvent.getActionCommand());
                            (this).SpinCellEditor.this.crawlerModel.setPercentDelta(d);
                            (this).SpinCellEditor.this.crawlerModel.refreshDelta();
                            (this).SpinCellEditor.this.stepSizeLabel.setText(actionEvent.getActionCommand() + "%");
                        }
                    };
                    for (int i = 0; i < 3; ++i) {
                        String string = i == 0 ? "10" : (i == 1 ? "1.0" : "0.1");
                        JMenuItem jMenuItem = new JMenuItem(string + "%");
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                    }
                    jPopupMenu.show(SpinCellEditor.this.stepSizeLabel, 0, SpinCellEditor.this.stepSizeLabel.getHeight());
                }
            });
            this.field.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    JComponent jComponent = (JComponent)keyEvent.getSource();
                    if (keyEvent.getKeyCode() == 10) {
                        SpinCellEditor.this.spinner.setValue(new Double(SpinCellEditor.this.field.getValue()));
                        jComponent.setBackground(Color.white);
                        SpinCellEditor.this.crawlerModel.refreshDelta();
                    } else {
                        jComponent.setBackground(Color.yellow);
                    }
                }
            });
            this.panel.add((Component)this.spinner, "Center");
            this.panel.add((Component)this.stepSizeLabel, "East");
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.spinner.setValue(object);
            this.crawlerModel.refreshDelta();
            return this.panel;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return true;
            }
            return eventObject instanceof ActionEvent;
        }

        public Object getCellEditorValue() {
            if (this.field.getBackground() == Color.yellow) {
                DatasetCurveFitter.this.fit.setParameterValue(this.index, this.field.getValue());
                DatasetCurveFitter.this.drawer.functionChanged = true;
                DatasetCurveFitter.this.firePropertyChange("fit", null, null);
                this.field.setBackground(Color.white);
            }
            return null;
        }
    }

    class ParamCellRenderer
    extends JLabel
    implements TableCellRenderer {
        Color lightBlue = new Color(204, 204, 255);
        Color lightGray = UIManager.getColor("Panel.background");
        Font labelFont = this.getFont();
        Font fieldFont = new JTextField().getFont();

        public ParamCellRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 2));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(n2 == 0 ? 4 : 2);
            if (object instanceof String) {
                this.setFont(this.labelFont);
                this.setBackground(this.lightGray);
                this.setForeground(Color.black);
                this.setText(object.toString());
            } else {
                this.setFont(this.fieldFont);
                this.setBackground(bl ? this.lightBlue : Color.white);
                this.setForeground(bl ? Color.red : Color.black);
                NumberFormat numberFormat = DatasetCurveFitter.this.spinCellEditor.field.format;
                this.setText(numberFormat.format(object));
            }
            return this;
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        ParamTableModel() {
        }

        public String getColumnName(int n) {
            return n == 0 ? ToolsRes.getString("Table.Heading.Parameter") : ToolsRes.getString("Table.Heading.Value");
        }

        public int getRowCount() {
            return DatasetCurveFitter.this.fit == null ? 0 : DatasetCurveFitter.this.fit.getParameterCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return DatasetCurveFitter.this.fit.getParameterName(n);
            }
            return new Double(DatasetCurveFitter.this.fit.getParameterValue(n));
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class ParamTable
    extends JTable {
        public ParamTable(ParamTableModel paramTableModel) {
            super(paramTableModel);
            this.setPreferredScrollableViewportSize(new Dimension(60, 50));
            this.setGridColor(Color.blue);
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setForeground(Color.blue);
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return DatasetCurveFitter.this.cellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            DatasetCurveFitter.this.spinCellEditor.index = n;
            return DatasetCurveFitter.this.spinCellEditor;
        }
    }
}

