/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEAdaptiveSolver;
import org.opensourcephysics.ode.IRK.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.ode.IRK.AlgebraicEquationSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.IRKSimplifiedNewton;
import org.opensourcephysics.ode.IRK.LAESolverLU;
import org.opensourcephysics.ode.IRK.LAEquation;
import org.opensourcephysics.ode.IRK.NewtonLastIterationErrorIsTooLarge;
import org.opensourcephysics.ode.IRK.NewtonLostOfConvergence;
import org.opensourcephysics.ode.IRK.Radau5Light;

public class Radau5Adaptive
extends Radau5Light
implements ODEAdaptiveSolver {
    int error_code = 0;
    private double currentStepSize;
    private double tolerance = 1.0E-6;
    private int nRejected = 0;
    private int nAcceptedSteps = 0;
    double[] scal;
    private ErrorFirstAproximationEquation errorApproximationEquation = new ErrorFirstAproximationEquation(this.numEqn);
    private LAESolverLU laeSolver;
    Radau5Light.DifferenceSchemeEquation chekit;
    double hacc = 1.0;
    double erracc = 1.0;

    public Radau5Adaptive(ODE oDE) {
        super(oDE);
        this.scal = new double[this.numEqn];
    }

    protected AlgebraicEquationSimpleSolver getInnerSolver(IRKAlgebraicEquation iRKAlgebraicEquation) {
        this.laeSolver = new LAESolverLU(this.numEqn);
        return new MyNewton(iRKAlgebraicEquation, this.laeSolver);
    }

    protected void estimateNewtonInitialValue(double[][] dArray) {
        double d = this.currentStepSize / this.stepSize;
        for (int i = 0; i < 3; ++i) {
            int n = 0;
            while (n < this.numEqn) {
                double[] dArray2 = dArray[i];
                int n2 = n++;
                dArray2[n2] = dArray2[n2] * d;
            }
        }
    }

    protected void preStepPreparations() {
        super.preStepPreparations();
        this.nRejected = 0;
    }

    public double step() {
        this.error_code = 0;
        this.preStepPreparations();
        double d = 0.0;
        if (this.nAcceptedSteps > 0) {
            this.estimateNewtonInitialValue(this.intermediateStagesIncrement);
            this.aeSolver.updateInitialValue();
        }
        do {
            this.currentStepSize = this.stepSize;
            try {
                double d2 = this.aeSolver.resolve();
                d = this.estimateError();
                this.stepSize = this.estimateStepSize(d, ((MyNewton)this.aeSolver).getnIter(), 7.0);
                if (d < 1.0) {
                    if (Math.abs(this.stepSize / this.currentStepSize - 1.1) <= 0.1 && d2 <= 0.001) {
                        this.stepSize = this.currentStepSize;
                    }
                    this.aeSolver.restart(d2 > 0.001);
                    continue;
                }
                ++this.nRejected;
                this.aeSolver.restart(this.jacobianAge > 0);
            }
            catch (NewtonLostOfConvergence newtonLostOfConvergence) {
                this.stepSize = this.currentStepSize / 2.0;
                this.aeSolver.restart(this.jacobianAge > 0);
                ++this.nRejected;
                d = 10.0;
            }
            catch (NewtonLastIterationErrorIsTooLarge newtonLastIterationErrorIsTooLarge) {
                double d3 = Math.max(1.0E-4, Math.min(20.0, newtonLastIterationErrorIsTooLarge.getToleranceViolation()));
                this.stepSize = this.currentStepSize * 0.8 * Math.pow(d3, -1.0 / (4.0 + (double)newtonLastIterationErrorIsTooLarge.getMaxIterationsAllowed() - 1.0 - (double)newtonLastIterationErrorIsTooLarge.getIterationNumber()));
                this.aeSolver.restart(this.jacobianAge > 0);
                ++this.nRejected;
                d = 10.0;
            }
        } while (d > 1.0);
        this.commitStepResults();
        return this.currentStepSize;
    }

    protected void commitStepResults() {
        super.commitStepResults();
        ++this.nAcceptedSteps;
        ++this.jacobianAge;
    }

    protected double estimateError() {
        int n;
        double[] dArray = new double[this.numEqn];
        double d = 0.0;
        LAEquation lAEquation = this.laeSolver.getEquation();
        this.laeSolver.assignEquation(this.errorApproximationEquation);
        this.laeSolver.resolve(dArray);
        d = 0.0;
        for (n = 0; n < this.numEqn; ++n) {
            d += Math.pow(dArray[n] / this.scal[n], 2.0);
        }
        if ((d = Math.max(Math.sqrt(d / (double)this.numEqn), 1.0E-10)) > 1.0 && (this.nRejected > 0 || this.nAcceptedSteps == 0)) {
            this.laeSolver.assignEquation(this.errorApproximationEquation.getSecondErrorAproximationEquation(dArray));
            this.laeSolver.resolve(dArray);
            d = 0.0;
            for (n = 0; n < this.numEqn; ++n) {
                d += Math.pow(dArray[n] / this.scal[n], 2.0);
            }
            d = Math.max(Math.sqrt(d / (double)this.numEqn), 1.0E-10);
        }
        this.laeSolver.assignEquation(lAEquation);
        return d;
    }

    protected double estimateStepSize(double d, double d2, double d3) {
        double d4 = 0.9;
        double d5 = 5.0;
        double d6 = 0.125;
        double d7 = d4 * (1.0 + 2.0 * d3);
        double d8 = Math.min(d4, d7 / (d2 + 2.0 * d3));
        double d9 = Math.max(d6, Math.min(d5, Math.pow(d, 0.25) / d8));
        double d10 = this.currentStepSize / d9;
        if (d < 1.0) {
            if (this.nAcceptedSteps > 0) {
                double d11 = this.hacc / this.currentStepSize * Math.pow(d * d / this.erracc, 0.25) / d4;
                d11 = Math.max(d6, Math.min(d5, d11));
                d9 = Math.max(d9, d11);
                d10 = this.currentStepSize / d9;
            }
            this.hacc = this.currentStepSize;
            this.erracc = Math.max(0.01, d);
        } else if (this.nAcceptedSteps == 0) {
            d10 = this.currentStepSize * 0.1;
        }
        return d10;
    }

    public void setStepSize(double d) {
        super.setStepSize(d);
        this.aeSolver.restart(false);
    }

    public void setTolerance(double d) {
        this.tolerance = d = 0.1 * Math.pow(d, 0.6666666666666666);
        for (int i = 0; i < this.numEqn; ++i) {
            this.scal[i] = d + d * Math.abs(this.state[i]);
            ((AlgebraicEquationSolver)this.aeSolver).setTolerance(i, this.scal[i]);
        }
        double d2 = 2.220446049250313E-16;
        ((IRKSimplifiedNewton)this.aeSolver).fnewt = Math.max(10.0 * d2 / d, Math.min(0.03, Math.pow(d, 0.5)));
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public int getErrorCode() {
        return this.error_code;
    }

    private class ErrorFirstAproximationEquation
    implements LAEquation {
        private double[] err = new double[]{-10.048809399827414, 1.382142733160748, -0.3333333333333333};
        private double[] temporary;
        ErrorSecondApproximationEquation errorSecondApproximationEquation;

        public ErrorFirstAproximationEquation(int n) {
            this.temporary = new double[n];
        }

        public int getDimension() {
            return Radau5Adaptive.this.numEqn;
        }

        public void getMatrix(double[][] dArray) {
        }

        public void getVector(double[] dArray) {
            for (int i = 0; i < Radau5Adaptive.this.numEqn; ++i) {
                this.temporary[i] = 0.0;
                for (int j = 0; j < this.err.length; ++j) {
                    int n = i;
                    this.temporary[n] = this.temporary[n] + this.err[j] / Radau5Adaptive.this.currentStepSize * Radau5Adaptive.this.intermediateStagesIncrement[j][i];
                }
                dArray[i] = this.temporary[i] + Radau5Adaptive.this.rate[i];
            }
        }

        public ErrorSecondApproximationEquation getSecondErrorAproximationEquation(double[] dArray) {
            if (this.errorSecondApproximationEquation == null) {
                this.errorSecondApproximationEquation = new ErrorSecondApproximationEquation(Radau5Adaptive.this.numEqn, dArray);
            }
            return this.errorSecondApproximationEquation;
        }

        private class ErrorSecondApproximationEquation
        implements LAEquation {
            double[] tmpRate;
            double[] errorApproximation;

            public ErrorSecondApproximationEquation(int n, double[] dArray) {
                this.tmpRate = new double[n];
                this.errorApproximation = dArray;
            }

            public int getDimension() {
                return Radau5Adaptive.this.numEqn;
            }

            public void getMatrix(double[][] dArray) {
            }

            public void getVector(double[] dArray) {
                int n;
                if (ErrorFirstAproximationEquation.this.temporary == null) {
                    System.err.println("Inner's getVector should be invoked earlier than that one");
                }
                for (n = 0; n < Radau5Adaptive.this.numEqn; ++n) {
                    int n2 = n;
                    this.errorApproximation[n2] = this.errorApproximation[n2] + Radau5Adaptive.this.state[n];
                }
                Radau5Adaptive.this.ode.getRate(this.errorApproximation, this.tmpRate);
                for (n = 0; n < Radau5Adaptive.this.numEqn; ++n) {
                    dArray[n] = ErrorFirstAproximationEquation.this.temporary[n] + this.tmpRate[n];
                }
            }
        }
    }

    private class MyNewton
    extends IRKSimplifiedNewton {
        MyNewton(IRKAlgebraicEquation iRKAlgebraicEquation, LAESolverLU lAESolverLU) {
            super(iRKAlgebraicEquation, lAESolverLU);
        }

        MyNewton(IRKAlgebraicEquation iRKAlgebraicEquation) {
            super(iRKAlgebraicEquation);
        }

        double getnIter() {
            return this.nIteration;
        }
    }
}

