/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.IRK.Radau5Adaptive;
import org.opensourcephysics.ode.ODEInterpolator;

public class Radau5
extends Radau5Adaptive
implements ODEInterpolator {
    static final double c1 = (4.0 - Math.sqrt(6.0)) / 10.0;
    static final double c2 = (4.0 + Math.sqrt(6.0)) / 10.0;
    static final double c1m1 = c1 - 1.0;
    static final double c2m1 = c2 - 1.0;
    static final double c1mc2 = c1 - c2;
    double[][] interpolationCoeffs;
    double takenStepSize = 0.0;

    public Radau5(ODE oDE) {
        super(oDE);
        this.interpolationCoeffs = new double[4][oDE.getState().length];
    }

    public double step() {
        this.takenStepSize = super.step();
        this.constructInterpolationCoeffs();
        return this.takenStepSize;
    }

    public void constructInterpolationCoeffs() {
        for (int i = 0; i < this.numEqn; ++i) {
            this.interpolationCoeffs[0][i] = this.state[i];
            this.interpolationCoeffs[1][i] = (this.intermediateStagesIncrement[1][i] - this.intermediateStagesIncrement[2][i]) / c2m1;
            double d = (this.intermediateStagesIncrement[0][i] - this.intermediateStagesIncrement[1][i]) / c1mc2;
            double d2 = this.intermediateStagesIncrement[0][i] / c1;
            d2 = (d - d2) / c2;
            this.interpolationCoeffs[2][i] = (d - this.interpolationCoeffs[1][i]) / c1m1;
            this.interpolationCoeffs[3][i] = this.interpolationCoeffs[2][i] - d2;
        }
    }

    public void doInterpolation(double d, double[] dArray) {
        if (this.takenStepSize == 0.0) {
            for (int i = 0; i < this.numEqn; ++i) {
                dArray[i] = this.state[i];
            }
        }
        double d2 = (d - this.takenStepSize) / this.takenStepSize;
        for (int i = 0; i < this.numEqn; ++i) {
            dArray[i] = this.interpolationCoeffs[0][i] + d2 * (this.interpolationCoeffs[1][i] + (d2 - c2m1) * (this.interpolationCoeffs[2][i] + (d2 - c1m1) * this.interpolationCoeffs[3][i]));
        }
    }

    protected void estimateNewtonInitialValue(double[][] dArray) {
        double d = this.stepSize / this.takenStepSize;
        double d2 = c1 * d;
        double d3 = c2 * d;
        for (int i = 0; i < this.numEqn; ++i) {
            dArray[0][i] = d2 * (this.interpolationCoeffs[1][i] + (d2 - c2m1) * (this.interpolationCoeffs[2][i] + (d2 - c1m1) * this.interpolationCoeffs[3][i]));
            dArray[1][i] = d3 * (this.interpolationCoeffs[1][i] + (d3 - c2m1) * (this.interpolationCoeffs[2][i] + (d3 - c1m1) * this.interpolationCoeffs[3][i]));
            dArray[2][i] = d * (this.interpolationCoeffs[1][i] + (d - c2m1) * (this.interpolationCoeffs[2][i] + (d - c1m1) * this.interpolationCoeffs[3][i]));
        }
    }
}

