/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

public class IRKLinearAlgebra {
    public int dec(int n, int n2, double[][] dArray, int[] nArray) {
        int n3;
        int n4 = -1;
        nArray[n - 1] = 1;
        for (n3 = 0; n3 < n - 1; ++n3) {
            int n5;
            int n6 = n3 + 1;
            int n7 = n3;
            for (n5 = n6; n5 < n; ++n5) {
                if (!(Math.abs(dArray[n5][n3]) > Math.abs(dArray[n7][n3]))) continue;
                n7 = n5;
            }
            nArray[n3] = n7;
            double d = dArray[n7][n3];
            if (n7 != n3) {
                nArray[n - 1] = -nArray[n - 1];
                dArray[n7][n3] = dArray[n3][n3];
                dArray[n3][n3] = d;
            }
            if (d == 0.0) {
                n4 = n3;
                nArray[n - 1] = 0;
                return n4;
            }
            d = 1.0 / d;
            for (n5 = n6; n5 < n; ++n5) {
                double[] dArray2 = dArray[n5];
                int n8 = n3;
                dArray2[n8] = dArray2[n8] * -d;
            }
            for (int i = n6; i < n; ++i) {
                d = dArray[n7][i];
                dArray[n7][i] = dArray[n3][i];
                dArray[n3][i] = d;
                if (d == 0.0) continue;
                for (n5 = n6; n5 < n; ++n5) {
                    double[] dArray3 = dArray[n5];
                    int n9 = i;
                    dArray3[n9] = dArray3[n9] + dArray[n5][n3] * d;
                }
            }
        }
        n3 = n - 1;
        if (dArray[n - 1][n - 1] == 0.0) {
            n4 = n3;
            nArray[n - 1] = 0;
        }
        return n4;
    }

    public void sol(int n, int n2, double[][] dArray, double[] dArray2, int[] nArray) {
        int n3;
        double d;
        int n4;
        for (n4 = 0; n4 < n - 1; ++n4) {
            int n5 = n4 + 1;
            int n6 = nArray[n4];
            d = dArray2[n6];
            dArray2[n6] = dArray2[n4];
            dArray2[n4] = d;
            for (n3 = n5; n3 < n; ++n3) {
                int n7 = n3;
                dArray2[n7] = dArray2[n7] + dArray[n3][n4] * d;
            }
        }
        for (int i = 1; i <= n - 1; ++i) {
            int n8;
            int n9 = n4 = (n8 = n - i);
            dArray2[n9] = dArray2[n9] / dArray[n4][n4];
            d = -dArray2[n4];
            for (n3 = 0; n3 < n8; ++n3) {
                int n10 = n3;
                dArray2[n10] = dArray2[n10] + dArray[n3][n4] * d;
            }
        }
        dArray2[0] = dArray2[0] / dArray[0][0];
    }

    public int decc(int n, int n2, double[][] dArray, double[][] dArray2, int[] nArray) {
        int n3;
        int n4 = -1;
        nArray[n - 1] = 1;
        for (n3 = 0; n3 < n - 1; ++n3) {
            double d;
            double d2;
            int n5;
            int n6 = n3 + 1;
            int n7 = n3;
            for (n5 = n6; n5 < n; ++n5) {
                if (!(Math.abs(dArray[n5][n3]) + Math.abs(dArray2[n5][n3]) > Math.abs(dArray[n7][n3]) + Math.abs(dArray2[n7][n3]))) continue;
                n7 = n5;
            }
            nArray[n3] = n7;
            double d3 = dArray[n7][n3];
            double d4 = dArray2[n7][n3];
            if (n7 != n3) {
                nArray[n - 1] = -nArray[n - 1];
                dArray[n7][n3] = dArray[n3][n3];
                dArray2[n7][n3] = dArray2[n3][n3];
                dArray[n3][n3] = d3;
                dArray2[n3][n3] = d4;
            }
            if (Math.abs(d3) + Math.abs(d4) == 0.0) {
                n4 = n3;
                nArray[n - 1] = 0;
                return n4;
            }
            double d5 = d3 * d3 + d4 * d4;
            d3 /= d5;
            d4 /= -d5;
            for (n5 = n6; n5 < n; ++n5) {
                d2 = dArray[n5][n3] * d3 - dArray2[n5][n3] * d4;
                d = dArray2[n5][n3] * d3 + dArray[n5][n3] * d4;
                dArray[n5][n3] = -d2;
                dArray2[n5][n3] = -d;
            }
            for (int i = n6; i < n; ++i) {
                d3 = dArray[n7][i];
                d4 = dArray2[n7][i];
                dArray[n7][i] = dArray[n3][i];
                dArray2[n7][i] = dArray2[n3][i];
                dArray[n3][i] = d3;
                dArray2[n3][i] = d4;
                if (Math.abs(d3) + Math.abs(d4) == 0.0) continue;
                if (d4 == 0.0) {
                    for (n5 = n6; n5 < n; ++n5) {
                        d2 = dArray[n5][n3] * d3;
                        d = dArray2[n5][n3] * d3;
                        double[] dArray3 = dArray[n5];
                        int n8 = i;
                        dArray3[n8] = dArray3[n8] + d2;
                        double[] dArray4 = dArray2[n5];
                        int n9 = i;
                        dArray4[n9] = dArray4[n9] + d;
                    }
                    continue;
                }
                if (d3 == 0.0) {
                    for (n5 = n6; n5 < n; ++n5) {
                        d2 = -dArray2[n5][n3] * d4;
                        d = dArray[n5][n3] * d4;
                        double[] dArray5 = dArray[n5];
                        int n10 = i;
                        dArray5[n10] = dArray5[n10] + d2;
                        double[] dArray6 = dArray2[n5];
                        int n11 = i;
                        dArray6[n11] = dArray6[n11] + d;
                    }
                    continue;
                }
                for (n5 = n6; n5 < n; ++n5) {
                    d2 = dArray[n5][n3] * d3 - dArray2[n5][n3] * d4;
                    d = dArray2[n5][n3] * d3 + dArray[n5][n3] * d4;
                    double[] dArray7 = dArray[n5];
                    int n12 = i;
                    dArray7[n12] = dArray7[n12] + d2;
                    double[] dArray8 = dArray2[n5];
                    int n13 = i;
                    dArray8[n13] = dArray8[n13] + d;
                }
            }
        }
        n3 = n - 1;
        if (Math.abs(dArray[n - 1][n - 1]) + Math.abs(dArray2[n - 1][n - 1]) == 0.0) {
            n4 = n3;
            nArray[n - 1] = 0;
        }
        return n4;
    }

    public void solc(int n, int n2, double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int[] nArray) {
        double d;
        double d2;
        double d3;
        int n3;
        double d4;
        double d5;
        int n4;
        for (n4 = 0; n4 < n - 1; ++n4) {
            int n5 = n4 + 1;
            int n6 = nArray[n4];
            d5 = dArray3[n6];
            d4 = dArray4[n6];
            dArray3[n6] = dArray3[n4];
            dArray4[n6] = dArray4[n4];
            dArray3[n4] = d5;
            dArray4[n4] = d4;
            n3 = n5;
            while (n3 < n) {
                d3 = dArray[n3][n4] * d5 - dArray2[n3][n4] * d4;
                d2 = dArray2[n3][n4] * d5 + dArray[n3][n4] * d4;
                int n7 = n3;
                dArray3[n7] = dArray3[n7] + d3;
                int n8 = n3++;
                dArray4[n8] = dArray4[n8] + d2;
            }
        }
        for (int i = 1; i <= n - 1; ++i) {
            int n9;
            n4 = n9 = n - i;
            d = dArray[n4][n4] * dArray[n4][n4] + dArray2[n4][n4] * dArray2[n4][n4];
            d3 = dArray3[n4] * dArray[n4][n4] + dArray4[n4] * dArray2[n4][n4];
            d2 = dArray4[n4] * dArray[n4][n4] - dArray3[n4] * dArray2[n4][n4];
            dArray3[n4] = d3 / d;
            dArray4[n4] = d2 / d;
            d5 = -dArray3[n4];
            d4 = -dArray4[n4];
            n3 = 0;
            while (n3 < n9) {
                d3 = dArray[n3][n4] * d5 - dArray2[n3][n4] * d4;
                d2 = dArray2[n3][n4] * d5 + dArray[n3][n4] * d4;
                int n10 = n3;
                dArray3[n10] = dArray3[n10] + d3;
                int n11 = n3++;
                dArray4[n11] = dArray4[n11] + d2;
            }
        }
        d = dArray[0][0] * dArray[0][0] + dArray2[0][0] * dArray2[0][0];
        d3 = dArray3[0] * dArray[0][0] + dArray4[0] * dArray2[0][0];
        d2 = dArray4[0] * dArray[0][0] - dArray3[0] * dArray2[0][0];
        dArray3[0] = d3 / d;
        dArray4[0] = d2 / d;
    }

    static class Mathadd {
        public static double sign(double d) {
            if (d > 0.0) {
                return 1.0;
            }
            if (d < 0.0) {
                return -1.0;
            }
            return 0.0;
        }

        public static double sign(double d, double d2) {
            if (d2 >= 0.0) {
                return Math.abs(d);
            }
            return -Math.abs(d);
        }
    }
}

