/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.ExplicitRKSolver;
import org.opensourcephysics.ode.ODEInterpolator;

public class Dopri5
extends ExplicitRKSolver
implements ODEInterpolator {
    static final double[][] a = new double[][]{{0.2}, {0.075, 0.225}, {0.9777777777777777, -3.7333333333333334, 3.5555555555555554}, {2.9525986892242035, -11.595793324188385, 9.822892851699436, -0.2908093278463649}, {2.8462752525252526, -10.757575757575758, 8.906422717743473, 0.2784090909090909, -0.2735313036020583}};
    static final double[] b = new double[]{0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096};
    static final double[] er = new double[]{0.0012326388888888888, 0.0, -0.0042527702905061394, 0.03697916666666667, -0.05086379716981132, 0.0419047619047619, -0.025};
    static final double[] dense = new double[]{-1.1270175653862835, 0.0, 2.675424484351598, -5.685526961588504, 3.5219323679207912, -1.7672812570757455, 2.382468931778144};
    private double[][] coeffs;

    public Dopri5(ODE oDE) {
        super(oDE, a, b, 5, 6, 1);
        this.coeffs = new double[5][this.numEqn];
        this.initialize(this.stepSize);
    }

    protected double estimateError() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.tolerance;
        double d5 = this.tolerance;
        this.ode.getRate(this.state, this.intermidiateStages[6]);
        for (int i = 0; i < this.numEqn; ++i) {
            d3 = d4 + d5 * Math.max(Math.abs(this.state[i]), Math.abs(this.initialState[i]));
            d = 0.0;
            for (int j = 0; j < this.nStages + 1; ++j) {
                d += er[j] * this.intermidiateStages[j][i];
            }
            d2 += Math.pow(d / d3, 2.0);
        }
        d2 = Math.sqrt(d2 / (double)this.numEqn);
        return d2;
    }

    public void doInterpolation(double d, double[] dArray) {
        if (!this.interpolationIsValid) {
            this.interpolationIsValid = true;
            for (int i = 0; i < this.numEqn; ++i) {
                this.coeffs[0][i] = this.initialState[i];
                this.coeffs[1][i] = this.state[i] - this.initialState[i];
                this.coeffs[2][i] = this.takenStepSize * this.intermidiateStages[0][i] - this.coeffs[1][i];
                this.coeffs[3][i] = this.coeffs[1][i] - this.takenStepSize * this.intermidiateStages[6][i] - this.coeffs[2][i];
                this.coeffs[4][i] = 0.0;
                for (int j = 0; j < 7; ++j) {
                    double[] dArray2 = this.coeffs[4];
                    int n = i;
                    dArray2[n] = dArray2[n] + this.takenStepSize * dense[j] * this.intermidiateStages[j][i];
                }
            }
        }
        double d2 = d / this.takenStepSize;
        double d3 = 1.0 - d2;
        if (dArray != this.state) {
            for (int i = 0; i < this.numEqn; ++i) {
                dArray[i] = this.coeffs[0][i] + d2 * (this.coeffs[1][i] + d3 * (this.coeffs[2][i] + d2 * (this.coeffs[3][i] + d3 * this.coeffs[4][i])));
            }
        } else {
            System.err.println("Can't interpolate to the internal state vector. Please call initialize(double, double []) method");
        }
    }
}

