/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Verlet
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private int rateCounter = -1;

    public Verlet(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.rateCounter = -1;
    }

    public int getRateCounter() {
        return this.rateCounter;
    }

    public double step() {
        int n;
        double[] dArray = this.ode.getState();
        if (dArray.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.rateCounter = 0;
        this.ode.getRate(dArray, this.rate1);
        double d = this.stepSize * this.stepSize;
        for (n = 0; n < this.numEqn - 1; n += 2) {
            int n2 = n;
            dArray[n2] = dArray[n2] + (this.stepSize * this.rate1[n] + d * this.rate1[n + 1] / 2.0);
        }
        this.rateCounter = 1;
        this.ode.getRate(dArray, this.rate2);
        this.rateCounter = 2;
        for (n = 1; n < this.numEqn; n += 2) {
            int n3 = n;
            dArray[n3] = dArray[n3] + this.stepSize * (this.rate1[n] + this.rate2[n]) / 2.0;
        }
        if (this.numEqn % 2 == 1) {
            int n4 = this.numEqn - 1;
            dArray[n4] = dArray[n4] + this.stepSize * this.rate1[this.numEqn - 1];
        }
        return this.stepSize;
    }
}

