/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.Hashtable;
import java.util.Vector;
import org.opensourcephysics.numerics.MathExpParser;
import org.opensourcephysics.numerics.ParserException;

public final class SuryonoParser
extends MathExpParser {
    private int var_count;
    private String[] var_name;
    private double[] var_value;
    private double[] number;
    private String function = "";
    private String postfix_code = "";
    private boolean valid = false;
    private int error;
    private boolean ISBOOLEAN = false;
    private boolean INRELATION = false;
    private int position;
    private int start;
    private int num;
    private char character;
    private boolean radian;
    private int numberindex;
    private double[] refvalue = null;
    private static final int MAX_NUM = 200;
    private static final int NO_FUNCS = 26;
    private static final int NO_EXT_FUNCS = 4;
    private static final int STACK_SIZE = 50;
    private double[] stack = new double[50];
    private static final double DEGTORAD = Math.PI / 180;
    private static final double LOG10 = Math.log(10.0);
    private Hashtable references = null;
    private Vector refnames = null;
    public static final int PAREN_EXPECTED = 2;
    public static final int UNCOMPILED_FUNCTION = 3;
    public static final int EXPRESSION_EXPECTED = 4;
    public static final int UNKNOWN_IDENTIFIER = 5;
    public static final int OPERATOR_EXPECTED = 6;
    public static final int PAREN_NOT_MATCH = 7;
    public static final int CODE_DAMAGED = 8;
    public static final int STACK_OVERFLOW = 9;
    public static final int TOO_MANY_CONSTS = 10;
    public static final int COMMA_EXPECTED = 11;
    public static final int INVALID_OPERAND = 12;
    public static final int INVALID_OPERATOR = 13;
    public static final int NO_FUNC_DEFINITION = 14;
    public static final int REF_NAME_EXPECTED = 15;
    private static final int FUNC_OFFSET = 1000;
    private static final int EXT_FUNC_OFFSET = 1026;
    private static final int VAR_OFFSET = 2000;
    private static final int REF_OFFSET = 3000;
    private static final char PI_CODE = '\u00fd';
    private static final char E_CODE = '\u00fe';
    private static final char NUMERIC = '\u00ff';
    private static final char JUMP_CODE = '\u0001';
    private static final char LESS_THAN = '\u0002';
    private static final char GREATER_THAN = '\u0003';
    private static final char LESS_EQUAL = '\u0004';
    private static final char GREATER_EQUAL = '\u0005';
    private static final char NOT_EQUAL = '\u0006';
    private static final char EQUAL = '\u0007';
    private static final char IF_CODE = '\b';
    private static final char ENDIF = '\t';
    private static final char AND_CODE = '\n';
    private static final char OR_CODE = '\u000b';
    private static final char NOT_CODE = '\f';
    private String[] funcname = new String[]{"sin", "cos", "tan", "ln", "log", "abs", "int", "frac", "asin", "acos", "atan", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "ceil", "floor", "round", "exp", "sqr", "sqrt", "sign", "step", "random"};
    private String[] extfunc = new String[]{"min", "max", "mod", "atan2"};
    boolean appendVariables = false;

    public SuryonoParser(String string, String string2) throws ParserException {
        this(1);
        this.defineVariable(1, string2);
        this.define(string);
        this.parse();
        if (this.getErrorCode() != 0) {
            String string3 = "Error in function string: " + string;
            string3 = string3 + '\n' + "Error: " + this.getErrorString();
            string3 = string3 + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(string3);
        }
    }

    public SuryonoParser(String string, String string2, String string3) throws ParserException {
        this(2);
        this.defineVariable(1, string2);
        this.defineVariable(2, string3);
        this.define(string);
        this.parse();
        if (this.getErrorCode() != 0) {
            String string4 = "Error in function string: " + string;
            string4 = string4 + '\n' + "Error: " + this.getErrorString();
            string4 = string4 + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(string4);
        }
    }

    public SuryonoParser(String string, String[] stringArray) throws ParserException {
        this(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.defineVariable(i + 1, stringArray[i]);
        }
        this.define(string);
        this.parse();
        if (this.getErrorCode() != 0) {
            String string2 = "Error in function string: " + string;
            string2 = string2 + '\n' + "Error: " + this.getErrorString();
            string2 = string2 + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(string2);
        }
    }

    public SuryonoParser(int n) {
        this.var_count = n;
        this.references = new Hashtable();
        this.refnames = new Vector();
        this.radian = true;
        this.var_name = new String[n];
        this.var_value = new double[n];
        this.number = new double[200];
    }

    public void setToZero() {
        try {
            this.setFunction("0");
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    public void useRadian() {
        this.radian = true;
    }

    public void useDegree() {
        this.radian = false;
    }

    private String removeEscapeCharacter(String string) {
        if (string == null || string.length() < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public void defineVariable(int n, String string) {
        if (n > this.var_count) {
            return;
        }
        this.var_name[n - 1] = string;
    }

    public void setVariable(int n, double d) {
        if (n > this.var_count) {
            return;
        }
        this.var_value[n - 1] = d;
    }

    public void setVariable(String string, double d) {
        for (int i = 0; i < this.var_count; ++i) {
            if (!this.var_name[i].equals(string)) continue;
            this.var_value[i] = d;
            break;
        }
    }

    public void define(String string) {
        this.function = string;
        this.function.toLowerCase();
        this.function = this.removeEscapeCharacter(this.function);
        this.valid = false;
    }

    public void parse(String string) throws ParserException {
        this.define(string);
        this.parse();
        if (this.getErrorCode() != 0) {
            String string2 = "Error in function string: " + string;
            string2 = string2 + '\n' + "Error: " + this.getErrorString();
            string2 = string2 + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(string2);
        }
    }

    public String[] parseUnknown(String string) throws ParserException {
        this.var_name = new String[0];
        this.var_value = new double[0];
        this.var_count = 0;
        this.appendVariables = true;
        this.define(string);
        this.parse();
        if (this.getErrorCode() != 0) {
            String string2 = "Error in function string: " + string;
            string2 = string2 + '\n' + "Error: " + this.getErrorString();
            string2 = string2 + '\n' + "Position: " + this.getErrorPosition();
            this.appendVariables = false;
            throw new ParserException(string2);
        }
        this.appendVariables = false;
        return this.var_name;
    }

    public String[] getVariableNames() {
        return this.var_name;
    }

    public void parse() {
        int n;
        String string = new String(this.function);
        String string2 = new String(this.function);
        if (this.valid) {
            return;
        }
        this.num = 0;
        this.error = 0;
        this.references.clear();
        this.refnames.removeAllElements();
        while ((n = string.lastIndexOf(";")) != -1) {
            this.function = string.substring(n + 1) + ')';
            string = string.substring(0, n++);
            String string3 = null;
            int n2 = this.function.indexOf(":");
            if (n2 == -1) {
                this.error = 14;
                this.position = 0;
                while (this.position < this.function.length() && this.function.charAt(this.position) == ' ') {
                    ++this.position;
                }
                ++this.position;
            } else {
                string3 = this.function.substring(0, n2);
                this.function = this.function.substring(n2 + 1);
                if ((string3 = string3.trim()).equals("")) {
                    this.error = 15;
                    this.position = 1;
                } else {
                    n += ++n2;
                    this.parseSubFunction();
                }
            }
            if (this.error != 0) {
                this.position += n;
                break;
            }
            this.references.put(string3, this.postfix_code);
            this.refnames.addElement(string3);
        }
        if (this.error == 0) {
            this.function = string + ')';
            this.parseSubFunction();
        }
        this.function = string2;
        this.valid = this.error == 0;
    }

    public double evaluate(double d, double d2) {
        if (this.var_count != 2) {
            return 0.0;
        }
        this.var_value[0] = d;
        this.var_value[1] = d2;
        return this.evaluate();
    }

    public double evaluate(double d, double d2, double d3) {
        if (this.var_count != 3) {
            return 0.0;
        }
        this.var_value[0] = d;
        this.var_value[1] = d2;
        this.var_value[2] = d3;
        return this.evaluate();
    }

    public double evaluate(double d) {
        if (this.var_count != 1) {
            return 0.0;
        }
        this.var_value[0] = d;
        return this.evaluate();
    }

    public double evaluate(double[] dArray) {
        if (this.var_value.length != dArray.length) {
            System.out.println("JEParser Error: incorrect number of variables.");
            return 0.0;
        }
        System.arraycopy(dArray, 0, this.var_value, 0, dArray.length);
        return this.evaluate();
    }

    public double evaluate() {
        double d;
        int n = this.refnames.size();
        if (!this.valid) {
            this.error = 3;
            return 0.0;
        }
        this.error = 0;
        this.numberindex = 0;
        if (n != 0) {
            String string = this.postfix_code;
            this.refvalue = new double[n];
            for (int i = 0; i < this.refnames.size(); ++i) {
                String string2 = (String)this.refnames.elementAt(i);
                this.postfix_code = (String)this.references.get(string2);
                d = this.evaluateSubFunction();
                if (this.error != 0) {
                    this.postfix_code = string;
                    this.refvalue = null;
                    return d;
                }
                this.refvalue[i] = d;
            }
            this.postfix_code = string;
        }
        d = this.evaluateSubFunction();
        this.refvalue = null;
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorString() {
        return SuryonoParser.toErrorString(this.error);
    }

    public int getErrorPosition() {
        return this.position;
    }

    public static String toErrorString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "no error";
                break;
            }
            case 1: {
                string = "syntax error";
                break;
            }
            case 2: {
                string = "parenthesis expected";
                break;
            }
            case 3: {
                string = "uncompiled function";
                break;
            }
            case 4: {
                string = "expression expected";
                break;
            }
            case 5: {
                string = "unknown identifier";
                break;
            }
            case 6: {
                string = "operator expected";
                break;
            }
            case 7: {
                string = "parentheses not match";
                break;
            }
            case 8: {
                string = "internal code damaged";
                break;
            }
            case 9: {
                string = "execution stack overflow";
                break;
            }
            case 10: {
                string = "too many constants";
                break;
            }
            case 11: {
                string = "comma expected";
                break;
            }
            case 12: {
                string = "invalid operand type";
                break;
            }
            case 13: {
                string = "invalid operator";
                break;
            }
            case 14: {
                string = "bad reference definition (: expected)";
                break;
            }
            case 15: {
                string = "reference name expected";
            }
        }
        return string;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String string) throws ParserException {
        this.function = string;
        this.define(this.function);
        this.parse();
        if (this.error != 0) {
            String string2 = "Error in function string: " + string;
            string2 = string2 + '\n' + "Error: " + SuryonoParser.toErrorString(this.error);
            string2 = string2 + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(string2);
        }
    }

    public void setFunction(String string, String[] stringArray) throws ParserException {
        this.function = string;
        if (stringArray.length != this.var_count) {
            this.var_count = stringArray.length;
            this.references.clear();
            this.refnames.clear();
            this.var_name = new String[this.var_count];
            this.var_value = new double[this.var_count];
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.defineVariable(i + 1, stringArray[i]);
        }
        this.define(this.function);
        this.parse();
        if (this.error != 0) {
            String string2 = "Error in function string: " + string;
            string2 = string2 + '\n' + "Error: " + SuryonoParser.toErrorString(this.error);
            string2 = string2 + '\n' + "Position: " + this.getErrorPosition();
            throw new ParserException(string2);
        }
    }

    private void skipSpaces() throws ParserException {
        try {
            while (this.function.charAt(this.position - 1) == ' ') {
                ++this.position;
            }
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParserException(7);
        }
    }

    private void getNextCharacter() throws ParserException {
        ++this.position;
        try {
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParserException(7);
        }
    }

    private void addCode(char c) {
        this.postfix_code = this.postfix_code + c;
    }

    private void scanNumber() throws ParserException {
        double d;
        String string = "";
        if (this.num == 200) {
            throw new ParserException(10);
        }
        if (this.character != '.') {
            do {
                string = string + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        } else {
            string = string + '0';
        }
        if (this.character == '.') {
            do {
                string = string + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        }
        if (this.character == 'e' || this.character == 'E') {
            string = string + this.character;
            this.getNextCharacter();
            if (this.character == '+' || this.character == '-') {
                string = string + this.character;
                this.getNextCharacter();
            }
            while (this.character >= '0' && this.character <= '9') {
                string = string + this.character;
                this.getNextCharacter();
            }
        }
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.start;
            throw new ParserException(1);
        }
        this.number[this.num++] = d;
        this.addCode('\u00ff');
    }

    private void scanNonNumeric() throws ParserException {
        int n;
        String string = "";
        if (this.character == '*' || this.character == '/' || this.character == '^' || this.character == ')' || this.character == ',' || this.character == '<' || this.character == '>' || this.character == '=' || this.character == '&' || this.character == '|') {
            throw new ParserException(1);
        }
        do {
            string = string + this.character;
            this.getNextCharacter();
        } while (this.character != ' ' && this.character != '+' && this.character != '-' && this.character != '*' && this.character != '/' && this.character != '^' && this.character != '(' && this.character != ')' && this.character != ',' && this.character != '<' && this.character != '>' && this.character != '=' && this.character != '&' && this.character != '|');
        if (string.equals("pi")) {
            this.addCode('\u00fd');
            return;
        }
        if (string.equals("e")) {
            this.addCode('\u00fe');
            return;
        }
        if (string.equals("if")) {
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ',') {
                throw new ParserException(11);
            }
            this.addCode('\b');
            String string2 = new String(this.postfix_code);
            this.postfix_code = "";
            this.scanAndParse();
            if (this.character != ',') {
                throw new ParserException(11);
            }
            this.addCode('\u0001');
            string2 = string2 + (char)(this.postfix_code.length() + 2);
            string2 = string2 + this.postfix_code;
            this.postfix_code = "";
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            string2 = string2 + (char)(this.postfix_code.length() + 1);
            string2 = string2 + this.postfix_code;
            this.postfix_code = new String(string2);
            this.getNextCharacter();
            return;
        }
        for (n = 0; n < 26; ++n) {
            if (!string.equals(this.funcname[n])) continue;
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            this.getNextCharacter();
            this.addCode((char)(n + 1000));
            return;
        }
        for (n = 0; n < 4; ++n) {
            if (!string.equals(this.extfunc[n])) continue;
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ',') {
                throw new ParserException(11);
            }
            String string3 = new String(this.postfix_code);
            this.postfix_code = "";
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            this.getNextCharacter();
            string3 = string3 + this.postfix_code;
            this.postfix_code = new String(string3);
            this.addCode((char)(n + 1026));
            return;
        }
        for (n = 0; n < this.var_count; ++n) {
            if (!string.equals(this.var_name[n])) continue;
            this.addCode((char)(n + 2000));
            return;
        }
        n = this.refnames.indexOf(string);
        if (n != -1) {
            this.addCode((char)(n + 3000));
            return;
        }
        if (this.appendVariables && this.append(string)) {
            return;
        }
        this.position = this.start;
        throw new ParserException(5);
    }

    private boolean append(String string) {
        String[] stringArray = new String[this.var_count + 1];
        double[] dArray = new double[this.var_count + 1];
        System.arraycopy(this.var_name, 0, stringArray, 0, this.var_count);
        System.arraycopy(this.var_value, 0, dArray, 0, this.var_count);
        stringArray[this.var_count] = string;
        this.var_name = stringArray;
        this.var_value = dArray;
        ++this.var_count;
        for (int i = 0; i < this.var_count; ++i) {
            if (!string.equals(this.var_name[i])) continue;
            this.addCode((char)(i + 2000));
            return true;
        }
        return false;
    }

    private boolean getIdentifier() throws ParserException {
        boolean bl = false;
        this.getNextCharacter();
        this.skipSpaces();
        if (this.character == '!') {
            this.getNextCharacter();
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            if (!this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            this.addCode('\f');
            this.getNextCharacter();
            return false;
        }
        this.ISBOOLEAN = false;
        while (this.character == '+' || this.character == '-') {
            if (this.character == '-') {
                bl = !bl;
            }
            this.getNextCharacter();
            this.skipSpaces();
        }
        this.start = this.position;
        if (this.character >= '0' && this.character <= '9' || this.character == '.') {
            this.scanNumber();
        } else if (this.character == '(') {
            this.scanAndParse();
            this.getNextCharacter();
        } else {
            this.scanNonNumeric();
        }
        this.skipSpaces();
        return bl;
    }

    private void arithmeticLevel3() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        boolean bl = this.getIdentifier();
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        if (this.character == '^') {
            this.arithmeticLevel3();
        }
        this.addCode('^');
        if (bl) {
            this.addCode('_');
        }
    }

    private void arithmeticLevel2() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char c = this.character;
            boolean bl = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (this.character == '^') {
                this.arithmeticLevel3();
            }
            if (bl) {
                this.addCode('_');
            }
            this.addCode(c);
        } while (this.character == '*' || this.character == '/');
    }

    private void arithmeticLevel1() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char c = this.character;
            boolean bl = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (this.character == '^') {
                this.arithmeticLevel3();
                if (bl) {
                    this.addCode('_');
                }
            } else if (this.character == '*' || this.character == '/') {
                if (bl) {
                    this.addCode('_');
                }
                this.arithmeticLevel2();
            }
            this.addCode(c);
        } while (this.character == '+' || this.character == '-');
    }

    private void relationLevel() throws ParserException {
        int n = 0;
        if (this.INRELATION) {
            throw new ParserException(13);
        }
        this.INRELATION = true;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (this.character) {
            case '=': {
                n = 7;
                break;
            }
            case '<': {
                n = 2;
                this.getNextCharacter();
                if (this.character == '>') {
                    n = 6;
                    break;
                }
                if (this.character == '=') {
                    n = 4;
                    break;
                }
                --this.position;
                break;
            }
            case '>': {
                n = 3;
                this.getNextCharacter();
                if (this.character == '=') {
                    n = 5;
                    break;
                }
                --this.position;
            }
        }
        this.scanAndParse();
        this.INRELATION = false;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        this.addCode((char)n);
        this.ISBOOLEAN = true;
    }

    private void booleanLevel() throws ParserException {
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        char c = this.character;
        this.scanAndParse();
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (c) {
            case '&': {
                this.addCode('\n');
                break;
            }
            case '|': {
                this.addCode('\u000b');
            }
        }
    }

    private void scanAndParse() throws ParserException {
        boolean bl = this.getIdentifier();
        if (this.character != '^' && bl) {
            this.addCode('_');
        }
        block8: while (true) {
            switch (this.character) {
                case '+': 
                case '-': {
                    this.arithmeticLevel1();
                    continue block8;
                }
                case '*': 
                case '/': {
                    this.arithmeticLevel2();
                    continue block8;
                }
                case '^': {
                    this.arithmeticLevel3();
                    if (!bl) continue block8;
                    this.addCode('_');
                    continue block8;
                }
                case ')': 
                case ',': {
                    return;
                }
                case '<': 
                case '=': 
                case '>': {
                    this.relationLevel();
                    continue block8;
                }
                case '&': 
                case '|': {
                    this.booleanLevel();
                    continue block8;
                }
            }
            break;
        }
        throw new ParserException(6);
    }

    private void parseSubFunction() {
        block3: {
            this.position = 0;
            this.postfix_code = "";
            this.INRELATION = false;
            this.ISBOOLEAN = false;
            try {
                this.scanAndParse();
            }
            catch (ParserException parserException) {
                this.error = parserException.getErrorCode();
                if (this.error != 1 || this.postfix_code != "") break block3;
                this.error = 4;
            }
        }
        if (this.error == 0 && this.position != this.function.length()) {
            this.error = 7;
        }
    }

    private double builtInFunction(int n, double d) {
        switch (n) {
            case 0: {
                if (this.radian) {
                    return Math.sin(d);
                }
                return Math.sin(d * (Math.PI / 180));
            }
            case 1: {
                if (this.radian) {
                    return Math.cos(d);
                }
                return Math.cos(d * (Math.PI / 180));
            }
            case 2: {
                if (this.radian) {
                    return Math.tan(d);
                }
                return Math.tan(d * (Math.PI / 180));
            }
            case 3: {
                return Math.log(d);
            }
            case 4: {
                return Math.log(d) / LOG10;
            }
            case 5: {
                return Math.abs(d);
            }
            case 6: {
                return Math.rint(d);
            }
            case 7: {
                return d - Math.rint(d);
            }
            case 8: {
                if (this.radian) {
                    return Math.asin(d);
                }
                return Math.asin(d) / (Math.PI / 180);
            }
            case 9: {
                if (this.radian) {
                    return Math.acos(d);
                }
                return Math.acos(d) / (Math.PI / 180);
            }
            case 10: {
                if (this.radian) {
                    return Math.atan(d);
                }
                return Math.atan(d) / (Math.PI / 180);
            }
            case 11: {
                return (Math.exp(d) - Math.exp(-d)) / 2.0;
            }
            case 12: {
                return (Math.exp(d) + Math.exp(-d)) / 2.0;
            }
            case 13: {
                double d2 = Math.exp(d);
                double d3 = Math.exp(-d);
                return (d2 - d3) / (d2 + d3);
            }
            case 14: {
                return Math.log(d + Math.sqrt(d * d + 1.0));
            }
            case 15: {
                return Math.log(d + Math.sqrt(d * d - 1.0));
            }
            case 16: {
                return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
            }
            case 17: {
                return Math.ceil(d);
            }
            case 18: {
                return Math.floor(d);
            }
            case 19: {
                return Math.round(d);
            }
            case 20: {
                return Math.exp(d);
            }
            case 21: {
                return d * d;
            }
            case 22: {
                return Math.sqrt(d);
            }
            case 23: {
                if (d == 0.0) {
                    return 0.0;
                }
                if (d > 0.0) {
                    return 1.0;
                }
                return -1.0;
            }
            case 24: {
                if (d < 0.0) {
                    return 0.0;
                }
                return 1.0;
            }
            case 25: {
                return d * Math.random();
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInExtFunction(int n, double d, double d2) {
        switch (n) {
            case 0: {
                return Math.min(d, d2);
            }
            case 1: {
                return Math.max(d, d2);
            }
            case 2: {
                return Math.IEEEremainder(d, d2);
            }
            case 3: {
                return Math.atan2(d, d2);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double evaluateSubFunction() {
        int n = -1;
        int n2 = 0;
        int n3 = this.postfix_code.length();
        block28: while (true) {
            char c;
            try {
                if (n2 == n3) {
                    return this.stack[0];
                }
                c = this.postfix_code.charAt(n2++);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return this.stack[0];
            }
            try {
                switch (c) {
                    case '+': {
                        int n4 = n - 1;
                        this.stack[n4] = this.stack[n4] + this.stack[n];
                        --n;
                        continue block28;
                    }
                    case '-': {
                        int n5 = n - 1;
                        this.stack[n5] = this.stack[n5] - this.stack[n];
                        --n;
                        continue block28;
                    }
                    case '*': {
                        int n6 = n - 1;
                        this.stack[n6] = this.stack[n6] * this.stack[n];
                        --n;
                        continue block28;
                    }
                    case '/': {
                        if (this.stack[n] != 0.0) {
                            int n7 = n - 1;
                            this.stack[n7] = this.stack[n7] / this.stack[n];
                        } else {
                            int n8 = n - 1;
                            this.stack[n8] = this.stack[n8] / 1.0E-128;
                        }
                        --n;
                        continue block28;
                    }
                    case '^': {
                        this.stack[n - 1] = Math.pow(this.stack[n - 1], this.stack[n]);
                        --n;
                        continue block28;
                    }
                    case '_': {
                        this.stack[n] = -this.stack[n];
                        continue block28;
                    }
                    case '\u0001': {
                        int n9 = n2 + this.postfix_code.charAt(n2++);
                        while (true) {
                            if (n2 >= n9) continue block28;
                            if (this.postfix_code.charAt(n2++) != '\u00ff') continue;
                            ++this.numberindex;
                        }
                    }
                    case '\u0002': {
                        double d = this.stack[--n] < this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block28;
                    }
                    case '\u0003': {
                        double d = this.stack[--n] > this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block28;
                    }
                    case '\u0004': {
                        double d = this.stack[--n] <= this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block28;
                    }
                    case '\u0005': {
                        double d = this.stack[--n] >= this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block28;
                    }
                    case '\u0007': {
                        double d = this.stack[--n] == this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block28;
                    }
                    case '\u0006': {
                        double d = this.stack[--n] != this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block28;
                    }
                    case '\b': {
                        int n9;
                        if (this.stack[n--] == 0.0) {
                            n9 = n2 + this.postfix_code.charAt(n2++);
                            while (true) {
                                if (n2 >= n9) continue block28;
                                if (this.postfix_code.charAt(n2++) != '\u00ff') continue;
                                ++this.numberindex;
                            }
                        }
                        ++n2;
                        continue block28;
                    }
                    case '\t': {
                        continue block28;
                    }
                    case '\n': {
                        if (this.stack[--n] != 0.0 && this.stack[n + 1] != 0.0) {
                            this.stack[n] = 1.0;
                            continue block28;
                        }
                        this.stack[n] = 0.0;
                        continue block28;
                    }
                    case '\u000b': {
                        if (this.stack[--n] != 0.0 || this.stack[n + 1] != 0.0) {
                            this.stack[n] = 1.0;
                            continue block28;
                        }
                        this.stack[n] = 0.0;
                        continue block28;
                    }
                    case '\f': {
                        this.stack[n] = this.stack[n] == 0.0 ? 1.0 : 0.0;
                        continue block28;
                    }
                    case '\u00ff': {
                        this.stack[++n] = this.number[this.numberindex++];
                        continue block28;
                    }
                    case '\u00fd': {
                        this.stack[++n] = Math.PI;
                        continue block28;
                    }
                    case '\u00fe': {
                        this.stack[++n] = Math.E;
                        continue block28;
                    }
                }
                if (c >= '\u0bb8') {
                    this.stack[++n] = this.refvalue[c - 3000];
                    continue;
                }
                if (c >= '\u07d0') {
                    this.stack[++n] = this.var_value[c - 2000];
                    continue;
                }
                if (c >= '\u0402') {
                    this.stack[n - 1] = this.builtInExtFunction(c - 1026, this.stack[n - 1], this.stack[n]);
                    --n;
                    continue;
                }
                if (c < '\u03e8') {
                    this.error = 8;
                    return Double.NaN;
                }
                this.stack[n] = this.builtInFunction(c - 1000, this.stack[n]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.error = 9;
                return Double.NaN;
            }
            catch (NullPointerException nullPointerException) {
                this.error = 8;
                return Double.NaN;
            }
        }
    }
}

