/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.MatrixTransformation;
import org.opensourcephysics.numerics.Vec3D;
import org.opensourcephysics.numerics.VectorMath;

public class Quaternion
implements MatrixTransformation {
    static final double SQRT2 = Math.sqrt(2.0);
    double q0;
    double q1;
    double q2;
    double q3;
    double ox = 0.0;
    double oy = 0.0;
    double oz = 0.0;

    public Quaternion(double d, double d2, double d3, double d4) {
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
        this.normalize();
    }

    public Quaternion(double d, Vec3D vec3D) {
        this(d, vec3D.x, vec3D.y, vec3D.z);
    }

    public Quaternion(double[] dArray) {
        this.q0 = dArray[0];
        this.q1 = dArray[1];
        this.q2 = dArray[2];
        this.q3 = dArray[3];
        this.normalize();
    }

    public Quaternion(Quaternion quaternion) {
        this.q0 = quaternion.q0;
        this.q1 = quaternion.q1;
        this.q2 = quaternion.q2;
        this.q3 = quaternion.q3;
        this.normalize();
    }

    public Quaternion() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public static Quaternion createAlignmentTransformation(double[] dArray, double[] dArray2) {
        dArray = VectorMath.normalize((double[])dArray.clone());
        dArray2 = VectorMath.normalize((double[])dArray2.clone());
        double[] dArray3 = VectorMath.cross3D(dArray, dArray2);
        double d = Math.sqrt(2.0 * (1.0 + VectorMath.dot(dArray, dArray2)));
        return new Quaternion(d / 2.0, dArray3[0] / d, dArray3[1] / d, dArray3[2] / d);
    }

    public void setOrigin(double d, double d2, double d3) {
        this.ox = d;
        this.oy = d2;
        this.oz = d3;
    }

    public double[] setOrigin(double[] dArray) {
        this.ox = dArray[0];
        this.oy = dArray[1];
        this.oz = dArray[2];
        return dArray;
    }

    public final double[][] getRotationMatrix(double[][] dArray) {
        double d = this.q0 * this.q0;
        double d2 = this.q0 * this.q1;
        double d3 = this.q0 * this.q2;
        double d4 = this.q0 * this.q3;
        double d5 = this.q1 * this.q1;
        double d6 = this.q1 * this.q2;
        double d7 = this.q1 * this.q3;
        double d8 = this.q2 * this.q2;
        double d9 = this.q2 * this.q3;
        double d10 = this.q3 * this.q3;
        if (dArray == null) {
            dArray = new double[3][3];
        }
        dArray[0][0] = d + d5 - d8 - d10;
        dArray[0][1] = 2.0 * (-d4 + d6);
        dArray[0][2] = 2.0 * (d3 + d7);
        dArray[1][0] = 2.0 * (d4 + d6);
        dArray[1][1] = d - d5 + d8 - d10;
        dArray[1][2] = 2.0 * (-d2 + d9);
        dArray[2][0] = 2.0 * (-d3 + d7);
        dArray[2][1] = 2.0 * (d2 + d9);
        dArray[2][2] = d - d5 - d8 + d10;
        return dArray;
    }

    public final double[] getFlatMatrix(double[] dArray) {
        double d = this.q0 * this.q0;
        double d2 = this.q0 * this.q1;
        double d3 = this.q0 * this.q2;
        double d4 = this.q0 * this.q3;
        double d5 = this.q1 * this.q1;
        double d6 = this.q1 * this.q2;
        double d7 = this.q1 * this.q3;
        double d8 = this.q2 * this.q2;
        double d9 = this.q2 * this.q3;
        double d10 = this.q3 * this.q3;
        if (dArray == null) {
            dArray = new double[16];
        }
        dArray[0] = d + d5 - d8 - d10;
        dArray[4] = 2.0 * (-d4 + d6);
        dArray[8] = 2.0 * (d3 + d7);
        dArray[1] = 2.0 * (d4 + d6);
        dArray[5] = d - d5 + d8 - d10;
        dArray[9] = 2.0 * (-d2 + d9);
        dArray[2] = 2.0 * (-d3 + d7);
        dArray[3] = 0.0;
        dArray[6] = 2.0 * (d2 + d9);
        dArray[7] = 0.0;
        dArray[10] = d - d5 - d8 + d10;
        dArray[11] = 0.0;
        dArray[12] = this.ox - this.ox * dArray[0] - this.oy * dArray[4] - this.oz * dArray[8];
        dArray[13] = this.oy - this.ox * dArray[1] - this.oy * dArray[5] - this.oz * dArray[9];
        dArray[14] = this.oz - this.ox * dArray[2] - this.oy * dArray[6] - this.oz * dArray[10];
        dArray[15] = 1.0;
        return dArray;
    }

    public double[] getCoordinates() {
        return new double[]{this.q0, this.q1, this.q2, this.q3};
    }

    public final void setCoordinates(double d, double d2, double d3, double d4) {
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
        this.normalize();
    }

    public final double[] setCoordinates(double[] dArray) {
        this.q0 = dArray[0];
        this.q1 = dArray[1];
        this.q2 = dArray[2];
        this.q3 = dArray[3];
        this.normalize();
        return dArray;
    }

    public final void normalize() {
        double d = this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
        if (d == 1.0) {
            return;
        }
        d = 1.0 / Math.sqrt(d);
        this.q0 *= d;
        this.q1 *= d;
        this.q2 *= d;
        this.q3 *= d;
    }

    public final void conjugate() {
        this.q1 = -this.q1;
        this.q2 = -this.q2;
        this.q3 = -this.q3;
    }

    public final void add(Quaternion quaternion) {
        this.q0 += this.q0;
        this.q1 += this.q1;
        this.q2 += this.q2;
        this.q3 += this.q3;
    }

    public final void subtract(Quaternion quaternion) {
        this.q0 -= this.q0;
        this.q1 -= this.q1;
        this.q2 -= this.q2;
        this.q3 -= this.q3;
    }

    public final void multiply(Quaternion quaternion) {
        double d = this.q0 * quaternion.q0 - this.q1 * quaternion.q1 - this.q2 * quaternion.q2 - this.q3 * quaternion.q3;
        double d2 = this.q3 * quaternion.q2 - this.q2 * quaternion.q3 + this.q1 * quaternion.q0 + this.q0 * quaternion.q1;
        double d3 = this.q1 * quaternion.q3 - this.q3 * quaternion.q1 + this.q2 * quaternion.q0 + this.q0 * quaternion.q2;
        double d4 = this.q2 * quaternion.q1 - this.q1 * quaternion.q2 + this.q3 * quaternion.q0 + this.q0 * quaternion.q3;
        this.q0 = d;
        this.q1 = d2;
        this.q2 = d3;
        this.q3 = d4;
        this.normalize();
    }

    public final double dot(Quaternion quaternion) {
        return this.q0 * quaternion.q0 + this.q1 * quaternion.q1 + this.q2 * quaternion.q2 + this.q3 * quaternion.q3;
    }

    public final double magnitudeSquared() {
        return this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
    }

    public final double magnitude() {
        return Math.sqrt(this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3);
    }

    public final double angle(Quaternion quaternion) {
        double d = Math.sqrt(this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3);
        double d2 = Math.sqrt(quaternion.q1 * quaternion.q1 + quaternion.q2 * quaternion.q2 + quaternion.q3 * quaternion.q3);
        double d3 = Math.sqrt(1.0 + (this.q1 * quaternion.q1 + this.q2 * quaternion.q2 + this.q3 * quaternion.q3) / d / d2);
        return 2.0 * Math.acos(d3 / SQRT2);
    }

    public Object clone() {
        Quaternion quaternion = new Quaternion(this.q0, this.q1, this.q2, this.q3);
        quaternion.setOrigin(this.ox, this.oy, this.oz);
        return quaternion;
    }

    public double[] direct(double[] dArray) {
        dArray[0] = dArray[0] - this.ox;
        dArray[1] = dArray[1] - this.oy;
        dArray[2] = dArray[2] - this.oz;
        double d = 2.0 * this.q0 * this.q0 - 1.0;
        double d2 = 2.0 * (this.q1 * dArray[0] + this.q2 * dArray[1] + this.q3 * dArray[2]);
        double d3 = 2.0 * this.q0;
        double d4 = d * dArray[0] + d2 * this.q1 + d3 * (this.q2 * dArray[2] - this.q3 * dArray[1]);
        double d5 = d * dArray[1] + d2 * this.q2 + d3 * (this.q3 * dArray[0] - this.q1 * dArray[2]);
        dArray[2] = d * dArray[2] + d2 * this.q3 + d3 * (this.q1 * dArray[1] - this.q2 * dArray[0]) + this.oz;
        dArray[0] = d4 + this.ox;
        dArray[1] = d5 + this.oy;
        return dArray;
    }

    public double[] inverse(double[] dArray) throws UnsupportedOperationException {
        dArray[0] = dArray[0] - this.ox;
        dArray[1] = dArray[1] - this.oy;
        dArray[2] = dArray[2] - this.oz;
        double d = 2.0 * this.q0 * this.q0 - 1.0;
        double d2 = 2.0 * (this.q1 * dArray[0] + this.q2 * dArray[1] + this.q3 * dArray[2]);
        double d3 = -2.0 * this.q0;
        double d4 = d * dArray[0] + d2 * this.q1 + d3 * (this.q2 * dArray[2] - this.q3 * dArray[1]);
        double d5 = d * dArray[1] + d2 * this.q2 + d3 * (this.q3 * dArray[0] - this.q1 * dArray[2]);
        dArray[2] = d * dArray[2] + d2 * this.q3 + d3 * (this.q1 * dArray[1] - this.q2 * dArray[0]) + this.oz;
        dArray[0] = d4 + this.ox;
        dArray[1] = d5 + this.oy;
        return dArray;
    }

    public static XML.ObjectLoader getLoader() {
        return new QuaternionLoader();
    }

    protected static class QuaternionLoader
    extends XMLLoader {
        protected QuaternionLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Quaternion quaternion = (Quaternion)object;
            xMLControl.setValue("q0", quaternion.q0);
            xMLControl.setValue("q1", quaternion.q1);
            xMLControl.setValue("q2", quaternion.q2);
            xMLControl.setValue("q3", quaternion.q3);
            xMLControl.setValue("ox", quaternion.ox);
            xMLControl.setValue("oy", quaternion.oy);
            xMLControl.setValue("oz", quaternion.oz);
        }

        public Object createObject(XMLControl xMLControl) {
            return new Quaternion();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Quaternion quaternion = (Quaternion)object;
            double d = xMLControl.getDouble("q0");
            double d2 = xMLControl.getDouble("q0");
            double d3 = xMLControl.getDouble("q0");
            double d4 = xMLControl.getDouble("q0");
            quaternion.setCoordinates(d, d2, d3, d4);
            double d5 = xMLControl.getDouble("ox");
            double d6 = xMLControl.getDouble("oy");
            double d7 = xMLControl.getDouble("oz");
            quaternion.setOrigin(d5, d6, d7);
            return object;
        }
    }
}

