/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.numerics.LUPDecomposition;
import org.opensourcephysics.numerics.MatrixTransformation;
import org.opensourcephysics.numerics.VectorMath;

public class Matrix3DTransformation
implements MatrixTransformation {
    double[] origin = new double[3];
    double[][] matrix = new double[3][3];
    double[][] inverseMatrix = null;

    public Matrix3DTransformation(double[][] dArray) {
        if (dArray == null) {
            this.matrix[2][2] = 1.0;
            this.matrix[1][1] = 1.0;
            this.matrix[0][0] = 1.0;
            return;
        }
        for (int i = 0; i < dArray.length; ++i) {
            System.arraycopy(dArray[i], 0, this.matrix[i], 0, dArray[i].length);
        }
    }

    public static Matrix3DTransformation rotationX(double d) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        dArray[0][0] = 1.0;
        dArray[1][1] = d3;
        dArray[1][2] = -d2;
        dArray[2][1] = d2;
        dArray[2][2] = d3;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[0][0] = 1.0;
        dArray2[1][1] = d3;
        dArray2[1][2] = d2;
        dArray2[2][1] = -d2;
        dArray2[2][2] = d3;
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation rotationY(double d) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        dArray[1][1] = 1.0;
        dArray[0][0] = d3;
        dArray[0][2] = d2;
        dArray[2][0] = -d2;
        dArray[2][2] = d3;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[1][1] = 1.0;
        dArray2[0][0] = d3;
        dArray2[0][2] = -d2;
        dArray2[2][0] = d2;
        dArray2[2][2] = d3;
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation rotationZ(double d) {
        double d2;
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d3 = Math.sin(d);
        dArray[0][0] = d2 = Math.cos(d);
        dArray[0][1] = -d3;
        dArray[1][0] = d3;
        dArray[1][1] = d2;
        dArray[2][2] = 1.0;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[0][0] = d2;
        dArray2[0][1] = d3;
        dArray2[1][0] = -d3;
        dArray2[1][1] = d2;
        dArray2[2][2] = 1.0;
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation rotation(double d, double[] dArray) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray2 = matrix3DTransformation.matrix;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = dArray[2];
        double d5 = d2 * d2 + d3 * d3 + d4 * d4;
        if (d5 != 1.0) {
            d5 = 1.0 / Math.sqrt(d5);
            d2 *= d5;
            d3 *= d5;
            d4 *= d5;
        }
        double d6 = Math.cos(d);
        double d7 = Math.sin(d);
        double d8 = 1.0 - d6;
        dArray2[0][0] = d8 * d2 * d2 + d6;
        dArray2[0][1] = d8 * d2 * d3 - d7 * d4;
        dArray2[0][2] = d8 * d2 * d4 + d7 * d3;
        dArray2[1][0] = d8 * d2 * d3 + d7 * d4;
        dArray2[1][1] = d8 * d3 * d3 + d6;
        dArray2[1][2] = d8 * d3 * d4 - d7 * d2;
        dArray2[2][0] = d8 * d2 * d4 - d7 * d3;
        dArray2[2][1] = d8 * d3 * d4 + d7 * d2;
        dArray2[2][2] = d8 * d4 * d4 + d6;
        double[][] dArray3 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray3;
        dArray3[0][0] = dArray2[0][0];
        dArray3[1][0] = dArray2[0][1];
        dArray3[2][0] = dArray2[0][2];
        dArray3[0][1] = dArray2[1][0];
        dArray3[1][1] = dArray2[1][1];
        dArray3[2][1] = dArray2[1][2];
        dArray3[0][2] = dArray2[2][0];
        dArray3[1][2] = dArray2[2][1];
        dArray3[2][2] = dArray2[2][2];
        return matrix3DTransformation;
    }

    public static Matrix3DTransformation Quaternion(double[] dArray) {
        return Matrix3DTransformation.Quaternion(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public static Matrix3DTransformation Quaternion(double d, double d2, double d3, double d4) {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(null);
        double[][] dArray = matrix3DTransformation.matrix;
        double d5 = d * d + d2 * d2 + d3 * d3 + d4 * d4;
        if (d5 != 1.0) {
            d5 = 1.0 / Math.sqrt(d5);
            d *= d5;
            d2 *= d5;
            d3 *= d5;
            d4 *= d5;
        }
        double d6 = 2.0 * d2 * d2;
        double d7 = 2.0 * d3 * d3;
        double d8 = 2.0 * d4 * d4;
        double d9 = 2.0 * d2 * d3;
        double d10 = 2.0 * d2 * d4;
        double d11 = 2.0 * d3 * d4;
        double d12 = 2.0 * d * d2;
        double d13 = 2.0 * d * d3;
        double d14 = 2.0 * d * d4;
        dArray[0][0] = 1.0 - d7 - d8;
        dArray[0][1] = d9 - d14;
        dArray[0][2] = d10 + d13;
        dArray[1][0] = d9 + d14;
        dArray[1][1] = 1.0 - d6 - d8;
        dArray[1][2] = d11 - d12;
        dArray[2][0] = d10 - d13;
        dArray[2][1] = d11 + d12;
        dArray[2][2] = 1.0 - d6 - d7;
        double[][] dArray2 = new double[3][3];
        matrix3DTransformation.inverseMatrix = dArray2;
        dArray2[0][0] = dArray[0][0];
        dArray2[1][0] = dArray[0][1];
        dArray2[2][0] = dArray[0][2];
        dArray2[0][1] = dArray[1][0];
        dArray2[1][1] = dArray[1][1];
        dArray2[2][1] = dArray[1][2];
        dArray2[0][2] = dArray[2][0];
        dArray2[1][2] = dArray[2][1];
        dArray2[2][2] = dArray[2][2];
        return matrix3DTransformation;
    }

    public Object clone() {
        Matrix3DTransformation matrix3DTransformation = new Matrix3DTransformation(this.matrix);
        matrix3DTransformation.origin = (double[])this.origin.clone();
        if (this.inverseMatrix == null) {
            return matrix3DTransformation;
        }
        matrix3DTransformation.inverseMatrix = new double[3][3];
        for (int i = 0; i < this.inverseMatrix.length; ++i) {
            System.arraycopy(this.inverseMatrix[i], 0, matrix3DTransformation.inverseMatrix[i], 0, this.inverseMatrix[i].length);
        }
        return matrix3DTransformation;
    }

    public final double[] getFlatMatrix(double[] dArray) {
        if (dArray == null) {
            dArray = new double[16];
        }
        dArray[0] = this.matrix[0][0];
        dArray[4] = this.matrix[0][1];
        dArray[8] = this.matrix[0][2];
        dArray[1] = this.matrix[1][0];
        dArray[5] = this.matrix[1][1];
        dArray[9] = this.matrix[1][2];
        dArray[2] = this.matrix[2][0];
        dArray[3] = 0.0;
        dArray[6] = this.matrix[2][1];
        dArray[7] = 0.0;
        dArray[10] = this.matrix[2][2];
        dArray[11] = 0.0;
        dArray[12] = this.origin[0];
        dArray[13] = this.origin[1];
        dArray[14] = this.origin[2];
        dArray[15] = 1.0;
        return dArray;
    }

    public final double[] getTransposedFlatMatrix(double[] dArray) {
        if (dArray == null) {
            dArray = new double[]{this.matrix[0][0], this.matrix[0][1], this.matrix[0][2], 0.0, this.matrix[1][0], this.matrix[1][1], this.matrix[1][2], 0.0, this.matrix[2][0], this.matrix[2][1], this.matrix[2][2], 0.0, this.origin[0], this.origin[1], this.origin[2], 1.0};
        }
        return dArray;
    }

    public static Matrix3DTransformation createAlignmentTransformation(double[] dArray, double[] dArray2) {
        dArray = VectorMath.normalize((double[])dArray.clone());
        dArray2 = VectorMath.normalize((double[])dArray2.clone());
        double d = Math.acos(VectorMath.dot(dArray, dArray2));
        double[] dArray3 = VectorMath.cross3D(dArray, dArray2);
        return Matrix3DTransformation.rotation(d, dArray3);
    }

    public void setOrigin(double d, double d2, double d3) {
        this.origin[0] = d;
        this.origin[1] = d2;
        this.origin[2] = d3;
    }

    public final void multiply(Matrix3DTransformation matrix3DTransformation) {
        this.multiply(matrix3DTransformation.matrix);
    }

    public final void multiply(double[][] dArray) {
        int n = this.matrix.length;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = (double[])this.matrix[i].clone();
            int n2 = this.matrix[0].length;
            for (int j = 0; j < n2; ++j) {
                this.matrix[i][j] = 0.0;
                for (int k = 0; k < n2; ++k) {
                    double[] dArray3 = this.matrix[i];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] + dArray2[k] * dArray[k][j];
                }
            }
        }
    }

    public double[] setOrigin(double[] dArray) {
        this.origin[0] = dArray[0];
        this.origin[1] = dArray[1];
        this.origin[2] = dArray[2];
        return dArray;
    }

    public double[] direct(double[] dArray) {
        dArray[0] = dArray[0] - this.origin[0];
        dArray[1] = dArray[1] - this.origin[1];
        dArray[2] = dArray[2] - this.origin[2];
        double[] dArray2 = (double[])dArray.clone();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.origin[i];
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                dArray[n2] = dArray[n2] + this.matrix[i][j] * dArray2[j];
            }
        }
        return dArray;
    }

    public double[][] direct(double[][] dArray) {
        int n;
        int n2;
        double[] dArray2;
        int n3;
        if (this.inverseMatrix == null) {
            this.calcInverse();
            if (this.inverseMatrix == null) {
                throw new UnsupportedOperationException("The inverse matrix does not exist.");
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            dArray2 = (double[])dArray[n3].clone();
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[n3][n2] = 0.0;
                for (n = 0; n < 3; ++n) {
                    double[] dArray3 = dArray[n3];
                    int n4 = n2;
                    dArray3[n4] = dArray3[n4] + dArray2[n] * this.inverseMatrix[n][n2];
                }
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            dArray2 = new double[]{dArray[0][n3], dArray[1][n3], dArray[2][n3]};
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[n2][n3] = 0.0;
                for (n = 0; n < 3; ++n) {
                    double[] dArray4 = dArray[n2];
                    int n5 = n3;
                    dArray4[n5] = dArray4[n5] + this.matrix[n2][n] * dArray2[n];
                }
            }
        }
        return dArray;
    }

    public double[] inverse(double[] dArray) throws UnsupportedOperationException {
        if (this.inverseMatrix == null) {
            this.calcInverse();
            if (this.inverseMatrix == null) {
                throw new UnsupportedOperationException("The inverse matrix does not exist.");
            }
        }
        dArray[0] = dArray[0] - this.origin[0];
        dArray[1] = dArray[1] - this.origin[1];
        dArray[2] = dArray[2] - this.origin[2];
        double[] dArray2 = (double[])dArray.clone();
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.origin[i];
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                dArray[n2] = dArray[n2] + this.inverseMatrix[i][j] * dArray2[j];
            }
        }
        return dArray;
    }

    public double[][] inverse(double[][] dArray) {
        int n;
        int n2;
        double[] dArray2;
        int n3;
        if (this.inverseMatrix == null) {
            this.calcInverse();
            if (this.inverseMatrix == null) {
                throw new UnsupportedOperationException("The inverse matrix does not exist.");
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            dArray2 = (double[])dArray[n3].clone();
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[n3][n2] = 0.0;
                for (n = 0; n < 3; ++n) {
                    double[] dArray3 = dArray[n3];
                    int n4 = n2;
                    dArray3[n4] = dArray3[n4] + dArray2[n] * this.matrix[n][n2];
                }
            }
        }
        for (n3 = 0; n3 < 3; ++n3) {
            dArray2 = new double[]{dArray[0][n3], dArray[1][n3], dArray[2][n3]};
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[n2][n3] = 0.0;
                for (n = 0; n < 3; ++n) {
                    double[] dArray4 = dArray[n2];
                    int n5 = n3;
                    dArray4[n5] = dArray4[n5] + this.inverseMatrix[n2][n] * dArray2[n];
                }
            }
        }
        return dArray;
    }

    private void calcInverse() {
        LUPDecomposition lUPDecomposition = new LUPDecomposition(this.matrix);
        this.inverseMatrix = lUPDecomposition.inverseMatrixComponents();
    }

    public static XML.ObjectLoader getLoader() {
        return new Affine3DTransformationLoader();
    }

    protected static class Affine3DTransformationLoader
    extends XMLLoader {
        protected Affine3DTransformationLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Matrix3DTransformation matrix3DTransformation = (Matrix3DTransformation)object;
            xMLControl.setValue("matrix", matrix3DTransformation.matrix);
            if (matrix3DTransformation.inverseMatrix != null) {
                xMLControl.setValue("inverse", matrix3DTransformation.inverseMatrix);
            }
            xMLControl.setValue("origin", matrix3DTransformation.origin);
        }

        public Object createObject(XMLControl xMLControl) {
            return new Matrix3DTransformation(null);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Matrix3DTransformation matrix3DTransformation = (Matrix3DTransformation)object;
            matrix3DTransformation.matrix = (double[][])xMLControl.getObject("matrix");
            matrix3DTransformation.inverseMatrix = (double[][])xMLControl.getObject("inverse");
            matrix3DTransformation.origin = (double[])xMLControl.getObject("origin");
            return object;
        }
    }
}

