/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

public class Factorials {
    static double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    static long[] fac;

    private Factorials() {
    }

    public static double gammaln(double d) {
        double d2 = d;
        double d3 = d + 5.5;
        d3 -= (d + 0.5) * Math.log(d3);
        double d4 = 1.000000000190015;
        for (int i = 0; i <= 5; ++i) {
            d4 += cof[i] / (d2 += 1.0);
        }
        return -d3 + Math.log(2.5066282746310007 * d4 / d);
    }

    public static double factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative value passed to factorial.");
        }
        if (n < fac.length) {
            return fac[n];
        }
        return Math.exp(Factorials.gammaln((double)n + 1.0));
    }

    public static double logFactorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative value passed to logFactorial.");
        }
        return Factorials.gammaln((double)n + 1.0);
    }

    public static double poisson(double d, int n) {
        return Math.exp((double)n * Math.log(d) - d - Factorials.logFactorial(n));
    }

    public static double logChoose(int n, int n2) {
        return Factorials.logFactorial(n) - Factorials.logFactorial(n2) - Factorials.logFactorial(n - n2);
    }

    static {
        long l = 1L;
        int n = 1;
        while (l * (long)n >= l) {
            l *= (long)n;
            ++n;
        }
        fac = new long[n];
        Factorials.fac[0] = 1L;
        for (int i = 1; i < n; ++i) {
            Factorials.fac[i] = fac[i - 1] * (long)i;
        }
    }
}

