/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.quicktime;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.quicktime.QTVideoType;
import org.opensourcephysics.media.quicktime.QTip;
import quicktime.QTException;
import quicktime.QTSession;

public class QT {
    public static final int PRINT_EXCEPTION_ON_FAIL = 0;
    public static final int SHOW_DIALOG_ON_FAIL = 1;
    public static final int DO_NOTHING_ON_FAIL = 2;
    private static int failMode = 1;
    private static Collection qTips = new ArrayList();
    private static Thread shutdownHook;

    private QT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Class<QTSession> clazz = QTSession.class;
        synchronized (QTSession.class) {
            VideoType[] videoTypeArray = VideoIO.getVideoTypes();
            boolean bl = false;
            Class<QTVideoType> clazz2 = QTVideoType.class;
            for (int i = 0; i < videoTypeArray.length; ++i) {
                if (!videoTypeArray[i].getClass().equals(clazz2)) continue;
                bl = true;
            }
            if (!bl) {
                VideoIO.addVideoType(new QTVideoType());
            }
            if (shutdownHook == null) {
                try {
                    OSPLog.finest("QT opening");
                    QTSession.open();
                    shutdownHook = new Thread(){

                        public void run() {
                            QT.exit();
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                }
                catch (QTException qTException) {
                    switch (failMode) {
                        default: {
                            qTException.printStackTrace();
                            break;
                        }
                        case 1: {
                            JOptionPane.showMessageDialog(null, MediaRes.getString("QT.Dialog.NotFound.Message"), MediaRes.getString("QT.Dialog.NotFound.Title"), 0);
                        }
                        case 2: 
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void add(QTip qTip) {
        if (qTip == null) {
            return;
        }
        qTips.add(qTip);
    }

    public static synchronized void remove(QTip qTip) {
        if (qTip == null) {
            return;
        }
        if (qTips.remove(qTip)) {
            try {
                qTip.cleanup();
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void exit() {
        Object object2;
        OSPLog.finest("QT exiting");
        for (Object object2 : qTips) {
            try {
                ((QTip)object2).cleanup();
            }
            catch (QTException qTException) {}
        }
        qTips.clear();
        object2 = QTSession.class;
        synchronized (QTSession.class) {
            QTSession.exitMovies();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            shutdownHook = null;
            return;
        }
    }

    public static void setFailMode(int n) {
        failMode = n;
    }
}

