/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifVideoType;

public class VideoIO {
    protected static JFileChooser chooser;
    protected static FileFilter videoFileFilter;
    protected static FileFilter qtFileFilter;
    protected static FileFilter imageFileFilter;
    protected static Collection videoTypes;
    protected static String defaultXMLExt;

    protected VideoIO() {
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static JFileChooser getChooser() {
        if (chooser == null) {
            chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        }
        return chooser;
    }

    public static void setDefaultXMLExtension(String string) {
        defaultXMLExt = string;
    }

    public static String getRelativePath(String string) {
        if (string.indexOf("/") == -1 && string.indexOf("\\") == -1) {
            return string;
        }
        if (string.startsWith("http:")) {
            return string;
        }
        String string2 = string;
        String string3 = "";
        boolean bl = false;
        String string4 = System.getProperty("user.dir");
        if (string4 == null) {
            return string2;
        }
        for (int i = 0; i < 3; ++i) {
            int n;
            if (i > 0) {
                n = string4.lastIndexOf("\\");
                if (n == -1) {
                    n = string4.lastIndexOf("/");
                }
                if (n == -1) break;
                string4 = string4.substring(0, n);
                string3 = string3 + "../";
            }
            if (!string2.startsWith(string4)) continue;
            string2 = string2.substring(string4.length() + 1);
            n = string2.indexOf("\\");
            while (n != -1) {
                string2 = string2.substring(0, n) + "/" + string2.substring(n + 1);
                n = string2.indexOf("\\");
            }
            string3 = string3 + string2;
            bl = true;
            break;
        }
        if (bl) {
            return string3;
        }
        return string2;
    }

    public static void addVideoType(VideoType videoType) {
        if (videoType != null) {
            boolean bl = false;
            Iterator iterator = videoTypes.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getClass().equals(videoType.getClass())) continue;
                bl = true;
            }
            if (!bl) {
                videoTypes.add(videoType);
            }
        }
    }

    public static VideoType[] getVideoTypes() {
        return videoTypes.toArray(new VideoType[0]);
    }

    public static Video getVideo(File file) {
        VideoType videoType;
        Video video = null;
        Iterator iterator = videoTypes.iterator();
        while (iterator.hasNext() && (video = (videoType = (VideoType)iterator.next()).getVideo(file.getAbsolutePath())) == null) {
        }
        return video;
    }

    public static Video clone(Video video) {
        if (video == null) {
            return null;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(video);
        return (Video)new XMLControlElement(xMLControlElement).loadObject(null);
    }

    public static File open(VideoPanel videoPanel) {
        return VideoIO.open(null, videoPanel);
    }

    public static File getChooserFile(String string) {
        JFileChooser jFileChooser = VideoIO.getChooser();
        int n = 1;
        if (string.toLowerCase().equals("open")) {
            jFileChooser.removeChoosableFileFilter(qtFileFilter);
            jFileChooser.removeChoosableFileFilter(imageFileFilter);
            jFileChooser.addChoosableFileFilter(videoFileFilter);
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
            n = jFileChooser.showOpenDialog(null);
        } else if (string.toLowerCase().equals("open video")) {
            jFileChooser.removeChoosableFileFilter(qtFileFilter);
            jFileChooser.removeChoosableFileFilter(imageFileFilter);
            jFileChooser.addChoosableFileFilter(videoFileFilter);
            jFileChooser.setFileFilter(videoFileFilter);
            n = jFileChooser.showOpenDialog(null);
        } else if (string.toLowerCase().equals("save")) {
            jFileChooser.removeChoosableFileFilter(videoFileFilter);
            jFileChooser.removeChoosableFileFilter(qtFileFilter);
            jFileChooser.removeChoosableFileFilter(imageFileFilter);
            jFileChooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
            String string2 = MediaRes.getString("VideoIO.FileName.Untitled");
            jFileChooser.setSelectedFile(new File(string2 + "." + defaultXMLExt));
            n = jFileChooser.showSaveDialog(null);
        } else if (string.toLowerCase().equals("qt")) {
            jFileChooser.removeChoosableFileFilter(videoFileFilter);
            jFileChooser.removeChoosableFileFilter(imageFileFilter);
            jFileChooser.addChoosableFileFilter(qtFileFilter);
            jFileChooser.setFileFilter(qtFileFilter);
            jFileChooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.FindQT.Title"));
            n = jFileChooser.showDialog(null, MediaRes.getString("Dialog.Button.OK"));
        } else if (string.toLowerCase().equals("insert image")) {
            jFileChooser.removeChoosableFileFilter(qtFileFilter);
            jFileChooser.removeChoosableFileFilter(videoFileFilter);
            jFileChooser.addChoosableFileFilter(imageFileFilter);
            jFileChooser.setFileFilter(imageFileFilter);
            n = jFileChooser.showOpenDialog(null);
        }
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public static File open(File file, VideoPanel videoPanel) {
        JFileChooser jFileChooser = VideoIO.getChooser();
        if (file == null) {
            jFileChooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.Open.Title"));
            file = VideoIO.getChooserFile("open");
        }
        if (file == null) {
            return null;
        }
        if (videoFileFilter.accept(file)) {
            VideoType[] videoTypeArray = VideoIO.getVideoTypes();
            Video video = null;
            for (int i = 0; i < videoTypeArray.length && (video = videoTypeArray[i].getVideo(file.getAbsolutePath())) == null; ++i) {
            }
            if (video != null) {
                videoPanel.setVideo(video);
                videoPanel.repaint();
            } else {
                JOptionPane.showMessageDialog(null, MediaRes.getString("VideoIO.Dialog.BadVideo.Message") + file.getAbsolutePath());
            }
        } else {
            XMLControlElement xMLControlElement = new XMLControlElement();
            xMLControlElement.read(file.getAbsolutePath());
            Class clazz = xMLControlElement.getObjectClass();
            if (VideoPanel.class.isAssignableFrom(clazz)) {
                videoPanel.setDataFile(file);
                xMLControlElement.loadObject(videoPanel);
            } else {
                if (!xMLControlElement.failedToRead()) {
                    JOptionPane.showMessageDialog(null, "\"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.XMLMismatch.Message"), MediaRes.getString("VideoIO.Dialog.XMLMismatch.Title"), 2);
                    return null;
                }
                JOptionPane.showMessageDialog(null, MediaRes.getString("VideoIO.Dialog.BadFile.Message") + file.getAbsolutePath());
            }
            videoPanel.changed = false;
        }
        return file;
    }

    public static File save(File file, VideoPanel videoPanel) {
        Object object;
        if (file == null) {
            int n;
            object = VideoIO.getChooser();
            ((JFileChooser)object).removeChoosableFileFilter(videoFileFilter);
            ((JFileChooser)object).removeChoosableFileFilter(imageFileFilter);
            ((JFileChooser)object).removeChoosableFileFilter(qtFileFilter);
            ((JFileChooser)object).setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
            Video video = videoPanel.getVideo();
            String string = MediaRes.getString("VideoIO.FileName.Untitled");
            if (videoPanel.getFilePath() != null) {
                string = XML.stripExtension(videoPanel.getFilePath());
            } else if (video != null && video.getProperty("name") != null && (n = (string = (String)video.getProperty("name")).lastIndexOf(".")) > 0) {
                string = string.substring(0, n);
            }
            file = new File(string + "." + defaultXMLExt);
            String string2 = XML.getDirectoryPath(string);
            if (!string2.equals("")) {
                XML.createFolders(string2);
                ((JFileChooser)object).setCurrentDirectory(new File(string2));
            }
            ((JFileChooser)object).setSelectedFile(file);
            int n2 = ((JFileChooser)object).showSaveDialog(null);
            if (n2 == 0) {
                int n3;
                file = ((JFileChooser)object).getSelectedFile();
                if (VideoIO.getExtension(file) == null) {
                    file = new File(file.getPath() + "." + defaultXMLExt);
                }
                if (file.exists() && (n3 = JOptionPane.showConfirmDialog(null, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 1)) != 0) {
                    return null;
                }
                videoPanel.setDataFile(file);
            } else {
                return null;
            }
        }
        object = new XMLControlElement(videoPanel);
        object.write(file.getAbsolutePath());
        videoPanel.changed = false;
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File recordVideo(VideoPanel videoPanel, VideoType videoType) {
        VideoRecorder videoRecorder = videoType.getRecorder();
        if (videoRecorder == null) {
            JOptionPane.showMessageDialog(null, MediaRes.getString("VideoIO.Dialog.NoRecorder.Message"));
            return null;
        }
        try {
            String string;
            VideoRecorder videoRecorder2 = videoRecorder;
            videoRecorder2.createVideo();
            BufferedImage bufferedImage = new BufferedImage(videoPanel.getWidth(), videoPanel.getHeight(), 1);
            VideoPlayer videoPlayer = videoPanel.getPlayer();
            videoPlayer.stop();
            videoPlayer.setStepNumber(0);
            int n = videoPlayer.getVideoClip().getStepCount();
            Object[] objectArray = new Object[]{MediaRes.getString("VideoIO.Dialog.AddFrame.Button.Add"), MediaRes.getString("VideoIO.Dialog.AddFrame.Button.Skip"), MediaRes.getString("VideoIO.Dialog.AddFrame.Button.End")};
            block7: for (int i = 0; i < n; ++i) {
                int n2 = JOptionPane.showOptionDialog(null, MediaRes.getString("VideoIO.Dialog.AddFrame.Message"), MediaRes.getString("VideoIO.Dialog.AddFrame.Title"), 1, 3, null, objectArray, objectArray[0]);
                switch (n2) {
                    case 0: {
                        if (i < n - 1) {
                            double d = videoPlayer.getStepTime(i + 1) - videoPlayer.getStepTime(i);
                            videoRecorder2.setFrameDuration(d);
                        }
                        videoRecorder2.addFrame(videoPanel.render(bufferedImage));
                    }
                    case 1: {
                        if (i < n - 1) {
                            videoPlayer.step();
                            break;
                        }
                        videoRecorder2.saveVideo();
                        break;
                    }
                    case 2: {
                        videoRecorder2.saveVideo();
                        break block7;
                    }
                }
            }
            if ((string = videoRecorder2.getFileName()) == null) return null;
            return new File(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    static {
        videoFileFilter = new VideoFileFilter();
        videoTypes = new ArrayList();
        defaultXMLExt = "xml";
        qtFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return file.getAbsolutePath().indexOf("QTJava.zip") != -1;
            }

            public String getDescription() {
                return "QTJava.zip";
            }
        };
        imageFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return string != null && (string.equals("gif") || string.equals("jpg"));
            }

            public String getDescription() {
                return MediaRes.getString("VideoIO.ImageFileFilter.Description");
            }
        };
        VideoIO.addVideoType(new GifVideoType());
        VideoIO.addVideoType(new ImageVideoType());
    }
}

