/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JTextField;

public class NumberField
extends JTextField {
    protected NumberFormat format = NumberFormat.getInstance();
    protected double prevValue;
    protected Double maxValue;
    protected Double minValue;

    public NumberField(int n) {
        super(n);
    }

    public double getValue() {
        double d;
        if (this.getText().equals(this.format.format(this.prevValue))) {
            return this.prevValue;
        }
        try {
            d = this.format.parse(this.getText()).doubleValue();
            if (this.minValue != null && d < this.minValue) {
                this.setValue(this.minValue);
                return this.minValue;
            }
            if (this.maxValue != null && d > this.maxValue) {
                this.setValue(this.maxValue);
                return this.maxValue;
            }
        }
        catch (ParseException parseException) {
            Toolkit.getDefaultToolkit().beep();
            this.setValue(this.prevValue);
            return this.prevValue;
        }
        return d;
    }

    public void setValue(double d) {
        if (!this.isVisible()) {
            return;
        }
        if (this.minValue != null) {
            d = Math.max(d, this.minValue);
        }
        if (this.maxValue != null) {
            d = Math.min(d, this.maxValue);
        }
        this.setFormatFor(d);
        this.setText(this.format.format(d));
        this.prevValue = d;
    }

    public void setResolution(double d) {
    }

    public void setMinValue(double d) {
        this.minValue = new Double(d);
    }

    public void setMaxValue(double d) {
        this.maxValue = new Double(d);
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public void setFormatFor(double d) {
    }
}

