/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JDialog;
import org.opensourcephysics.media.core.Filter;

public class FilterStack
extends Filter
implements PropertyChangeListener {
    private ArrayList filters = new ArrayList();
    private Filter postFilter;
    private int indexRemoved = -1;

    public void addFilter(Filter filter) {
        this.filters.add(filter);
        filter.stack = this;
        filter.addPropertyChangeListener(this);
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, filter);
    }

    public void insertFilter(Filter filter, int n) {
        n = Math.min(n, this.filters.size());
        n = Math.max(n, 0);
        this.filters.add(n, filter);
        filter.stack = this;
        filter.addPropertyChangeListener(this);
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, filter);
    }

    public int lastIndexRemoved() {
        return this.indexRemoved;
    }

    public void setPostFilter(Filter filter) {
        if (this.postFilter != null) {
            this.postFilter.removePropertyChangeListener(this);
        }
        this.postFilter = filter;
        if (filter != null) {
            filter.addPropertyChangeListener(this);
            this.support.firePropertyChange("image", null, null);
            this.support.firePropertyChange("filter", null, filter);
        }
    }

    public Filter getPostFilter() {
        return this.postFilter;
    }

    public Filter getFilter(Class clazz) {
        for (Filter filter : this.filters) {
            if (filter.getClass() != clazz) continue;
            return filter;
        }
        return null;
    }

    public void removeFilter(Filter filter) {
        this.indexRemoved = this.filters.indexOf(filter);
        if (this.indexRemoved > -1) {
            this.filters.remove(filter);
            filter.stack = null;
            filter.removePropertyChangeListener(this);
            this.support.firePropertyChange("image", null, null);
            this.support.firePropertyChange("filter", filter, null);
        }
    }

    public void clear() {
        for (Filter filter : this.filters) {
            filter.stack = null;
            filter.removePropertyChangeListener(this);
        }
        this.filters.clear();
        this.support.firePropertyChange("image", null, null);
        this.support.firePropertyChange("filter", null, null);
    }

    public boolean isEmpty() {
        return this.filters.isEmpty() && this.postFilter == null;
    }

    public Collection getFilters() {
        return (Collection)this.filters.clone();
    }

    public BufferedImage getFilteredImage(BufferedImage bufferedImage) {
        if (!this.isEnabled()) {
            return bufferedImage;
        }
        for (Filter filter : this.filters) {
            bufferedImage = filter.getFilteredImage(bufferedImage);
        }
        if (this.postFilter != null) {
            bufferedImage = this.postFilter.getFilteredImage(bufferedImage);
        }
        return bufferedImage;
    }

    public JDialog getInspector() {
        return null;
    }

    public void setInspectorsVisible(boolean bl) {
        Collection collection = this.getFilters();
        for (Filter filter : collection) {
            JDialog jDialog = filter.getInspector();
            if (jDialog == null) continue;
            if (!bl) {
                filter.inspectorVisible = jDialog.isVisible();
                jDialog.setVisible(false);
                continue;
            }
            if (jDialog.isModal()) continue;
            jDialog.setVisible(filter.inspectorVisible);
            filter.inspectorVisible = false;
        }
    }

    public void refresh() {
        Iterator iterator = this.getFilters().iterator();
        while (iterator.hasNext()) {
            ((Filter)iterator.next()).refresh();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.support.firePropertyChange("image", null, null);
    }
}

