/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.utils;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;

public class HardcopyWriter
extends Writer {
    protected PrintJob job;
    protected Graphics page;
    protected String jobname;
    protected int fontsize;
    protected String time;
    protected Dimension pagesize;
    protected int pagedpi;
    protected Font font;
    protected Font headerfont;
    protected FontMetrics metrics;
    protected FontMetrics headermetrics;
    protected int x0;
    protected int y0;
    protected int width;
    protected int height;
    protected int headery;
    protected int charwidth;
    protected int lineheight;
    protected int lineascent;
    protected int chars_per_line;
    protected int lines_per_page;
    protected int charnum = 0;
    protected int linenum = 0;
    protected int pagenum = 0;
    private boolean last_char_was_return = false;
    protected static Properties printprops = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardcopyWriter(Frame frame, String string, int n, double d, double d2, double d3, double d4) throws PrintCanceledException {
        Toolkit toolkit = frame.getToolkit();
        Cloneable cloneable = printprops;
        synchronized (cloneable) {
            this.job = toolkit.getPrintJob(frame, string, printprops);
        }
        if (this.job == null) {
            throw new PrintCanceledException("User cancelled print request");
        }
        this.pagesize = this.job.getPageDimension();
        this.pagedpi = this.job.getPageResolution();
        if (System.getProperty("os.name").regionMatches(true, 0, "windows", 0, 7)) {
            this.pagedpi = toolkit.getScreenResolution();
            this.pagesize = new Dimension((int)(8.5 * (double)this.pagedpi), 11 * this.pagedpi);
            this.pagesize = new Dimension((int)(8.2677 * (double)this.pagedpi), 11 * this.pagedpi);
            this.pagesize = new Dimension((int)(6.25 * (double)this.pagedpi), 9 * this.pagedpi);
            n = n * this.pagedpi / 72;
        }
        this.x0 = (int)(d * (double)this.pagedpi);
        this.y0 = (int)(d3 * (double)this.pagedpi);
        this.width = this.pagesize.width - (int)((d + d2) * (double)this.pagedpi);
        this.height = this.pagesize.height - (int)((d3 + d4) * (double)this.pagedpi);
        this.font = new Font("Monospaced", 0, n);
        this.metrics = frame.getFontMetrics(this.font);
        this.lineheight = this.metrics.getHeight();
        this.lineascent = this.metrics.getAscent();
        this.charwidth = this.metrics.charWidth('0');
        this.chars_per_line = this.width / this.charwidth;
        this.lines_per_page = this.height / this.lineheight;
        this.headerfont = new Font("SansSerif", 2, n);
        this.headermetrics = frame.getFontMetrics(this.headerfont);
        this.headery = this.y0 - (int)(0.125 * (double)this.pagedpi) - this.headermetrics.getHeight() + this.headermetrics.getAscent();
        cloneable = DateFormat.getDateTimeInstance(1, 3);
        ((DateFormat)cloneable).setTimeZone(TimeZone.getDefault());
        this.time = ((DateFormat)cloneable).format(new Date());
        this.jobname = string;
        this.fontsize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = n; i < n + n2; ++i) {
                if (this.page == null) {
                    this.newpage();
                }
                if (cArray[i] == '\n') {
                    if (this.last_char_was_return) continue;
                    this.newline();
                    continue;
                }
                if (cArray[i] == '\r') {
                    this.newline();
                    this.last_char_was_return = true;
                    continue;
                }
                this.last_char_was_return = false;
                if (Character.isWhitespace(cArray[i]) && !Character.isSpaceChar(cArray[i]) && cArray[i] != '\t') continue;
                if (this.charnum >= this.chars_per_line) {
                    this.newline();
                    if (this.page == null) {
                        this.newpage();
                    }
                }
                if (Character.isSpaceChar(cArray[i])) {
                    ++this.charnum;
                    continue;
                }
                if (cArray[i] == '\t') {
                    this.charnum += 8 - this.charnum % 8;
                    continue;
                }
                this.page.drawChars(cArray, i, 1, this.x0 + this.charnum * this.charwidth, this.y0 + this.linenum * this.lineheight + this.lineascent);
                ++this.charnum;
            }
        }
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.page != null) {
                this.page.dispose();
            }
            this.job.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontStyle(int n) {
        Object object = this.lock;
        synchronized (object) {
            Font font = this.font;
            try {
                this.font = new Font("Monospaced", n, this.fontsize);
            }
            catch (Exception exception) {
                this.font = font;
            }
            if (this.page != null) {
                this.page.setFont(this.font);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageBreak() {
        Object object = this.lock;
        synchronized (object) {
            this.newpage();
        }
    }

    public int getCharactersPerLine() {
        return this.chars_per_line;
    }

    public int getLinesPerPage() {
        return this.lines_per_page;
    }

    protected void newline() {
        this.charnum = 0;
        ++this.linenum;
        if (this.linenum >= this.lines_per_page) {
            this.page.dispose();
            this.page = null;
        }
    }

    protected void newpage() {
        this.page = this.job.getGraphics();
        this.linenum = 0;
        this.charnum = 0;
        ++this.pagenum;
        this.page.setFont(this.headerfont);
        this.page.drawString(this.jobname, this.x0, this.headery);
        String string = "- " + this.pagenum + " -";
        int n = this.headermetrics.stringWidth(string);
        this.page.drawString(string, this.x0 + (this.width - n) / 2, this.headery);
        n = this.headermetrics.stringWidth(this.time);
        this.page.drawString(this.time, this.x0 + this.width - n, this.headery);
        int n2 = this.headery + this.headermetrics.getDescent() + 1;
        this.page.drawLine(this.x0, n2, this.x0 + this.width, n2);
        this.page.setFont(this.font);
    }

    public static void main(String[] stringArray) {
        stringArray = new String[]{"test.txt"};
        PrintFile.main(stringArray);
    }

    public static class Demo
    extends Frame
    implements ActionListener {
        protected Button print;
        protected Button quit;

        public static void main(String[] stringArray) {
            Demo demo = new Demo();
            demo.show();
        }

        public Demo() {
            super("HardcopyWriter Test");
            Panel panel = new Panel();
            this.add((Component)panel, "Center");
            panel.setFont(new Font("SansSerif", 1, 18));
            this.print = new Button("Print Test Page");
            this.quit = new Button("Quit");
            this.print.addActionListener(this);
            this.quit.addActionListener(this);
            panel.add(this.print);
            panel.add(this.quit);
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.quit) {
                System.exit(0);
            } else if (object == this.print) {
                this.printDemoPage();
            }
        }

        public void printDemoPage() {
            int n;
            HardcopyWriter hardcopyWriter;
            try {
                hardcopyWriter = new HardcopyWriter(this, "Demo Page", 10, 0.75, 0.75, 0.75, 0.75);
            }
            catch (PrintCanceledException printCanceledException) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(hardcopyWriter);
            int n2 = hardcopyWriter.getLinesPerPage();
            int n3 = hardcopyWriter.getCharactersPerLine();
            printWriter.print("+");
            for (int i = 0; i < n3 - 2; ++i) {
                printWriter.print(" ");
            }
            printWriter.print("+");
            hardcopyWriter.setFontStyle(3);
            printWriter.println("\n\t\tHardcopy Writer Demo Page\n\n");
            hardcopyWriter.setFontStyle(1);
            printWriter.println("Font Styles:");
            int[] nArray = new int[]{0, 1, 2, 3};
            for (n = 0; n < nArray.length; ++n) {
                hardcopyWriter.setFontStyle(nArray[n]);
                printWriter.println("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
                printWriter.println("1234567890!@#$%^&*()[]{}<>,.?:;+-=/\\`'\"_~|");
            }
            hardcopyWriter.setFontStyle(0);
            printWriter.println("\n");
            hardcopyWriter.setFontStyle(1);
            printWriter.println("Tab Stops:");
            hardcopyWriter.setFontStyle(0);
            printWriter.println("          1         2         3         4         5");
            printWriter.println("012345678901234567890123456789012345678901234567890");
            printWriter.println("^\t^\t^\t^\t^\t^\t^");
            printWriter.println("\n");
            hardcopyWriter.setFontStyle(1);
            printWriter.println("Dimensions:");
            hardcopyWriter.setFontStyle(0);
            printWriter.println("\tResolution: " + hardcopyWriter.pagedpi + " dots per inch");
            printWriter.println("\tPage width (pixels): " + hardcopyWriter.pagesize.width);
            printWriter.println("\tPage height (pixels): " + hardcopyWriter.pagesize.height);
            printWriter.println("\tWidth inside margins (pixels): " + hardcopyWriter.width);
            printWriter.println("\tHeight inside margins (pixels): " + hardcopyWriter.height);
            printWriter.println("\tCharacters per line: " + n3);
            printWriter.println("\tLines per page: " + n2);
            for (n = 0; n < n2 - 30; ++n) {
                printWriter.println();
            }
            printWriter.print("+");
            for (n = 0; n < n3 - 2; ++n) {
                printWriter.print(" ");
            }
            printWriter.print("+");
            printWriter.close();
        }
    }

    public static class PrintFile {
        public static void main(String[] stringArray) {
            try {
                int n;
                if (stringArray.length != 1) {
                    throw new IllegalArgumentException("Wrong # of arguments");
                }
                FileReader fileReader = new FileReader(stringArray[0]);
                HardcopyWriter hardcopyWriter = null;
                Frame frame = new Frame("PrintFile: " + stringArray[0]);
                frame.setSize(200, 50);
                frame.show();
                try {
                    hardcopyWriter = new HardcopyWriter(frame, stringArray[0], 10, 0.5, 0.5, 0.5, 0.5);
                }
                catch (PrintCanceledException printCanceledException) {
                    System.exit(0);
                }
                frame.setVisible(false);
                char[] cArray = new char[4096];
                while ((n = fileReader.read(cArray)) != -1) {
                    hardcopyWriter.write(cArray, 0, n);
                }
                fileReader.close();
                hardcopyWriter.close();
            }
            catch (Exception exception) {
                System.err.println(exception);
                System.err.println("Usage: java HardcopyWriter$PrintFile <filename>");
                System.exit(1);
            }
            System.exit(0);
        }
    }

    public static class PrintCanceledException
    extends Exception {
        public PrintCanceledException(String string) {
            super(string);
        }
    }
}

