/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.utils;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import org.opensourcephysics.ejs.utils.BitUtils;
import org.opensourcephysics.ejs.utils.ImageDescriptor;
import org.opensourcephysics.ejs.utils.LZWCompressor;
import org.opensourcephysics.ejs.utils.ScreenDescriptor;

public class GIFEncoder {
    short width_;
    short height_;
    int numColors_;
    byte[] pixels_;
    byte[] colors_;
    ScreenDescriptor sd_;
    ImageDescriptor id_;

    public GIFEncoder(Image image) throws AWTException {
        this.width_ = (short)image.getWidth(null);
        this.height_ = (short)image.getHeight(null);
        int[] nArray = new int[this.width_ * this.height_];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, (int)this.width_, (int)this.height_, nArray, 0, (int)this.width_);
        try {
            if (!pixelGrabber.grabPixels()) {
                throw new AWTException("Grabber returned false: " + pixelGrabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[][] byArray = new byte[this.width_][this.height_];
        byte[][] byArray2 = new byte[this.width_][this.height_];
        byte[][] byArray3 = new byte[this.width_][this.height_];
        int n = 0;
        for (int i = 0; i < this.height_; ++i) {
            for (int j = 0; j < this.width_; ++j) {
                byArray[j][i] = (byte)(nArray[n] >> 16 & 0xFF);
                byArray2[j][i] = (byte)(nArray[n] >> 8 & 0xFF);
                byArray3[j][i] = (byte)(nArray[n] & 0xFF);
                ++n;
            }
        }
        this.ToIndexedColor(byArray, byArray2, byArray3);
    }

    public GIFEncoder(byte[][] byArray, byte[][] byArray2, byte[][] byArray3) throws AWTException {
        this.width_ = (short)byArray.length;
        this.height_ = (short)byArray[0].length;
        this.ToIndexedColor(byArray, byArray2, byArray3);
    }

    public void Write(OutputStream outputStream) throws IOException {
        BitUtils.WriteString(outputStream, "GIF87a");
        ScreenDescriptor screenDescriptor = new ScreenDescriptor(this.width_, this.height_, this.numColors_);
        screenDescriptor.Write(outputStream);
        outputStream.write(this.colors_, 0, this.colors_.length);
        ImageDescriptor imageDescriptor = new ImageDescriptor(this.width_, this.height_, ',');
        imageDescriptor.Write(outputStream);
        byte by = BitUtils.BitsNeeded(this.numColors_);
        if (by == 1) {
            by = (byte)(by + 1);
        }
        outputStream.write(by);
        LZWCompressor.LZWCompress(outputStream, by, this.pixels_);
        outputStream.write(0);
        imageDescriptor = new ImageDescriptor(0, 0, ';');
        imageDescriptor.Write(outputStream);
        outputStream.flush();
    }

    void ToIndexedColor(byte[][] byArray, byte[][] byArray2, byte[][] byArray3) throws AWTException {
        this.pixels_ = new byte[this.width_ * this.height_];
        this.colors_ = new byte[768];
        int n = 0;
        for (int i = 0; i < this.width_; ++i) {
            for (int j = 0; j < this.height_; ++j) {
                int n2;
                for (n2 = 0; n2 < n && (this.colors_[n2 * 3] != byArray[i][j] || this.colors_[n2 * 3 + 1] != byArray2[i][j] || this.colors_[n2 * 3 + 2] != byArray3[i][j]); ++n2) {
                }
                if (n2 > 255) {
                    throw new AWTException("Too many colors.");
                }
                this.pixels_[j * this.width_ + i] = (byte)n2;
                if (n2 != n) continue;
                this.colors_[n2 * 3] = byArray[i][j];
                this.colors_[n2 * 3 + 1] = byArray2[i][j];
                this.colors_[n2 * 3 + 2] = byArray3[i][j];
                ++n;
            }
        }
        this.numColors_ = 1 << BitUtils.BitsNeeded(n);
        byte[] byArray4 = new byte[this.numColors_ * 3];
        System.arraycopy(this.colors_, 0, byArray4, 0, this.numColors_ * 3);
        this.colors_ = byArray4;
    }
}

