/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.StringTokenizer;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.value.ParserSuryono;
import org.opensourcephysics.ejs.control.value.Value;

public class ExpressionValue
extends Value {
    private String expression;
    private GroupControl group;
    private ParserSuryono parser;
    private String[] vars;
    private boolean isArray;
    private ParserSuryono[] arrayParser;
    private String[][] arrayVars;
    private double[] arrayValues;

    public ExpressionValue(String string, GroupControl groupControl) {
        this.group = groupControl;
        this.expression = new String(string.trim());
        this.processExpression();
    }

    public boolean getBoolean() {
        return this.getDouble() != 0.0;
    }

    public int getInteger() {
        return (int)Math.round(this.getDouble());
    }

    public double getDouble() {
        int n = this.vars.length;
        for (int i = 0; i < n; ++i) {
            this.parser.setVariable(i, this.group.getDouble(this.vars[i]));
        }
        return this.parser.evaluate();
    }

    public String getString() {
        return String.valueOf(this.getDouble());
    }

    public Object getObject() {
        if (this.isArray) {
            int n = this.arrayVars.length;
            for (int i = 0; i < n; ++i) {
                int n2 = this.arrayVars[i].length;
                for (int j = 0; j < n2; ++j) {
                    this.arrayParser[i].setVariable(j, this.group.getDouble(this.arrayVars[i][j]));
                }
                this.arrayValues[i] = this.arrayParser[i].evaluate();
            }
            return this.arrayValues;
        }
        return null;
    }

    public void setExpression(String string) {
        this.expression = new String(string.trim());
        this.processExpression();
    }

    public void copyValue(Value value) {
        this.expression = value instanceof ExpressionValue ? new String(((ExpressionValue)value).expression) : new String(value.getString());
        this.processExpression();
    }

    public Value cloneValue() {
        return new ExpressionValue(this.expression, this.group);
    }

    private void processExpression() {
        if (this.expression.startsWith("{") && this.expression.endsWith("}")) {
            String string = this.expression.substring(1, this.expression.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            this.arrayParser = new ParserSuryono[n];
            this.arrayVars = new String[n][];
            this.arrayValues = new double[n];
            this.isArray = true;
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.arrayVars[n2] = ParserSuryono.getVariableList(string2);
                this.arrayParser[n2] = new ParserSuryono(this.arrayVars[n2].length);
                int n3 = this.arrayVars[n2].length;
                for (int i = 0; i < n3; ++i) {
                    this.arrayParser[n2].defineVariable(i, this.arrayVars[n2][i]);
                }
                this.arrayParser[n2].define(string2);
                this.arrayParser[n2].parse();
                ++n2;
            }
        } else {
            this.vars = ParserSuryono.getVariableList(this.expression);
            this.parser = new ParserSuryono(this.vars.length);
            int n = this.vars.length;
            for (int i = 0; i < n; ++i) {
                this.parser.defineVariable(i, this.vars[i]);
            }
            this.parser.define(this.expression);
            this.parser.parse();
            this.isArray = false;
        }
    }
}

