/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JRadioButton;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlRadioButton
extends ControlSwingElement {
    static final int VARIABLE = 4;
    static final int SELECTED = 5;
    protected AbstractButton radioButton;
    protected ControlRadioButton mySelf = this;
    protected ControlContainer parent;
    protected BooleanValue internalValue;
    protected boolean defaultState;
    protected boolean defaultStateSet;
    protected String imageFile = null;
    protected String selectedimageFile = null;
    protected String labelString = "";
    private static ArrayList infoList = null;

    public ControlRadioButton(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.radioButton = object instanceof JRadioButton ? (JRadioButton)object : new JRadioButton();
        this.internalValue = new BooleanValue(this.radioButton.isSelected());
        this.defaultStateSet = false;
        this.parent = null;
        this.radioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlRadioButton.this.setInternalValue(ControlRadioButton.this.radioButton.isSelected());
                if (ControlRadioButton.this.isUnderEjs) {
                    ControlRadioButton.this.setFieldListValueWithAlternative(4, 5, ControlRadioButton.this.internalValue);
                }
            }
        });
        return this.radioButton;
    }

    public void reset() {
        if (this.defaultStateSet) {
            this.radioButton.setSelected(this.defaultState);
            this.setInternalValue(this.defaultState);
        }
    }

    protected void setInternalValue(boolean bl) {
        this.internalValue.value = bl;
        if (this.parent != null) {
            this.parent.informRadioGroup(this.mySelf, bl);
        }
        this.variableChanged(4, this.internalValue);
        this.invokeActions();
        if (this.internalValue.value) {
            this.invokeActions(20);
        } else {
            this.invokeActions(21);
        }
    }

    public void setParent(ControlContainer controlContainer) {
        this.parent = controlContainer;
    }

    void reportChanges() {
        this.variableChangedDoNotUpdate(4, this.internalValue);
    }

    int getVariableIndex() {
        return 4;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("text");
            infoList.add("image");
            infoList.add("selectedimage");
            infoList.add("alignment");
            infoList.add("variable");
            infoList.add("selected");
            infoList.add("action");
            infoList.add("actionon");
            infoList.add("actionoff");
            infoList.add("mnemonic");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("selectedimage")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        if (string.equals("variable")) {
            return "boolean";
        }
        if (string.equals("selected")) {
            return "boolean CONSTANT POSTPROCESS";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("actionon")) {
            return "Action CONSTANT";
        }
        if (string.equals("actionoff")) {
            return "Action CONSTANT";
        }
        if (string.equals("mnemonic")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.labelString.equals(value.getString())) break;
                this.labelString = value.getString();
                this.radioButton.setText(GUIUtils.parseTeX(value.getString()));
                break;
            }
            case 1: {
                if (value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = value.getString();
                this.radioButton.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                if (value.getString().equals(this.selectedimageFile)) {
                    return;
                }
                this.selectedimageFile = value.getString();
                this.radioButton.setSelectedIcon(this.getIcon(this.selectedimageFile));
                break;
            }
            case 3: {
                this.radioButton.setHorizontalAlignment(value.getInteger());
                break;
            }
            case 4: {
                this.internalValue.value = value.getBoolean();
                this.radioButton.setSelected(this.internalValue.value);
                break;
            }
            case 5: {
                this.defaultStateSet = true;
                this.defaultState = value.getBoolean();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 7: {
                this.removeAction(20, this.getProperty("actionon"));
                this.addAction(20, value.getString());
                break;
            }
            case 8: {
                this.removeAction(21, this.getProperty("actionoff"));
                this.addAction(21, value.getString());
                break;
            }
            case 9: {
                this.radioButton.setMnemonic(value.getString().charAt(0));
                break;
            }
            default: {
                super.setValue(n - 10, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.labelString = "";
                this.radioButton.setText("");
                break;
            }
            case 1: {
                this.radioButton.setIcon(null);
                this.imageFile = null;
                break;
            }
            case 2: {
                this.radioButton.setIcon(null);
                this.selectedimageFile = null;
                break;
            }
            case 3: {
                this.radioButton.setHorizontalAlignment(0);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.defaultStateSet = false;
                break;
            }
            case 6: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 7: {
                this.removeAction(20, this.getProperty("actionon"));
                break;
            }
            case 8: {
                this.removeAction(21, this.getProperty("actionoff"));
                break;
            }
            case 9: {
                this.radioButton.setMnemonic(-1);
                break;
            }
            default: {
                super.setDefaultValue(n - 10);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 4: {
                return this.internalValue;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(n - 10);
    }
}

