/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.border.EmptyBorder;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlMenu;
import org.opensourcephysics.ejs.control.swing.ControlWindow;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlMenuBar
extends ControlContainer {
    protected JMenuBar menubar;
    private Rectangle myBorder = null;
    private ControlWindow myWindow = null;
    private static ArrayList infoList = null;

    public ControlMenuBar(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.menubar = object instanceof JMenuBar ? (JMenuBar)object : new JMenuBar();
        return this.menubar;
    }

    public void setControlWindow(ControlWindow controlWindow) {
        this.myWindow = controlWindow;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("borderPainted");
            infoList.add("border");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("borderPainted")) {
            return "boolean";
        }
        if (string.equals("border")) {
            return "Margins|Object";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.menubar.setBorderPainted(value.getBoolean());
                break;
            }
            case 1: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myBorder) break;
                this.menubar.setBorder(new EmptyBorder(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                this.myBorder = rectangle;
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.menubar.setBorderPainted(true);
                break;
            }
            case 1: {
                this.menubar.setBorder(null);
                this.myBorder = null;
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return super.getValue(n - 2);
    }

    public void add(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenu)) {
            return;
        }
        this.children.add(controlElement);
        this.menubar.add((JMenu)controlElement.getVisual());
        if (this.myWindow != null) {
            this.myWindow.adjustSize();
        }
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    public void remove(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenu)) {
            return;
        }
        this.children.remove(controlElement);
        this.menubar.remove((JMenu)controlElement.getVisual());
        if (this.myWindow != null) {
            this.myWindow.adjustSize();
        }
    }
}

