/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MouseController;
import org.opensourcephysics.display.dialogs.AutoScaleInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.NeedsUpdate;
import org.opensourcephysics.ejs.control.swing.ControlDrawable;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.swing.NeedsPreUpdate;

public abstract class ControlDrawablesParent
extends ControlSwingElement
implements NeedsUpdate {
    private Vector preupdateList = new Vector();
    private String printTarget = null;
    protected boolean isZoomed = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean autoX;
    protected boolean autoY;
    protected boolean xminSet = false;
    protected boolean xmaxSet = false;
    protected boolean yminSet = false;
    protected boolean ymaxSet = false;

    public ControlDrawablesParent(Object object) {
        super(object);
        this.getVisual().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && ControlDrawablesParent.this.getSimulation() != null) {
                    if (keyEvent.getKeyCode() == 77) {
                        ControlDrawablesParent.this.getPopupMenu(0, 0);
                    } else if (keyEvent.getKeyCode() == 80) {
                        ControlDrawablesParent.this.printScreen();
                    }
                }
            }
        });
        this.getVisual().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) && ControlDrawablesParent.this.getSimulation() != null) {
                    Interactive interactive = ((InteractivePanel)ControlDrawablesParent.this.getVisual()).getInteractive();
                    if (interactive != null) {
                        if (interactive instanceof InteractiveTrace) {
                            ((InteractiveTrace)interactive).showPopup(ControlDrawablesParent.this.getVisual(), mouseEvent.getX(), mouseEvent.getY());
                        } else if (interactive instanceof InteractivePoligon) {
                            ((InteractivePoligon)interactive).showPopup(ControlDrawablesParent.this.getVisual(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else {
                        ControlDrawablesParent.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        });
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        return super.getPropertyCommonName(string);
    }

    public void addMenuEntries() {
        if (this.getVisual() instanceof DrawingPanel3D) {
            return;
        }
        if (this.getMenuNameEntry() == null) {
            return;
        }
        JMenuItem jMenuItem = new JMenuItem("tools_res:MenuItem.Scale");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.isZoomed = true;
                ScaleInspector scaleInspector = new ScaleInspector((DrawingPanel)ControlDrawablesParent.this.getVisual());
                scaleInspector.setLocationRelativeTo((DrawingPanel)ControlDrawablesParent.this.getVisual());
                scaleInspector.updateDisplay();
                scaleInspector.setVisible(true);
            }
        });
        jMenuItem.setActionCommand("tools_res:MenuItem.Scale");
        JMenuItem jMenuItem2 = new JMenuItem("tools_res:MenuItem.ZoomIn");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.checkAutoscaling();
                new ZoomController();
            }
        });
        jMenuItem2.setActionCommand("tools_res:MenuItem.ZoomIn");
        JMenuItem jMenuItem3 = new JMenuItem("tools_res:MenuItem.ZoomOut");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.checkAutoscaling();
                double d = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMin();
                double d2 = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMax();
                double d3 = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMin();
                double d4 = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMax();
                double d5 = d2 - d;
                double d6 = d4 - d3;
                ControlDrawablesParent.this.isZoomed = true;
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleX()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxX(d - d5 / 2.0, d2 + d5 / 2.0);
                }
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleY()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxY(d3 - d6 / 2.0, d4 + d6 / 2.0);
                }
                ControlDrawablesParent.this.update();
            }
        });
        jMenuItem3.setActionCommand("tools_res:MenuItem.ZoomOut");
        JMenuItem jMenuItem4 = new JMenuItem("tools_res:MenuItem.ZoomCancel");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.isZoomed = false;
                ControlDrawablesParent.this.updateAutoscale();
                ControlDrawablesParent.this.updateExtrema();
                ControlDrawablesParent.this.update();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).render();
            }
        });
        jMenuItem4.setActionCommand("tools_res:MenuItem.ZoomCancel");
        JMenu jMenu = new JMenu("tools_res:MenuItem.Zoom");
        jMenu.setActionCommand("tools_res:MenuItem.Zoom");
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("display_res:DrawingFrame.Text_checkbox_label", false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasTextOn(jCheckBoxMenuItem.isSelected());
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
            }
        });
        jCheckBoxMenuItem.setActionCommand("display_res:DrawingFrame.Text_checkbox_label");
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("display_res:DrawingFrame.Drawing_textbox_label", false);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasShapeOn(jCheckBoxMenuItem2.isSelected());
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
            }
        });
        jCheckBoxMenuItem2.setActionCommand("display_res:DrawingFrame.Drawing_textbox_label");
        JMenu jMenu2 = new JMenu("display_res:DrawingFrame.AntiAlias_menu_title");
        jMenu2.add(jCheckBoxMenuItem);
        jMenu2.add(jCheckBoxMenuItem2);
        jMenu2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jCheckBoxMenuItem.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasTextOn());
                jCheckBoxMenuItem2.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasShapeOn());
            }
        });
        jMenu2.setActionCommand("display_res:DrawingFrame.AntiAlias_menu_title");
        ArrayList<JMenu> arrayList = new ArrayList<JMenu>();
        arrayList.add(jMenu);
        arrayList.add(jMenu2);
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), arrayList);
    }

    public void reset() {
        this.isZoomed = false;
        this.updateAutoscale();
        this.updateExtrema();
        if (this.isUnderEjs) {
            ((DrawingPanel)this.getVisual()).setBuffered(false);
        }
    }

    protected void updateAutoscale() {
        if (!this.isZoomed) {
            DrawingPanel drawingPanel = (DrawingPanel)this.getVisual();
            drawingPanel.setAutoscaleX(this.autoX);
            drawingPanel.setAutoscaleY(this.autoY);
        }
    }

    protected void updateExtrema() {
        if (!this.isZoomed) {
            DrawingPanel drawingPanel = (DrawingPanel)this.getVisual();
            if (drawingPanel.isAutoscaleX()) {
                if (this.xminSet || this.xmaxSet) {
                    drawingPanel.limitAutoscaleX(this.minX, this.maxX);
                }
            } else {
                drawingPanel.setPreferredMinMaxX(this.minX, this.maxX);
            }
            if (drawingPanel.isAutoscaleY()) {
                if (this.yminSet || this.ymaxSet) {
                    drawingPanel.limitAutoscaleY(this.minY, this.maxY);
                }
            } else {
                drawingPanel.setPreferredMinMaxY(this.minY, this.maxY);
            }
        }
    }

    private void checkAutoscaling() {
        DrawingPanel drawingPanel = (DrawingPanel)this.getVisual();
        if (drawingPanel.isAutoscaleX() || drawingPanel.isAutoscaleY()) {
            this.isZoomed = true;
            AutoScaleInspector autoScaleInspector = new AutoScaleInspector(drawingPanel);
            autoScaleInspector.setLocationRelativeTo(drawingPanel);
            autoScaleInspector.updateDisplay();
            autoScaleInspector.setVisible(true);
        }
    }

    public boolean acceptsChild(ControlElement controlElement) {
        return controlElement instanceof ControlDrawable;
    }

    public void setPrintTarget(String string) {
        this.printTarget = string;
    }

    protected void getPopupMenu(int n, int n2) {
        if (this.printTarget == null) {
            this.getSimulation().getPopupMenu(this.getVisual(), n, n2, this.getProperty("name"));
        } else {
            this.getSimulation().getPopupMenu(this.getVisual(), n, n2, this.printTarget);
        }
    }

    private void printScreen() {
        if (this.printTarget == null) {
            this.getSimulation().saveImage(this.getProperty("name"));
        } else {
            this.getSimulation().saveImage(this.printTarget);
        }
    }

    public void update() {
        Enumeration enumeration = this.preupdateList.elements();
        while (enumeration.hasMoreElements()) {
            NeedsPreUpdate needsPreUpdate = (NeedsPreUpdate)enumeration.nextElement();
            needsPreUpdate.preupdate();
        }
        if (this.myGroup != null && this.myGroup.isCollectingData()) {
            return;
        }
        ((DrawingPanel)this.getVisual()).render();
    }

    public void addToPreupdateList(NeedsPreUpdate needsPreUpdate) {
        this.preupdateList.add(needsPreUpdate);
    }

    public void removeFromPreupdateList(NeedsPreUpdate needsPreUpdate) {
        this.preupdateList.remove(needsPreUpdate);
    }

    public ControlDrawable getSelectedDrawable() {
        return null;
    }

    class ZoomController
    extends MouseController {
        ZoomController() {
            DrawingPanel drawingPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            drawingPanel.addMouseListener(this);
            drawingPanel.addMouseMotionListener(this);
            drawingPanel.getZoomBox().prepareZoom();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().startZoom(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().drag(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DrawingPanel drawingPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            Rectangle2D.Double double_ = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().reportZoom(mouseEvent.getX(), mouseEvent.getY());
            drawingPanel.removeMouseListener(this);
            drawingPanel.removeMouseMotionListener(this);
            if (double_ != null) {
                ControlDrawablesParent.this.isZoomed = true;
                if (!drawingPanel.isAutoscaleX()) {
                    drawingPanel.setPreferredMinMaxX(double_.x, double_.x + double_.width);
                }
                if (!drawingPanel.isAutoscaleY()) {
                    drawingPanel.setPreferredMinMaxY(double_.y, double_.y + double_.height);
                }
                ControlDrawablesParent.this.update();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

