/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlDrawablesParent;
import org.opensourcephysics.ejs.control.swing.NeedsPreUpdate;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlDrawable
extends ControlElement {
    public static final int NAME = 0;
    public static final int PARENT = 1;
    protected ControlDrawablesParent myParent;
    private Drawable myDrawable = null;
    private String menuNameEntry = null;
    private static ArrayList infoList = null;

    public ControlDrawable(Object object) {
        super(object);
        this.myDrawable = this.createDrawable(object);
        this.myObject = this.myDrawable;
    }

    protected abstract Drawable createDrawable(Object var1);

    protected void setName(String string) {
    }

    public final Drawable getDrawable() {
        return this.myDrawable;
    }

    public final void setDrawable(Drawable drawable) {
        this.myDrawable = drawable;
    }

    public void setParent(ControlDrawablesParent controlDrawablesParent) {
        if (this.myParent != null) {
            ((DrawingPanel)this.myParent.getVisual()).removeDrawable(this.myDrawable);
            if (this instanceof NeedsPreUpdate) {
                this.myParent.removeFromPreupdateList((NeedsPreUpdate)((Object)this));
            }
        }
        if (controlDrawablesParent != null) {
            ((DrawingPanel)controlDrawablesParent.getVisual()).addDrawable(this.myDrawable);
            ((DrawingPanel)controlDrawablesParent.getVisual()).render();
            if (this instanceof NeedsPreUpdate) {
                controlDrawablesParent.addToPreupdateList((NeedsPreUpdate)((Object)this));
            }
            this.myParent = controlDrawablesParent;
        }
    }

    public final ControlDrawablesParent getParent() {
        return this.myParent;
    }

    public void destroy() {
        super.destroy();
        if (this.myParent != null) {
            ((DrawingPanel)this.myParent.getVisual()).render();
        }
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("menuName");
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String         CONSTANT";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        return null;
    }

    public String getMenuNameEntry() {
        if (this.menuNameEntry != null) {
            if (this.menuNameEntry.equals("null")) {
                return null;
            }
            return this.menuNameEntry;
        }
        return this.getProperty("name");
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setName(value.getString());
                super.setValue(0, value);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null) {
                    this.setParent(null);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    System.err.println(this.getClass().getName() + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlDrawablesParent) {
                    this.setParent((ControlDrawablesParent)controlElement);
                    break;
                }
                System.err.println(this.getClass().getName() + " : Error! Parent <" + value + "> is not a ControlDrawablesParent");
                break;
            }
            case 2: {
                this.menuNameEntry = value.getString();
                break;
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.setName("");
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.menuNameEntry = null;
                break;
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "null";
            }
            case 2: {
                return this.getProperty("name");
            }
        }
        return super.getDefaultValueString(n - 3);
    }

    public Value getValue(int n) {
        switch (n) {
            default: 
        }
        return null;
    }
}

