/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.ejs.control.ConstantParser;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlBar
extends ControlSwingElement {
    private static final int RESOLUTION = 100000;
    protected JProgressBar bar;
    private double scale;
    private double minimum = 0.0;
    private double maximum = 1.0;
    private double variable = 0.0;
    private DecimalFormat format;
    private String formatStr = null;
    private static ArrayList infoList = null;

    public ControlBar(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof JProgressBar) {
            this.bar = (JProgressBar)object;
        } else {
            this.bar = new JProgressBar(0);
            this.bar.setBorderPainted(true);
            this.bar.setStringPainted(false);
        }
        this.bar.setMinimum(0);
        this.bar.setMaximum(100000);
        this.minimum = 0.0;
        this.maximum = 1.0;
        this.variable = this.bar.getValue();
        this.scale = 100000.0 * (this.maximum - this.minimum);
        this.format = null;
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        return this.bar;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("variable");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("format");
            infoList.add("orientation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "int|double";
        }
        if (string.equals("minimum")) {
            return "int|double";
        }
        if (string.equals("maximum")) {
            return "int|double";
        }
        if (string.equals("format")) {
            return "Format|Object|String  TRANSLATABLE";
        }
        if (string.equals("orientation")) {
            return "Orientation|int";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setValue(value.getDouble());
                break;
            }
            case 1: {
                this.setMinimum(value.getDouble());
                break;
            }
            case 2: {
                this.setMaximum(value.getDouble());
                break;
            }
            case 3: {
                DecimalFormat decimalFormat = null;
                if (value.getObject() instanceof DecimalFormat) {
                    decimalFormat = (DecimalFormat)value.getObject();
                    this.formatStr = null;
                } else {
                    String string = GUIUtils.parseTeX(value.getString());
                    if (string.equals(this.formatStr)) {
                        return;
                    }
                    this.formatStr = string;
                    decimalFormat = (DecimalFormat)ConstantParser.formatConstant(this.formatStr).getObject();
                }
                if (decimalFormat.equals(this.format)) {
                    return;
                }
                this.format = decimalFormat;
                if (this.format != null) {
                    this.bar.setString(this.format.format(this.variable));
                    this.bar.setStringPainted(true);
                    break;
                }
                this.bar.setStringPainted(false);
                break;
            }
            case 4: {
                if (this.bar.getOrientation() == value.getInteger()) break;
                this.bar.setOrientation(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.setMinimum(0.0);
                break;
            }
            case 2: {
                this.setMaximum(1.0);
                break;
            }
            case 3: {
                this.format = null;
                this.formatStr = null;
                this.bar.setStringPainted(false);
                break;
            }
            case 4: {
                this.bar.setOrientation(0);
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }

    private void setValue(double d) {
        if (d == this.variable) {
            return;
        }
        this.variable = d;
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        if (this.format != null) {
            this.bar.setString(this.format.format(this.variable));
        }
    }

    private void setMinimum(double d) {
        if (d == this.minimum) {
            return;
        }
        this.minimum = d;
        if (this.minimum >= this.maximum) {
            this.maximum = this.minimum + 1.0;
        }
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        if (this.format != null) {
            this.bar.setString(this.format.format(this.variable));
        }
    }

    private void setMaximum(double d) {
        if (d == this.maximum) {
            return;
        }
        this.maximum = d;
        if (this.minimum >= this.maximum) {
            this.minimum = this.maximum - 1.0;
        }
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.bar.setValue((int)((this.variable - this.minimum) * this.scale));
        if (this.format != null) {
            this.bar.setString(this.format.format(this.variable));
        }
    }
}

