/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractivePlane;
import org.opensourcephysics.ejs.control.displayejs.ControlInteractiveTile;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlPlane
extends ControlInteractiveTile {
    static final int PROPERTIES_PLANE = 9;
    static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{9, 10, 11};
    private static final int[] sizeSpot = new int[]{12, 13, 14};

    public ControlPlane(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        InteractivePlane interactivePlane = object instanceof InteractivePlane ? (InteractivePlane)object : new InteractivePlane();
        interactivePlane.setOrigin(0.0, 0.0, 0.0, true);
        return interactivePlane;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("direction1");
            infoList.add("direction2");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("color")) {
            return "lineColor";
        }
        if (string.equals("secondaryColor")) {
            return "fillColor";
        }
        if (string.equals("direction1")) {
            return "firstDirection";
        }
        if (string.equals("direction2")) {
            return "secondDirection";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("direction1")) {
            return "double[]";
        }
        if (string.equals("direction2")) {
            return "double[]";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (!(value.getObject() instanceof double[])) break;
                double[] dArray = (double[])value.getObject();
                ((InteractivePlane)this.myElement).setVectorU(dArray[0], dArray[1], dArray[2]);
                break;
            }
            case 1: {
                if (!(value.getObject() instanceof double[])) break;
                double[] dArray = (double[])value.getObject();
                ((InteractivePlane)this.myElement).setVectorV(dArray[0], dArray[1], dArray[2]);
                break;
            }
            default: {
                super.setValue(n - 2, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                ((InteractivePlane)this.myElement).setVectorU(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                ((InteractivePlane)this.myElement).setVectorV(0.0, 1.0, 0.0);
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "{1.0,0.0,0.0}";
            }
            case 1: {
                return "{0.0,1.0,0.0}";
            }
        }
        return super.getDefaultValueString(n - 2);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
        }
        return this.getValue(n - 2);
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }
}

