/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.displayejs.Style;
import org.opensourcephysics.ejs.control.displayejs.ControlDrawable3D;
import org.opensourcephysics.ejs.control.displayejs.ControlDrawingPanel3D;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlInteractiveElement
extends ControlDrawable3D
implements InteractionListener {
    public static final int IE_ADDED = 28;
    public static final int ACTION_PRESS = 10;
    public static final int ACTION_ENTERED = 11;
    public static final int ACTION_EXITED = 12;
    protected static final int POSITION_X = 0;
    protected static final int POSITION_Y = 1;
    protected static final int POSITION_Z = 2;
    protected static final int SIZE_X = 3;
    protected static final int SIZE_Y = 4;
    protected static final int SIZE_Z = 5;
    protected static final int ENABLED = 7;
    protected static final int ENABLED_SECONDARY = 8;
    protected static final int STYLE = 14;
    protected static final int PRIMARY_COLOR = 18;
    protected static final int SECONDARY_COLOR = 19;
    protected InteractiveElement myElement;
    protected DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0), new DoubleValue(0.0)};
    protected DoubleValue[] sizeValues;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double scalez = 1.0;
    protected double lineWidth = 1.0;
    protected Font font;
    protected Font defaultFont;
    protected boolean enabledEjsEdit = false;
    static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{0, 1, 2};
    private static final int[] sizeSpot = new int[]{3, 4, 5};

    public ControlInteractiveElement(Object object) {
        super(object);
        if (this.sizeValues == null) {
            this.sizeValues = new DoubleValue[]{new DoubleValue(0.1), new DoubleValue(0.1), new DoubleValue(0.1)};
        }
        this.myElement = (InteractiveElement)this.getDrawable();
        this.myElement.addListener(this);
        this.myElement.setDataObject(this);
        this.defaultFont = this.font = this.myElement.getStyle().getFont();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("sizex");
            infoList.add("sizey");
            infoList.add("sizez");
            infoList.add("visible");
            infoList.add("enabled");
            infoList.add("enabledSecondary");
            infoList.add("scalex");
            infoList.add("scaley");
            infoList.add("scalez");
            infoList.add("group");
            infoList.add("groupEnabled");
            infoList.add("style");
            infoList.add("elementposition");
            infoList.add("angle");
            infoList.add("resolution");
            infoList.add("color");
            infoList.add("secondaryColor");
            infoList.add("stroke");
            infoList.add("font");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("sensitivity");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("angle")) {
            return "rotationAngle";
        }
        if (string.equals("color")) {
            return "fillColor";
        }
        if (string.equals("secondaryColor")) {
            return "lineColor";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("enabled")) {
            return "enabledPosition";
        }
        if (string.equals("enabledSecondary")) {
            return "enabledSize";
        }
        if (string.equals("sizex")) {
            return "sizeX";
        }
        if (string.equals("sizey")) {
            return "sizeY";
        }
        if (string.equals("sizez")) {
            return "sizeZ";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("z")) {
            return "int|double DEPRECATED";
        }
        if (string.equals("sizex")) {
            return "int|double";
        }
        if (string.equals("sizey")) {
            return "int|double";
        }
        if (string.equals("sizez")) {
            return "int|double  DEPRECATED";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        if (string.equals("enabledSecondary")) {
            return "boolean";
        }
        if (string.equals("scalex")) {
            return "int|double";
        }
        if (string.equals("scaley")) {
            return "int|double";
        }
        if (string.equals("scalez")) {
            return "int|double DEPRECATED";
        }
        if (string.equals("style")) {
            return "MarkerShape|int";
        }
        if (string.equals("elementposition")) {
            return "ElementPosition|int";
        }
        if (string.equals("angle")) {
            return "int|double";
        }
        if (string.equals("resolution")) {
            return "Resolution|String|Object DEPRECATED";
        }
        if (string.equals("color")) {
            return "Color|Object";
        }
        if (string.equals("secondaryColor")) {
            return "Color|Object";
        }
        if (string.equals("stroke")) {
            return "int|double|Object";
        }
        if (string.equals("font")) {
            return "Font|Object";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("sensitivity")) {
            return "int";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.posValues[0].value = value.getDouble();
                this.myElement.setX(this.posValues[0].value);
                break;
            }
            case 1: {
                this.posValues[1].value = value.getDouble();
                this.myElement.setY(this.posValues[1].value);
                break;
            }
            case 2: {
                this.posValues[2].value = value.getDouble();
                this.myElement.setZ(this.posValues[2].value);
                break;
            }
            case 3: {
                this.sizeValues[0].value = value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 4: {
                this.sizeValues[1].value = value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 5: {
                this.sizeValues[2].value = value.getDouble();
                this.myElement.setSizeZ(this.sizeValues[2].value * this.scalez);
                break;
            }
            case 6: {
                this.myElement.setVisible(value.getBoolean());
                break;
            }
            case 7: {
                this.myElement.setEnabled(0, value.getBoolean());
                break;
            }
            case 8: {
                this.myElement.setEnabled(1, value.getBoolean());
                break;
            }
            case 9: {
                this.scalex = value.getDouble();
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 10: {
                this.scaley = value.getDouble();
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 11: {
                this.scalez = value.getDouble();
                this.myElement.setSizeZ(this.sizeValues[2].value * this.scalez);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                this.myElement.setGroupEnabled(value.getBoolean());
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.myElement.getStyle().setPosition(value.getInteger());
                break;
            }
            case 16: {
                if (value instanceof IntegerValue) {
                    this.myElement.getStyle().setAngle((double)value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.myElement.getStyle().setAngle(value.getDouble());
                break;
            }
            case 17: {
                if (value.getObject() instanceof Resolution) {
                    this.myElement.setResolution((Resolution)value.getObject());
                    break;
                }
                Resolution resolution = ControlDrawable3D.decodeResolution(value.toString());
                if (resolution == null) break;
                this.myElement.setResolution(resolution);
                break;
            }
            case 18: {
                this.myElement.getStyle().setEdgeColor((Color)value.getObject());
                break;
            }
            case 19: {
                Paint paint = (Paint)value.getObject();
                if (paint == NULL_COLOR) {
                    paint = null;
                }
                this.myElement.getStyle().setFillPattern(paint);
                break;
            }
            case 20: {
                if (value.getObject() instanceof Stroke) {
                    this.myElement.getStyle().setEdgeStroke((Stroke)value.getObject());
                    break;
                }
                if (this.lineWidth == value.getDouble()) break;
                this.lineWidth = value.getDouble();
                if (this.lineWidth < 0.0) {
                    this.myElement.getStyle().setEdgeStroke(new BasicStroke((float)(-this.lineWidth), 0, 0, 10.0f, Style.DASHED_STROKE, 0.0f));
                    break;
                }
                this.myElement.getStyle().setEdgeStroke(new BasicStroke((float)this.lineWidth));
                break;
            }
            case 21: {
                Font font;
                if (!(value.getObject() instanceof Font) || (font = (Font)value.getObject()) == this.font) break;
                this.font = font;
                this.myElement.getStyle().setFont(this.font);
                break;
            }
            case 22: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                return;
            }
            case 23: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                return;
            }
            case 24: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                return;
            }
            case 25: {
                this.removeAction(11, this.getProperty("enteredAction"));
                this.addAction(11, value.getString());
                return;
            }
            case 26: {
                this.removeAction(12, this.getProperty("exitedAction"));
                this.addAction(12, value.getString());
                return;
            }
            case 27: {
                this.myElement.setSensitivity(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 28, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.posValues[0].value = 0.0;
                this.myElement.setX(0.0);
                break;
            }
            case 1: {
                this.posValues[1].value = 0.0;
                this.myElement.setY(0.0);
                break;
            }
            case 2: {
                this.posValues[2].value = 0.0;
                this.myElement.setZ(0.0);
                break;
            }
            case 3: {
                this.sizeValues[0].value = 0.1;
                this.myElement.setSizeX(this.sizeValues[0].value * this.scalex);
                break;
            }
            case 4: {
                this.sizeValues[1].value = 0.1;
                this.myElement.setSizeY(this.sizeValues[1].value * this.scaley);
                break;
            }
            case 5: {
                this.sizeValues[2].value = 0.1;
                this.myElement.setSizeZ(this.sizeValues[2].value * this.scalez);
                break;
            }
            case 6: {
                this.myElement.setVisible(true);
                break;
            }
            case 7: {
                this.myElement.setEnabled(0, true);
                break;
            }
            case 8: {
                this.myElement.setEnabled(1, false);
                break;
            }
            case 9: {
                this.scalex = 1.0;
                this.myElement.setSizeX(this.sizeValues[0].value);
                break;
            }
            case 10: {
                this.scaley = 1.0;
                this.myElement.setSizeY(this.sizeValues[1].value);
                break;
            }
            case 11: {
                this.scalez = 1.0;
                this.myElement.setSizeZ(this.sizeValues[2].value);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                this.myElement.setGroupEnabled(true);
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.myElement.getStyle().setPosition(0);
                break;
            }
            case 16: {
                this.myElement.getStyle().setAngle(0.0);
                break;
            }
            case 17: {
                this.myElement.setResolution(null);
                break;
            }
            case 18: {
                this.myElement.getStyle().setEdgeColor(Color.black);
                break;
            }
            case 19: {
                this.myElement.getStyle().setFillPattern(Color.blue);
                break;
            }
            case 20: {
                this.myElement.getStyle().setEdgeStroke(new BasicStroke());
                break;
            }
            case 21: {
                this.font = this.defaultFont;
                this.myElement.getStyle().setFont(this.font);
                break;
            }
            case 22: {
                this.removeAction(10, this.getProperty("pressaction"));
                return;
            }
            case 23: {
                this.removeAction(1, this.getProperty("dragaction"));
                return;
            }
            case 24: {
                this.removeAction(0, this.getProperty("action"));
                return;
            }
            case 25: {
                this.removeAction(11, this.getProperty("enteredAction"));
                return;
            }
            case 26: {
                this.removeAction(12, this.getProperty("exitedAction"));
                return;
            }
            case 27: {
                this.myElement.setSensitivity(AbstractInteractiveElement.SENSIBILITY);
                break;
            }
            default: {
                super.setDefaultValue(n - 28);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "0";
            }
            case 3: 
            case 4: 
            case 5: {
                return "0.1";
            }
            case 6: {
                return "true";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "false";
            }
            case 9: 
            case 10: 
            case 11: {
                return "1";
            }
            case 12: {
                return "<none>";
            }
            case 13: {
                return "true";
            }
            case 14: {
                return "<none>";
            }
            case 15: {
                return "CENTERED";
            }
            case 16: {
                return "0.0";
            }
            case 17: {
                return "<none>";
            }
            case 18: {
                return "BLACK";
            }
            case 19: {
                return "BLUE";
            }
            case 20: {
                return "1.0";
            }
            case 21: {
                return this.defaultFont.toString();
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return "<no_action>";
            }
            case 27: {
                return "" + AbstractInteractiveElement.SENSIBILITY;
            }
        }
        return super.getDefaultValueString(n - 28);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.posValues[0];
            }
            case 1: {
                return this.posValues[1];
            }
            case 2: {
                return this.posValues[2];
            }
            case 3: {
                return this.sizeValues[0];
            }
            case 4: {
                return this.sizeValues[1];
            }
            case 5: {
                return this.sizeValues[2];
            }
        }
        return null;
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2004: {
                this.invokeActions(12);
                break;
            }
            case 2003: {
                this.invokeActions(11);
                break;
            }
            case 2000: {
                if (this.myParent instanceof ControlDrawingPanel3D) {
                    ((ControlDrawingPanel3D)this.myParent).setSelectedDrawable(this);
                }
                this.invokeActions(10);
            }
            case 2001: {
                if (interactionEvent.getTarget().getClass() == InteractionTargetElementSize.class) {
                    this.sizeValues[0].value = this.scalex != 0.0 ? this.myElement.getSizeX() / this.scalex : this.myElement.getSizeX();
                    this.sizeValues[1].value = this.scaley != 0.0 ? this.myElement.getSizeY() / this.scaley : this.myElement.getSizeY();
                    this.sizeValues[2].value = this.scalez != 0.0 ? this.myElement.getSizeZ() / this.scalez : this.myElement.getSizeZ();
                    this.variablesChanged(this.getSizeSpot(), this.sizeValues);
                    if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                    this.setFieldListValues(this.getSizeSpot(), this.sizeValues);
                    break;
                }
                this.posValues[0].value = this.myElement.getX();
                this.posValues[1].value = this.myElement.getY();
                this.posValues[2].value = this.myElement.getZ();
                this.variablesChanged(this.getPosSpot(), this.posValues);
                if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                this.setFieldListValues(this.getPosSpot(), this.posValues);
                break;
            }
            case 2002: {
                if (this.myParent instanceof ControlDrawingPanel3D) {
                    ((ControlDrawingPanel3D)this.myParent).setSelectedDrawable(null);
                }
                this.invokeActions(0);
            }
        }
    }
}

