/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import java.util.StringTokenizer;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.ejs.control.ConstantParser;
import org.opensourcephysics.ejs.control.swing.ControlDrawable;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlDrawable3D
extends ControlDrawable {
    public static final Color NULL_COLOR = ConstantParser.NULL_COLOR;

    public ControlDrawable3D(Object object) {
        super(object);
    }

    public Value parseConstant(String string, String string2) {
        Resolution resolution;
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("ElementPosition") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("centered")) {
                return new IntegerValue(0);
            }
            if (string2.equals("north")) {
                return new IntegerValue(1);
            }
            if (string2.equals("south")) {
                return new IntegerValue(2);
            }
            if (string2.equals("east")) {
                return new IntegerValue(3);
            }
            if (string2.equals("west")) {
                return new IntegerValue(4);
            }
            if (string2.equals("north_east")) {
                return new IntegerValue(5);
            }
            if (string2.equals("north_west")) {
                return new IntegerValue(6);
            }
            if (string2.equals("south_east")) {
                return new IntegerValue(7);
            }
            if (string2.equals("south_west")) {
                return new IntegerValue(8);
            }
            if (string2.equals("hor_centered")) {
                return new IntegerValue(1);
            }
            if (string2.equals("hor_center_down")) {
                return new IntegerValue(1);
            }
            if (string2.equals("hor_center_up")) {
                return new IntegerValue(2);
            }
            if (string2.equals("ver_centered")) {
                return new IntegerValue(4);
            }
            if (string2.equals("ver_center_right")) {
                return new IntegerValue(4);
            }
            if (string2.equals("ver_center_left")) {
                return new IntegerValue(3);
            }
            if (string2.equals("lower_left")) {
                return new IntegerValue(8);
            }
            if (string2.equals("upper_left")) {
                return new IntegerValue(6);
            }
        }
        if (string.indexOf("MarkerShape") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("ellipse")) {
                return new IntegerValue(1);
            }
            if (string2.equals("rectangle")) {
                return new IntegerValue(2);
            }
            if (string2.equals("round_rectangle")) {
                return new IntegerValue(3);
            }
            if (string2.equals("wheel")) {
                return new IntegerValue(4);
            }
            if (string2.equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("filled_circle")) {
                return new IntegerValue(1);
            }
            if (string2.equals("circle")) {
                return new IntegerValue(1);
            }
            if (string2.equals("filled_square")) {
                return new IntegerValue(2);
            }
            if (string2.equals("square")) {
                return new IntegerValue(2);
            }
            if (string2.equals("no_marker")) {
                return new IntegerValue(0);
            }
        }
        if (string.indexOf("Resolution") >= 0 && (resolution = ControlDrawable3D.decodeResolution(string2)) != null) {
            return new ObjectValue(resolution);
        }
        return super.parseConstant(string, string2);
    }

    public static Resolution decodeResolution(String string) {
        if ((string = string.trim().toLowerCase()).indexOf(46) >= 0) {
            try {
                return Resolution.createDivisions(Double.parseDouble(string));
            }
            catch (Exception exception) {
                System.out.println("Incorrect double value for resolution");
                exception.printStackTrace();
                return null;
            }
        }
        if (string.indexOf(44) < 0) {
            try {
                new Resolution(Integer.parseInt(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (stringTokenizer.hasMoreTokens()) {
                return new Resolution(n, n2, Integer.parseInt(stringTokenizer.nextToken()));
            }
            return new Resolution(n, n2);
        }
        catch (Exception exception) {
            System.out.println("Incorrect integer values for resolution");
            exception.printStackTrace();
            return null;
        }
    }
}

