/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.automaticcontrol;

import java.awt.Color;
import java.util.ArrayList;
import org.opensourcephysics.automaticcontrol.Pump;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.ejs.control.automaticcontrol.ControlPoligonsAndTexts;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlPump
extends ControlPoligonsAndTexts {
    protected static final int PUMP_ADDED = 1;
    protected static final int MY_FILLCOLOR2 = 7;
    protected Pump pump;
    private static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{21, 22, 23};

    public ControlPump(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        this.pump = object instanceof Pump ? (Pump)object : new Pump();
        return this.pump;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("rotorAngle");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("rotorAngle")) {
            return "int|double";
        }
        if (string.equals("type")) {
            return "int|PumpType";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("PumpType") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("left")) {
                return new IntegerValue(1);
            }
            if (string2.equals("right")) {
                return new IntegerValue(0);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value instanceof IntegerValue) {
                    this.pump.setRotorAngle((double)value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.pump.setRotorAngle(value.getDouble());
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.pump.setRotorAngle(Double.NaN);
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
                break;
            }
            case 7: {
                this.pump.setFillColor2(Color.BLACK);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "NaN";
            }
            default: {
                return super.getDefaultValueString(n - 1);
            }
            case 7: 
        }
        return "BLACK";
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int getValueIndex() {
        return 13;
    }
}

