/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.automaticcontrol;

import java.awt.Paint;
import java.util.ArrayList;
import org.opensourcephysics.automaticcontrol.Pipe;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.ejs.control.displayejs.ControlPoligon;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlPipe
extends ControlPoligon {
    protected static final int PIPE_ADDED = 4;
    protected Pipe pipe;
    private static final int[] posSpot = new int[]{8, 9, 10};
    private static final int[] sizeSpot = new int[]{24, 25, 26};
    private static final int[] coordinatesSpot = new int[]{21, 22, 23};
    private static ArrayList infoList = null;

    public ControlPipe(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof Pipe) {
            this.pipe = (Pipe)object;
        } else {
            this.pipe = new Pipe();
            this.pipe.setData(new double[][]{{0.0, 0.0}, {0.2, 0.0}});
        }
        this.poligon = this.pipe;
        double[][] dArray = this.poligon.getData();
        this.coordinatesValues = new ObjectValue[3];
        if (dArray != null) {
            this.coordinatesValues[0] = new ObjectValue(dArray[0]);
            this.coordinatesValues[1] = new ObjectValue(dArray[1]);
            this.coordinatesValues[2] = new ObjectValue(dArray[2]);
        }
        return this.pipe;
    }

    protected int[] getPosSpot() {
        return posSpot;
    }

    protected int[] getSizeSpot() {
        return sizeSpot;
    }

    protected int[] getCoordinatesSpot() {
        return coordinatesSpot;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("width");
            infoList.add("filled");
            infoList.add("endClosed");
            infoList.add("emptyColor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("filled")) {
            return "drawingFill";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("width")) {
            return "int|double";
        }
        if (string.equals("filled")) {
            return "boolean";
        }
        if (string.equals("endClosed")) {
            return "boolean";
        }
        if (string.equals("emptyColor")) {
            return "Color|Object";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.pipe.setWidth(value.getDouble());
                break;
            }
            case 1: {
                this.pipe.setFilled(value.getBoolean());
                break;
            }
            case 2: {
                this.pipe.setEndClosed(value.getBoolean());
                break;
            }
            case 3: {
                Paint paint = (Paint)value.getObject();
                if (paint == NULL_COLOR) {
                    paint = null;
                }
                this.pipe.setEmptyPattern(paint);
                break;
            }
            default: {
                super.setValue(n - 4, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.pipe.setWidth(0.025);
                break;
            }
            case 1: {
                this.pipe.setFilled(false);
                break;
            }
            case 2: {
                this.pipe.setEndClosed(false);
                break;
            }
            case 3: {
                this.pipe.setEmptyPattern(null);
                break;
            }
            default: {
                super.setDefaultValue(n - 4);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "0.025";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "false";
            }
            case 3: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 4);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(n - 4);
    }
}

