/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.opensourcephysics.ejs.Function;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.GroupVariable;
import org.opensourcephysics.ejs.control.MethodWithOneParameter;
import org.opensourcephysics.ejs.control.NeedsUpdate;
import org.opensourcephysics.ejs.control.Resetable;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlDialog;
import org.opensourcephysics.ejs.control.swing.ControlDrawable;
import org.opensourcephysics.ejs.control.swing.ControlDrawablesParent;
import org.opensourcephysics.ejs.control.swing.ControlFrame;
import org.opensourcephysics.ejs.control.swing.ControlWindow;
import org.opensourcephysics.ejs.control.value.BooleanValue;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.ObjectValue;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;
import org.opensourcephysics.tools.ResourceLoader;

public class GroupControl {
    public static final int DEBUG_NONE = 0;
    public static final int DEBUG_SET_AND_GET = 1;
    public static final int DEBUG_ELEMENTS = 2;
    public static final int DEBUG_CONTROL = 4;
    public static final int DEBUG_CONTROL_VERBOSE = 8;
    public static final int DEBUG_DRAWING = 16;
    public static final int DEBUG_DRAWING_VERBOSE = 32;
    public static final int DEBUG_SYSTEM = 64;
    public static final int DEBUG_SYSTEM_VERBOSE = 128;
    public static final int DEBUG_ALL = 255;
    private int debugLevel = 0;
    private String debugPrefix = "";
    protected String replaceOwnerName = null;
    private Frame ownerFrame = null;
    protected Frame replaceOwnerFrame = null;
    protected boolean mustUpdateSimulation = true;
    protected boolean justCollectingData = false;
    private Vector prefixList = new Vector();
    private Simulation mySimulation = null;
    private Hashtable targetTable = new Hashtable();
    private Hashtable elementTable = new Hashtable();
    Hashtable variableTable = new Hashtable();
    private Vector elementList = new Vector();
    private Vector updateList = new Vector();
    private URL usercodebase = null;
    private Point displacement = new Point(0, 0);
    GroupVariable methodTriggerVariable = null;
    private Hashtable drawablesReparented = new Hashtable();
    private BooleanValue booleanValue = new BooleanValue(false);
    private IntegerValue integerValue = new IntegerValue(0);
    private DoubleValue doubleValue = new DoubleValue(0.0);
    private StringValue stringValue = new StringValue("");
    private ObjectValue objectValue = new ObjectValue(null);

    public GroupControl() {
        this.debugPrefix = this.getClass().getName();
        int n = this.debugPrefix.lastIndexOf(".");
        if (n >= 0) {
            this.debugPrefix = this.debugPrefix.substring(n + 1);
        }
        this.appendPrefixPath("org.opensourcephysics.ejs.control.swing.Control");
        this.appendPrefixPath("org.opensourcephysics.ejs.control.drawables.Control");
        this.appendPrefixPath("org.opensourcephysics.ejs.control.displayejs.Control");
        this.setValue("_expr_", new BooleanValue(false));
        this.methodTriggerVariable = (GroupVariable)this.variableTable.get("_expr_");
    }

    public GroupControl(Object object) {
        this();
        this.addTarget("_default_", object);
        if (object instanceof Simulation) {
            this.setSimulation((Simulation)object);
        }
    }

    public GroupControl(Object object, String string, Frame frame) {
        this(object);
        this.replaceOwnerFrame(string, frame);
    }

    public void setOwnerFrame(Frame frame) {
        this.ownerFrame = frame;
    }

    public Frame getOwnerFrame() {
        return this.ownerFrame;
    }

    public void replaceOwnerFrame(String string, Frame frame) {
        this.replaceOwnerName = string;
        this.replaceOwnerFrame = frame;
    }

    public String getReplaceOwnerName() {
        return this.replaceOwnerName;
    }

    public Frame getReplaceOwnerFrame() {
        return this.replaceOwnerFrame;
    }

    public void clearPrefixPath() {
        this.prefixList.clear();
    }

    public void appendPrefixPath(String string) {
        this.prefixList.add(string);
    }

    public Vector getDefaultPrefixList() {
        return this.prefixList;
    }

    public void setSimulation(Simulation simulation) {
        this.mySimulation = simulation;
    }

    public Simulation getSimulation() {
        return this.mySimulation;
    }

    public void setUpdateSimulation(boolean bl) {
        this.mustUpdateSimulation = bl;
    }

    public void updateSimulation() {
        if (this.mustUpdateSimulation && this.mySimulation != null) {
            this.mySimulation.update();
        }
    }

    public void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public boolean isCollectingData() {
        return this.justCollectingData;
    }

    public void addElementsMenuEntries() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).addMenuEntries();
        }
    }

    public void setDisplacement(int n, int n2) {
        this.setDisplacement(n, n2, null);
    }

    public void setDisplacement(int n, int n2, GroupControl groupControl) {
        if (groupControl != null) {
            this.displacement.x = n + groupControl.displacement.x;
            this.displacement.y = n2 + groupControl.displacement.y;
        } else {
            this.displacement.x = n;
            this.displacement.y = n2;
        }
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ControlElement controlElement = (ControlElement)enumeration.nextElement();
            if (!(controlElement instanceof ControlWindow)) continue;
            ((ControlWindow)controlElement).updateLocation();
        }
    }

    public Point getDisplacement() {
        return this.displacement;
    }

    public boolean reparentDrawable(String string, ControlElement controlElement) {
        ControlElement controlElement2 = this.getElement(string);
        if (controlElement2 instanceof ControlDrawable && controlElement instanceof ControlDrawablesParent) {
            this.drawablesReparented.put(controlElement2, ((ControlDrawable)controlElement2).getParent());
            ((ControlDrawable)controlElement2).setParent((ControlDrawablesParent)controlElement);
            return true;
        }
        JOptionPane.showMessageDialog(null, "Can't reparent drawable.\nOne of the elements is not of the right type", "Error", 1);
        return false;
    }

    public void undoReparenting() {
        Enumeration enumeration = this.drawablesReparented.keys();
        while (enumeration.hasMoreElements()) {
            ControlDrawable controlDrawable = (ControlDrawable)enumeration.nextElement();
            controlDrawable.setParent((ControlDrawablesParent)this.drawablesReparented.get(controlDrawable));
        }
        this.drawablesReparented.clear();
    }

    public void dispose() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ControlElement controlElement = (ControlElement)enumeration.nextElement();
            if (!(controlElement instanceof ControlWindow)) continue;
            ((ControlWindow)controlElement).dispose();
        }
    }

    public Object getTarget(String string) {
        return this.targetTable.get(string);
    }

    public void addTarget(String string, Object object) {
        this.targetTable.put(string, object);
    }

    public void removeTarget(String string) {
        this.targetTable.remove(string);
    }

    public void setValue(String string, Value value) {
        this.setValue(string, value, false);
    }

    public void setValue(String string, Value value, boolean bl) {
        GroupVariable groupVariable = (GroupVariable)this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, value);
            groupVariable.setValueObsolete(false);
            groupVariable.setDefinedInModel(bl);
            this.variableTable.put(string, groupVariable);
        } else {
            groupVariable.setValue(value);
            groupVariable.setValueObsolete(false);
            if (bl) {
                groupVariable.setDefinedInModel(true);
            }
            groupVariable.propagateValue(null, this.justCollectingData);
        }
    }

    public Value getValue(String string) {
        GroupVariable groupVariable = (GroupVariable)this.variableTable.get(string);
        if (groupVariable == null) {
            return null;
        }
        return groupVariable.getValue();
    }

    public GroupVariable getVariable(String string) {
        return (GroupVariable)this.variableTable.get(string);
    }

    public GroupVariable registerVariable(String string, ControlElement controlElement, int n, Value value) {
        if (string == null) {
            return null;
        }
        GroupVariable groupVariable = (GroupVariable)this.variableTable.get(string);
        if (groupVariable == null) {
            groupVariable = new GroupVariable(string, value);
            this.variableTable.put(string, groupVariable);
            if ((this.debugLevel & 1) > 0) {
                System.out.print("   Created new variable <" + string + "> with value = <" + value + "> ...");
            }
        }
        if ((this.debugLevel & 1) > 0) {
            System.out.println("   Variable <" + string + "> registered for element <" + controlElement + ">");
        }
        groupVariable.addElementListener(controlElement, n);
        groupVariable.propagateValue(null, this.justCollectingData);
        return groupVariable;
    }

    public boolean isVariableRegistered(String string) {
        if (string == null) {
            return false;
        }
        return this.variableTable.get(string) != null;
    }

    public void variableChanged(GroupVariable groupVariable, ControlElement controlElement, Value value) {
        if (groupVariable == null) {
            return;
        }
        groupVariable.setValue(value);
        groupVariable.propagateValue(controlElement, this.justCollectingData);
        groupVariable.invokeListeners(controlElement);
    }

    public void addListener(String string, String string2) {
        this.addListener(string, string2, null);
    }

    public void addListener(String string, String string2, Object object) {
        GroupVariable groupVariable;
        Object object2;
        if ((this.debugLevel & 1) > 0) {
            System.out.print(this.debugPrefix + ": Adding listener for variable <" + string + "> to <" + string2 + "> ...");
        }
        if (string == null) {
            return;
        }
        String[] stringArray = MethodWithOneParameter.splitMethodName(string2);
        if (stringArray == null) {
            System.err.println(this.getClass().getName() + " : Error! Listener <" + string2 + "> not assigned");
            return;
        }
        if (stringArray[0] == null) {
            stringArray[0] = "_default_";
        }
        if ((object2 = this.getTarget(stringArray[0])) == null) {
            System.err.println(this.getClass().getName() + " : Error! Target <" + stringArray[0] + "> not assigned");
            return;
        }
        if ((this.debugLevel & 1) > 0) {
            System.out.print(this.debugPrefix + ": Target <" + stringArray[0] + "> found. Method is <" + string2 + "> ...");
        }
        if ((groupVariable = (GroupVariable)this.variableTable.get(string)) == null) {
            groupVariable = new GroupVariable(string, this.doubleValue);
            this.variableTable.put(string, groupVariable);
            if ((this.debugLevel & 1) > 0) {
                System.out.print("   Created new variable <" + string + "> for listener <" + string2 + "> ...");
            }
        }
        if (stringArray[2] == null) {
            groupVariable.addListener(object2, stringArray[1] + "()", object);
        } else {
            groupVariable.addListener(object2, stringArray[1] + "(" + stringArray[2] + ")", object);
        }
    }

    public void rename(ControlElement controlElement, String string) {
        String string2 = controlElement.getProperty("name");
        if (string2 != null) {
            this.elementTable.remove(string2);
        }
        if (string != null) {
            this.elementTable.put(string, controlElement);
        }
    }

    public final ControlElement addNamed(String string, String string2) {
        String string3 = "name=" + string2;
        if (this.replaceOwnerName == null || !this.replaceOwnerName.equals(string2)) {
            return this.addObject(null, string, string3);
        }
        if (string.endsWith("ControlFrame") || string.endsWith("ControlDrawingFrame") || string.endsWith("ControlDrawingFrame3D")) {
            this.setOwnerFrame(this.replaceOwnerFrame);
            return this.addObject(null, "org.opensourcephysics.ejs.control.swing.ControlRootPane", string3);
        }
        return this.addObject(null, string, string3);
    }

    public final ControlElement add(String string) {
        return this.addObject(null, string, null);
    }

    public final ControlElement add(String string, String string2) {
        return this.addObject(null, string, string2);
    }

    public final ControlElement addObject(Object object, String string) {
        return this.addObject(object, string, null);
    }

    public ControlElement addObject(Class clazz, String string) {
        return null;
    }

    public ControlElement addObject(Object object, String string, String string2) {
        ControlElement controlElement = null;
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + " Adding element of type <" + string + "> with properties <" + string2 + ">");
            if (object != null) {
                System.err.println(this.getClass().getName() + " using element " + object);
            }
        }
        if (string.indexOf(".") < 0) {
            Enumeration enumeration = this.prefixList.elements();
            while (enumeration.hasMoreElements() && controlElement == null) {
                controlElement = this.instantiateClass(object, (String)enumeration.nextElement() + string, false);
            }
        }
        if (controlElement == null) {
            controlElement = this.instantiateClass(object, string, true);
        }
        if (controlElement == null) {
            return null;
        }
        if (controlElement instanceof ControlFrame) {
            this.setOwnerFrame((Frame)((ControlFrame)controlElement).getComponent());
        }
        if (controlElement instanceof ControlDialog && this.ownerFrame != null) {
            ((JDialog)((ControlDialog)controlElement).getComponent()).dispose();
            ((ControlDialog)controlElement).replaceVisual(this.ownerFrame);
        }
        controlElement.setGroup(this);
        this.elementList.add(controlElement);
        if (controlElement instanceof NeedsUpdate) {
            this.updateList.add(controlElement);
        }
        if (this.usercodebase != null) {
            controlElement.setProperty("_ejs_codebase", this.usercodebase.toString());
        }
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + " Setting properties to <" + string2 + ">");
        }
        if (string2 != null) {
            controlElement.setProperties(string2);
        }
        if (controlElement instanceof ControlWindow && controlElement.getProperty("visible") == null) {
            controlElement.setProperty("visible", "true");
        }
        return controlElement;
    }

    private ControlElement instantiateClass(Object object, String string, boolean bl) {
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + ": Trying to instantiate element of class " + string);
            if (object != null) {
                System.err.println(this.getClass().getName() + " using element " + object);
            }
        }
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Object.class};
            Object[] objectArray = new Object[]{object};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (ControlElement)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (bl) {
                exception.printStackTrace();
                return null;
            }
            try {
                Class<?> clazz = Class.forName(string);
                return (ControlElement)clazz.newInstance();
            }
            catch (Exception exception2) {
                if (bl) {
                    exception2.printStackTrace();
                }
                return null;
            }
        }
    }

    public ControlElement getElement(String string) {
        if (string == null) {
            return null;
        }
        ControlElement controlElement = (ControlElement)this.elementTable.get(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement;
    }

    public ControlElement getControl(String string) {
        return this.getElement(string);
    }

    public Component getVisual(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getVisual();
    }

    public Component getComponent(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getComponent();
    }

    public Container getContainer(String string) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement instanceof ControlContainer) {
            return ((ControlContainer)controlElement).getContainer();
        }
        return null;
    }

    public Object getObject(String string, String string2) {
        ControlElement controlElement = this.getElement(string);
        if (controlElement == null) {
            return null;
        }
        return controlElement.getObject(string2);
    }

    public Function getFunction(String string, String string2) {
        Object object = this.getObject(string, string2);
        if (object instanceof Function) {
            return (Function)object;
        }
        return null;
    }

    public void destroy(String string) {
        this.destroy(this.getElement(string), true);
    }

    public void destroy(ControlElement controlElement) {
        this.destroy(controlElement, true);
    }

    public void reset() {
        this.undoReparenting();
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).reset();
        }
    }

    public void initialize() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).initialize();
        }
    }

    public void propagateValues() {
    }

    private void doTheUpdate() {
        this.methodTriggerVariable.propagateValue(null, this.justCollectingData);
        Enumeration enumeration = this.updateList.elements();
        while (enumeration.hasMoreElements()) {
            ((NeedsUpdate)enumeration.nextElement()).update();
        }
    }

    public void update() {
        this.propagateValues();
        this.doTheUpdate();
    }

    public void collectData() {
        this.justCollectingData = true;
        this.propagateValues();
        this.doTheUpdate();
        this.justCollectingData = false;
    }

    public void resetTraces() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ControlElement controlElement = (ControlElement)enumeration.nextElement();
            if (!(controlElement instanceof Resetable)) continue;
            controlElement.reset();
        }
    }

    public void setUserCodebase(URL uRL) {
        this.usercodebase = uRL;
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).setProperty("_ejs_codebase", uRL.toString());
        }
    }

    public URL getUserCodebase() {
        return this.usercodebase;
    }

    public void flush() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).flush();
        }
    }

    public void setActive(boolean bl) {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).setActive(bl);
        }
    }

    public void onExit() {
        Enumeration enumeration = this.elementList.elements();
        while (enumeration.hasMoreElements()) {
            ((ControlElement)enumeration.nextElement()).onExit();
        }
    }

    public void clearVariables() {
        this.variableTable.clear();
    }

    public void clearModelVariables() {
        Hashtable<String, GroupVariable> hashtable = new Hashtable<String, GroupVariable>();
        Enumeration enumeration = this.variableTable.elements();
        while (enumeration.hasMoreElements()) {
            GroupVariable groupVariable = (GroupVariable)enumeration.nextElement();
            if (!groupVariable.isDefinedInModel()) {
                hashtable.put(groupVariable.getName(), groupVariable);
                continue;
            }
            if (!groupVariable.hasElementsRegistered()) continue;
            groupVariable.setValueObsolete(true);
            hashtable.put(groupVariable.getName(), groupVariable);
        }
        this.variableTable = hashtable;
    }

    public Set getVariablesSet() {
        return this.variableTable.keySet();
    }

    public void clear() {
        ControlElement controlElement2;
        this.variableTable.clear();
        ArrayList<ControlElement> arrayList = new ArrayList<ControlElement>();
        ArrayList<ControlElement> arrayList2 = new ArrayList<ControlElement>();
        Object object = this.elementList.elements();
        while (object.hasMoreElements()) {
            controlElement2 = (ControlElement)object.nextElement();
            String string = controlElement2.getProperty("parent");
            if (string != null) continue;
            if (controlElement2 instanceof ControlDialog) {
                arrayList.add(controlElement2);
                continue;
            }
            arrayList2.add(controlElement2);
        }
        for (ControlElement controlElement2 : arrayList) {
            this.destroy(controlElement2, false);
        }
        for (ControlElement controlElement2 : arrayList2) {
            this.destroy(controlElement2, false);
        }
        if ((this.debugLevel & 2) > 0) {
            System.err.println(this.getClass().getName() + " Warning!: All element were destroyed!");
            System.err.println("  List of remaining elements follows: ");
            object = this.elementList.elements();
            while (object.hasMoreElements()) {
                controlElement2 = (ControlElement)object.nextElement();
                System.err.println("    " + controlElement2.toString() + "(class is " + controlElement2.getClass().getName() + ")");
            }
        }
        this.setOwnerFrame(null);
    }

    private void destroy(ControlElement controlElement, boolean bl) {
        Object object;
        Object object2;
        if (controlElement == null) {
            return;
        }
        if (bl) {
            object2 = this.getElement(controlElement.getProperty("parent"));
            if (object2 != null) {
                if (object2 instanceof ControlContainer) {
                    ((ControlContainer)object2).remove(controlElement);
                }
            } else {
                object = controlElement.getComponent().getParent();
                if (object != null) {
                    ((Container)object).remove(controlElement.getComponent());
                    ((Container)object).validate();
                    ((Component)object).repaint();
                }
            }
        }
        controlElement.variablePropertiesClear();
        object2 = controlElement.getProperty("name");
        if (object2 != null) {
            this.elementTable.remove(object2);
        }
        this.elementList.remove(controlElement);
        if (controlElement instanceof NeedsUpdate) {
            this.updateList.remove(controlElement);
        }
        if (controlElement instanceof ControlContainer) {
            object = ((ControlContainer)controlElement).getChildren().elements();
            while (object.hasMoreElements()) {
                ControlElement controlElement2 = (ControlElement)object.nextElement();
                this.destroy(controlElement2, false);
            }
        }
        if (controlElement instanceof ControlWindow) {
            ((ControlWindow)controlElement).dispose();
        }
    }

    public Container getTopLevelAncestor(String string) {
        if (string != null) {
            ControlElement controlElement = this.getElement(string);
            Component component = controlElement.getComponent();
            if (component instanceof JComponent) {
                return ((JComponent)component).getTopLevelAncestor();
            }
        } else {
            Enumeration enumeration = this.elementList.elements();
            while (enumeration.hasMoreElements()) {
                ControlElement controlElement = (ControlElement)enumeration.nextElement();
                Component component = controlElement.getComponent();
                if (!(component instanceof Window)) continue;
                return (Window)component;
            }
        }
        return null;
    }

    public void setValue(String string, boolean bl) {
        this.booleanValue.value = bl;
        this.setValue(string, this.booleanValue);
    }

    public void setValue(String string, int n) {
        this.integerValue.value = n;
        this.setValue(string, this.integerValue);
    }

    public void setValue(String string, double d) {
        this.doubleValue.value = d;
        this.setValue(string, this.doubleValue);
    }

    public void setValue(String string, String string2) {
        this.stringValue.value = string2;
        this.setValue(string, this.stringValue);
    }

    public void setValue(String string, Object object) {
        if (object instanceof String) {
            this.setValue(string, (String)object);
        } else {
            this.objectValue.value = object;
            this.setValue(string, this.objectValue);
        }
    }

    public boolean getBoolean(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return false;
        }
        return value.getBoolean();
    }

    public int getInt(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return 0;
        }
        return value.getInteger();
    }

    public double getDouble(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return 0.0;
        }
        return value.getDouble();
    }

    public String getString(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return "";
        }
        return value.getString();
    }

    public Object getObject(String string) {
        Value value = this.getValue(string);
        if (value == null) {
            return null;
        }
        return value.getObject();
    }

    static {
        ResourceLoader.setCacheEnabled(true);
    }
}

