/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Color;
import java.awt.Frame;
import java.util.Collection;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ParsableTextArea;
import org.opensourcephysics.controls.VariableNotFoundException;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.GroupControl;
import org.opensourcephysics.ejs.control.swing.ControlInputArea;
import org.opensourcephysics.ejs.control.swing.ControlTextArea;
import org.opensourcephysics.ejs.control.value.StringValue;
import org.opensourcephysics.ejs.control.value.Value;

public class EjsControl
extends GroupControl
implements Control {
    static String _RETURN_ = "\n";
    private ControlTextArea messageArea = null;
    private ParsableTextArea inputArea = null;
    private StringValue strValue = new StringValue("");
    private static Color[] colorTable;

    public EjsControl(Object object) {
        super(object);
    }

    public EjsControl(Object object, String string, Frame frame) {
        super(object, string, frame);
    }

    public EjsControl() {
    }

    public ControlElement addObject(Object object, String string, String string2) {
        ControlElement controlElement = super.addObject(object, string, string2);
        if (controlElement instanceof ControlTextArea) {
            this.messageArea = (ControlTextArea)controlElement;
        } else if (controlElement instanceof ControlInputArea) {
            this.inputArea = (ParsableTextArea)((ControlInputArea)controlElement).getVisual();
        }
        return controlElement;
    }

    public void reset() {
        this.clearValues();
        this.clearMessages();
        super.reset();
    }

    public Color[] getPhaseColorTable() {
        if (colorTable == null) {
            colorTable = new Color[256];
            for (int i = 0; i < 256; ++i) {
                double d = Math.abs(Math.sin(Math.PI * (double)i / 255.0));
                int n = (int)(255.0 * d * d);
                d = Math.abs(Math.sin(Math.PI * (double)i / 255.0 + 1.0471975511965976));
                int n2 = (int)(255.0 * d * d * Math.sqrt(d));
                d = Math.abs(Math.sin(Math.PI * (double)i / 255.0 + 2.0943951023931953));
                int n3 = (int)(255.0 * d * d);
                EjsControl.colorTable[i] = new Color(n3, n2, n);
            }
        }
        return colorTable;
    }

    public Color phaseToColor(double d) {
        int n = (int)(127.5 * (1.0 + d / Math.PI));
        return this.getPhaseColorTable()[n %= 255];
    }

    public void setLockValues(boolean bl) {
    }

    public Collection getPropertyNames() {
        return this.variableTable.keySet();
    }

    public void clearValues() {
        if (this.inputArea != null) {
            this.inputArea.setText("");
            this.inputArea.setCaretPosition(this.inputArea.getText().length());
        }
    }

    public void clearMessages() {
        if (this.messageArea != null) {
            this.messageArea.clear();
        }
    }

    public void println(String string) {
        this.print(string + _RETURN_);
    }

    public void println() {
        this.println("");
    }

    public void print(String string) {
        if (this.messageArea != null) {
            this.messageArea.print(string);
        } else {
            System.out.print(string);
        }
    }

    public void calculationDone(String string) {
        this.println(string);
    }

    public void setValue(String string, Value value) {
        if (!this.isVariableRegistered(string) && this.inputArea != null) {
            this.inputArea.setValue(string, value.getString());
        } else {
            super.setValue(string, value);
        }
    }

    public Value getValue(String string) {
        if (!this.isVariableRegistered(string) && this.inputArea != null) {
            try {
                this.strValue.value = this.inputArea.getValue(string);
                return this.strValue;
            }
            catch (VariableNotFoundException variableNotFoundException) {
                // empty catch block
            }
        }
        return super.getValue(string);
    }

    static {
        try {
            _RETURN_ = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            _RETURN_ = "\n";
        }
        colorTable = null;
    }
}

