/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.opensourcephysics.ejs.Memory;

public class Input
extends Memory {
    public static final int CONFIRM = 0;
    public static final int YES_NO = 1;
    public static final int YES_NO_CANCEL = 2;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int CLOSED = -1;
    public static final int OK = 0;
    private boolean ok = true;

    public boolean inputVariables(String string, String string2) {
        String[] stringArray = string2.split(",");
        int n = stringArray.length;
        Object[] objectArray = new String[]{Input.getResource("Experiment.InputDialog.Variable"), Input.getResource("Experiment.InputDialog.Value")};
        Object[][] objectArray2 = new Object[n][2];
        for (int i = 0; i < n; ++i) {
            objectArray2[i][0] = stringArray[i];
            objectArray2[i][1] = this.hashTable.get(stringArray[i]);
        }
        JTable jTable = new JTable(objectArray2, objectArray);
        jTable.setPreferredScrollableViewportSize(new Dimension(400, 16 * n));
        jTable.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JScrollPane jScrollPane = new JScrollPane(jTable);
        final JDialog jDialog = new JDialog((Frame)null, string, true);
        JButton jButton = new JButton(Input.getResource("Ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Input.this.ok = true;
                jDialog.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(Input.getResource("Cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Input.this.ok = false;
                jDialog.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jDialog.getContentPane().add((Component)jScrollPane, "North");
        jDialog.getContentPane().add((Component)jPanel, "Center");
        jDialog.pack();
        this.ok = false;
        jDialog.setVisible(true);
        if (this.ok) {
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                Object object = jTable.getValueAt(i, 1);
                if (object == null) continue;
                this.readInput((String)jTable.getValueAt(i, 0), object.toString());
            }
        }
        jDialog.dispose();
        return this.ok;
    }

    public void readInput(String string, String string2) {
        if (string2.equals("true")) {
            this.setValue(string, true);
            return;
        }
        if (string2.equals("false")) {
            this.setValue(string, false);
            return;
        }
        try {
            Integer n = new Integer(string2);
            this.setValue(string, n);
            return;
        }
        catch (Exception exception) {
            try {
                Double d = new Double(string2);
                this.setValue(string, d);
                return;
            }
            catch (Exception exception2) {
                this.setValue(string, string2);
                return;
            }
        }
    }

    public int confirmMessage(String string, int n) {
        switch (n) {
            case 1: {
                return JOptionPane.showConfirmDialog(null, string, Input.getResource("Experiment.Title"), 0);
            }
            case 2: {
                return JOptionPane.showConfirmDialog(null, string, Input.getResource("Experiment.Title"), 1);
            }
        }
        JOptionPane.showMessageDialog(null, string, Input.getResource("Experiment.Title"), 1);
        return 0;
    }

    public int selectOption(String string, String string2) {
        Object[] objectArray = string2.split(",");
        String string3 = (String)JOptionPane.showInputDialog(null, string, Input.getResource("Experiment.Title"), 1, null, objectArray, objectArray[0]);
        int n = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (!((String)objectArray[n]).equals(string3)) continue;
            return n;
        }
        return -1;
    }
}

