/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class VectorField3D
extends ElementSet {
    protected int levels = 0;
    protected int invisibleLevel = -1;
    protected boolean autoscaleMagnitude = false;
    protected double minMagnitude = -1.0;
    protected double maxMagnitude = 1.0;
    protected Color maxColor = null;
    protected Color minColor = null;
    protected boolean visibility = true;
    protected boolean hasData = false;
    protected double[][][] data2D = null;
    protected double[][][][] data3D = null;
    protected double zoom = 1.0;
    protected double magConstant = 0.0;
    protected double[] magnitude = new double[]{0.0};
    protected Color[] colors = null;

    public VectorField3D() {
        super(1, InteractiveArrow.class);
        this.maxColor = Color.red;
        this.minColor = Color.blue;
        this.setNumberOfLevels(16);
        this.setAutoscaleMagnitude(true);
    }

    public void setVisible(boolean bl) {
        this.visibility = bl;
    }

    public void setNumberOfLevels(int n) {
        if (n <= 0) {
            this.levels = 0;
            return;
        }
        if (n != this.levels) {
            this.levels = n;
            this.colors = new Color[this.levels];
            this.initColors();
            this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
            this.setInvisibleLevel(this.invisibleLevel);
        }
    }

    public void setMinColor(Color color) {
        if (!color.equals(this.minColor)) {
            this.minColor = color;
            this.initColors();
        }
    }

    public void setMaxColor(Color color) {
        if (!color.equals(this.maxColor)) {
            this.maxColor = color;
            this.initColors();
        }
    }

    public void setInvisibleLevel(int n) {
        this.invisibleLevel = n;
    }

    public void setZoom(double d) {
        block6: {
            block5: {
                this.zoom = d;
                if (this.data2D == null) break block5;
                int n = 0;
                int n2 = this.data2D.length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = 0;
                    int n4 = this.data2D[0].length;
                    while (n3 < n4) {
                        InteractiveElement interactiveElement = this.elementAt(n);
                        interactiveElement.setSizeX(this.data2D[i][n3][2] * this.zoom);
                        interactiveElement.setSizeY(this.data2D[i][n3][3] * this.zoom);
                        ++n3;
                        ++n;
                    }
                }
                break block6;
            }
            if (this.data3D == null) break block6;
            int n = 0;
            int n5 = this.data3D.length;
            for (int i = 0; i < n5; ++i) {
                int n6 = this.data3D[0].length;
                for (int j = 0; j < n6; ++j) {
                    int n7 = 0;
                    int n8 = this.data3D[0][0].length;
                    while (n7 < n8) {
                        InteractiveElement interactiveElement = this.elementAt(n);
                        interactiveElement.setSizeX(this.data3D[i][j][n7][3] * this.zoom);
                        interactiveElement.setSizeY(this.data3D[i][j][n7][4] * this.zoom);
                        interactiveElement.setSizeZ(this.data3D[i][j][n7][5] * this.zoom);
                        ++n7;
                        ++n;
                    }
                }
            }
        }
    }

    public void setAutoscaleMagnitude(boolean bl) {
        this.autoscaleMagnitude = bl;
        if (this.autoscaleMagnitude) {
            this.computeMagnitudeExtrema();
        }
    }

    public void setColorExtrema(double d, double d2) {
        this.autoscaleMagnitude = false;
        this.minMagnitude = d;
        this.maxMagnitude = d2;
        if (this.maxMagnitude == this.minMagnitude) {
            this.maxMagnitude = this.minMagnitude + 1.0;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
    }

    public void setDataArray(double[][][][] dArray) {
        if (dArray == null) {
            this.hasData = false;
            return;
        }
        this.data3D = dArray;
        this.data2D = null;
        this.hasData = true;
        int n = this.data3D.length * this.data3D[0].length * this.data3D[0][0].length;
        if (this.getNumberOfElements() != n) {
            this.magnitude = new double[n];
            this.setNumberOfElements(n);
        }
        int n2 = 0;
        int n3 = this.data3D.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.data3D[0].length;
            for (int j = 0; j < n4; ++j) {
                int n5 = 0;
                int n6 = this.data3D[0][0].length;
                while (n5 < n6) {
                    InteractiveElement interactiveElement = this.elementAt(n2);
                    interactiveElement.setX(dArray[i][j][n5][0]);
                    interactiveElement.setY(dArray[i][j][n5][1]);
                    interactiveElement.setZ(dArray[i][j][n5][2]);
                    interactiveElement.setSizeX(dArray[i][j][n5][3] * this.zoom);
                    interactiveElement.setSizeY(dArray[i][j][n5][4] * this.zoom);
                    interactiveElement.setSizeZ(dArray[i][j][n5][5] * this.zoom);
                    this.magnitude[n2] = dArray[i][j][n5][6];
                    ++n5;
                    ++n2;
                }
            }
        }
        if (this.autoscaleMagnitude) {
            this.computeMagnitudeExtrema();
        }
    }

    public void setDataArray(double[][][] dArray) {
        if (dArray == null) {
            this.hasData = false;
            return;
        }
        this.data2D = dArray;
        this.data3D = null;
        this.hasData = true;
        int n = this.data2D.length * this.data2D[0].length;
        if (this.getNumberOfElements() != n) {
            this.magnitude = new double[n];
            this.setNumberOfElements(n);
            this.setZoom(this.zoom);
        }
        int n2 = 0;
        int n3 = this.data2D.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            int n5 = this.data2D[0].length;
            while (n4 < n5) {
                InteractiveElement interactiveElement = this.elementAt(n2);
                interactiveElement.setX(this.data2D[i][n4][0]);
                interactiveElement.setY(this.data2D[i][n4][1]);
                interactiveElement.setSizeX(this.data2D[i][n4][2] * this.zoom);
                interactiveElement.setSizeY(this.data2D[i][n4][3] * this.zoom);
                this.magnitude[n2] = this.data2D[i][n4][4];
                ++n4;
                ++n2;
            }
        }
        if (this.autoscaleMagnitude) {
            this.computeMagnitudeExtrema();
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visibility || !this.hasData) {
            return null;
        }
        this.list3D.clear();
        int n = this.getNumberOfElements();
        for (int i = 0; i < n; ++i) {
            Object3D[] object3DArray;
            InteractiveElement interactiveElement = this.elementAt(i);
            this.elementAt(i).setVisible(true);
            if (this.levels > 0) {
                object3DArray = this.magToColor(this.magnitude[i]);
                if (object3DArray == null) continue;
                interactiveElement.getStyle().setEdgeColor((Color)object3DArray);
                interactiveElement.getStyle().setFillPattern((Paint)object3DArray);
            } else {
                interactiveElement.getStyle().setEdgeColor(this.minColor);
                interactiveElement.getStyle().setFillPattern(this.minColor);
            }
            object3DArray = interactiveElement.getObjects3D(drawingPanel3D);
            if (object3DArray == null) continue;
            for (int j = 0; j < object3DArray.length; ++j) {
                this.list3D.add(object3DArray[j]);
            }
        }
        if (this.list3D.size() == 0) {
            return null;
        }
        return this.list3D.toArray(this.minimalObjects);
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (!this.visibility || !this.hasData) {
            return;
        }
        if (this.levels > 0) {
            int n = this.getNumberOfElements();
            for (int i = 0; i < n; ++i) {
                Color color = this.magToColor(this.magnitude[i]);
                if (color == null) {
                    this.elementAt(i).setVisible(false);
                    continue;
                }
                this.elementAt(i).setVisible(true);
                this.elementAt(i).getStyle().setEdgeColor(color);
                this.elementAt(i).getStyle().setFillPattern(color);
            }
        } else {
            int n = this.getNumberOfElements();
            for (int i = 0; i < n; ++i) {
                this.elementAt(i).setVisible(true);
                this.elementAt(i).getStyle().setEdgeColor(this.minColor);
                this.elementAt(i).getStyle().setFillPattern(this.minColor);
            }
        }
        super.drawQuickly(drawingPanel3D, graphics2D);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visibility || !this.hasData) {
            return;
        }
        if (this.levels > 0) {
            int n = this.getNumberOfElements();
            for (int i = 0; i < n; ++i) {
                Color color = this.magToColor(this.magnitude[i]);
                if (color == null) {
                    this.elementAt(i).setVisible(false);
                    continue;
                }
                this.elementAt(i).setVisible(true);
                this.elementAt(i).getStyle().setEdgeColor(color);
                this.elementAt(i).getStyle().setFillPattern(color);
            }
        } else {
            int n = this.getNumberOfElements();
            for (int i = 0; i < n; ++i) {
                this.elementAt(i).setVisible(true);
                this.elementAt(i).getStyle().setEdgeColor(this.minColor);
                this.elementAt(i).getStyle().setFillPattern(this.minColor);
            }
        }
        super.draw(drawingPanel, graphics);
    }

    protected void initColors() {
        int n = this.minColor.getRed();
        int n2 = this.minColor.getGreen();
        int n3 = this.minColor.getBlue();
        int n4 = this.maxColor.getRed();
        int n5 = this.maxColor.getGreen();
        int n6 = this.maxColor.getBlue();
        for (int i = 0; i < this.levels; ++i) {
            int n7 = (int)((float)n + (float)((n4 - n) * i) * 1.0f / (float)(this.levels - 1));
            int n8 = (int)((float)n2 + (float)((n5 - n2) * i) * 1.0f / (float)(this.levels - 1));
            int n9 = (int)((float)n3 + (float)((n6 - n3) * i) * 1.0f / (float)(this.levels - 1));
            this.colors[i] = new Color(n7, n8, n9);
        }
    }

    protected void computeMagnitudeExtrema() {
        double[] dArray = this.magnitude;
        if (dArray == null) {
            return;
        }
        this.minMagnitude = dArray[0];
        this.maxMagnitude = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (d > this.maxMagnitude) {
                this.maxMagnitude = d;
            }
            if (!(d < this.minMagnitude)) continue;
            this.minMagnitude = d;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
    }

    protected Color magToColor(double d) {
        int n = (int)(this.magConstant * (d - this.minMagnitude));
        if (n <= this.invisibleLevel) {
            return null;
        }
        if (n <= 0) {
            return this.colors[0];
        }
        if (n >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[n];
    }
}

