/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.displayejs.InteractiveCylinder;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Resolution;

public class InteractiveSphere
extends InteractiveCylinder {
    protected int minanglev = -90;
    protected int maxanglev = 90;
    protected double[] cosv = null;
    protected double[] sinv = null;
    protected double[] nextCenter = new double[]{0.0, 0.0, 0.0};

    public InteractiveSphere() {
        this(2);
    }

    public InteractiveSphere(int n) {
        super(n);
        this.setSizeXYZ(0.2, 0.2, 0.2);
        this.setResolution(new Resolution(3, 12, 12));
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveCylinder) {
            InteractiveSphere interactiveSphere = (InteractiveSphere)interactiveElement;
            this.setMinAngleV(interactiveSphere.getMinAngleV());
            this.setMaxAngleV(interactiveSphere.getMaxAngleV());
        }
    }

    public void setMinAngleV(int n) {
        this.minanglev = n;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public int getMinAngleV() {
        return this.minanglev;
    }

    public void setMaxAngleV(int n) {
        this.maxanglev = n;
        this.hasChanged = true;
        this.changeNTiles = true;
    }

    public int getMaxAngleV() {
        return this.maxanglev;
    }

    protected void computeAbsoluteDifference(double[] dArray) {
        double d = (this.originx - 0.5) * this.sizex;
        double d2 = (this.originy - 0.5) * this.sizey;
        double d3 = (this.originz - 0.5) * this.sizez;
        dArray[0] = d * this.vectorx[0] + d2 * this.vectory[0] + d3 * this.vectorz[0];
        dArray[1] = d * this.vectorx[1] + d2 * this.vectory[1] + d3 * this.vectorz[1];
        dArray[2] = d * this.vectorx[2] + d2 * this.vectory[2] + d3 * this.vectorz[2];
    }

    protected synchronized void computeCorners() {
        int n;
        int n2;
        int n3;
        int n4;
        double d;
        int n5;
        double d2;
        double d3;
        double d4 = this.sizex / 2.0;
        double d5 = this.sizey / 2.0;
        double d6 = this.sizez / 2.0;
        double d7 = this.maxangleu;
        double d8 = this.minangleu;
        if (Math.abs(d7 - d8) > 360.0) {
            d7 = d8 + 360.0;
        }
        if (Math.abs((d3 = (double)this.maxanglev) - (d2 = (double)this.minanglev)) > 180.0) {
            d3 = d2 + 180.0;
        }
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 0: {
                    n6 = Math.max(this.resolution.n1, 1);
                    n7 = Math.max(this.resolution.n2, 1);
                    n8 = Math.max(this.resolution.n3, 1);
                    break;
                }
                case 1: {
                    n6 = Math.max((int)Math.round(0.49 + Math.max(Math.abs(d4), Math.abs(d5)) / this.resolution.maxLength), 1);
                    n7 = Math.max((int)Math.round(0.49 + Math.abs(d7 - d8) * (Math.PI / 180) * (Math.abs(d4) + Math.abs(d5)) / this.resolution.maxLength), 1);
                    n8 = Math.max((int)Math.round(0.49 + Math.abs(Math.PI / 180 * (d3 - d2) * d6) / this.resolution.maxLength), 1);
                }
            }
        }
        if (this.nr != n6 || this.nu != n7 || this.nz != n8 || this.changeNTiles) {
            this.nr = n6;
            this.nu = n7;
            this.nz = n8;
            this.cosu = new double[this.nu + 1];
            this.sinu = new double[this.nu + 1];
            this.cosv = new double[this.nz + 1];
            this.sinv = new double[this.nz + 1];
            n5 = this.nu * this.nz;
            if (Math.abs(d3 - d2) < 180.0) {
                if (this.closedBottom) {
                    n5 += this.nr * this.nu;
                }
                if (this.closedTop) {
                    n5 += this.nr * this.nu;
                }
            }
            if (Math.abs(d7 - d8) < 360.0) {
                if (this.closedLeft) {
                    n5 += this.nr * this.nz;
                }
                if (this.closedRight) {
                    n5 += this.nr * this.nz;
                }
            }
            this.changeNTiles = false;
            this.setCorners(new double[n5][4][3]);
        }
        for (n5 = 0; n5 <= this.nu; ++n5) {
            d = ((double)(this.nu - n5) * d8 + (double)n5 * d7) * (Math.PI / 180) / (double)this.nu;
            this.cosu[n5] = Math.cos(d) * d4;
            this.sinu[n5] = Math.sin(d) * d5;
        }
        for (n5 = 0; n5 <= this.nz; ++n5) {
            d = ((double)(this.nz - n5) * d2 + (double)n5 * d3) * (Math.PI / 180) / (double)this.nz;
            this.cosv[n5] = Math.cos(d);
            this.sinv[n5] = Math.sin(d) * d6;
        }
        n5 = 0;
        this.center[0] = this.x;
        this.center[1] = this.y;
        this.center[2] = this.z;
        for (n4 = 0; n4 < this.nz; ++n4) {
            n3 = 0;
            while (n3 < this.nu) {
                for (n2 = 0; n2 < 3; ++n2) {
                    this.corners[n5][0][n2] = this.center[n2] + (this.cosu[n3] * this.vectorx[n2] + this.sinu[n3] * this.vectory[n2]) * this.cosv[n4] + this.sinv[n4] * this.vectorz[n2];
                    this.corners[n5][1][n2] = this.center[n2] + (this.cosu[n3 + 1] * this.vectorx[n2] + this.sinu[n3 + 1] * this.vectory[n2]) * this.cosv[n4] + this.sinv[n4] * this.vectorz[n2];
                    this.corners[n5][2][n2] = this.center[n2] + (this.cosu[n3 + 1] * this.vectorx[n2] + this.sinu[n3 + 1] * this.vectory[n2]) * this.cosv[n4 + 1] + this.sinv[n4 + 1] * this.vectorz[n2];
                    this.corners[n5][3][n2] = this.center[n2] + (this.cosu[n3] * this.vectorx[n2] + this.sinu[n3] * this.vectory[n2]) * this.cosv[n4 + 1] + this.sinv[n4 + 1] * this.vectorz[n2];
                }
                ++n3;
                ++n5;
            }
        }
        if (Math.abs(d3 - d2) < 180.0) {
            if (this.closedBottom) {
                this.center[0] = this.x + this.sinv[0] * this.vectorz[0];
                this.center[1] = this.y + this.sinv[0] * this.vectorz[1];
                this.center[2] = this.z + this.sinv[0] * this.vectorz[2];
                n4 = 0;
                for (n3 = 0; n3 < this.nu; ++n3) {
                    n2 = 0;
                    while (n2 < this.nr) {
                        for (n = 0; n < 3; ++n) {
                            this.corners[n5][0][n] = ((double)(this.nr - n2) * this.center[n] + (double)n2 * this.corners[n3][0][n]) / (double)this.nr;
                            this.corners[n5][1][n] = ((double)(this.nr - n2 - 1) * this.center[n] + (double)(n2 + 1) * this.corners[n3][0][n]) / (double)this.nr;
                            this.corners[n5][2][n] = ((double)(this.nr - n2 - 1) * this.center[n] + (double)(n2 + 1) * this.corners[n3][1][n]) / (double)this.nr;
                            this.corners[n5][3][n] = ((double)(this.nr - n2) * this.center[n] + (double)n2 * this.corners[n3][1][n]) / (double)this.nr;
                        }
                        ++n2;
                        ++n5;
                    }
                }
            }
            if (this.closedTop) {
                n4 = this.nu * (this.nz - 1);
                this.center[0] = this.x + this.sinv[this.nz] * this.vectorz[0];
                this.center[1] = this.y + this.sinv[this.nz] * this.vectorz[1];
                this.center[2] = this.z + this.sinv[this.nz] * this.vectorz[2];
                for (n3 = 0; n3 < this.nu; ++n3) {
                    n2 = 0;
                    while (n2 < this.nr) {
                        for (n = 0; n < 3; ++n) {
                            this.corners[n5][0][n] = ((double)(this.nr - n2) * this.center[n] + (double)n2 * this.corners[n4 + n3][3][n]) / (double)this.nr;
                            this.corners[n5][1][n] = ((double)(this.nr - n2 - 1) * this.center[n] + (double)(n2 + 1) * this.corners[n4 + n3][3][n]) / (double)this.nr;
                            this.corners[n5][2][n] = ((double)(this.nr - n2 - 1) * this.center[n] + (double)(n2 + 1) * this.corners[n4 + n3][2][n]) / (double)this.nr;
                            this.corners[n5][3][n] = ((double)(this.nr - n2) * this.center[n] + (double)n2 * this.corners[n4 + n3][2][n]) / (double)this.nr;
                        }
                        ++n2;
                        ++n5;
                    }
                }
            }
        }
        if (Math.abs(d7 - d8) < 360.0) {
            if (this.closedRight) {
                n4 = 0;
                n3 = 0;
                while (n3 < this.nz) {
                    this.center[0] = this.x + this.sinv[n3] * this.vectorz[0];
                    this.center[1] = this.y + this.sinv[n3] * this.vectorz[1];
                    this.center[2] = this.z + this.sinv[n3] * this.vectorz[2];
                    this.nextCenter[0] = this.x + this.sinv[n3 + 1] * this.vectorz[0];
                    this.nextCenter[1] = this.y + this.sinv[n3 + 1] * this.vectorz[1];
                    this.nextCenter[2] = this.z + this.sinv[n3 + 1] * this.vectorz[2];
                    n2 = 0;
                    while (n2 < this.nr) {
                        for (n = 0; n < 3; ++n) {
                            this.corners[n5][0][n] = ((double)(this.nr - n2) * this.center[n] + (double)n2 * this.corners[n4][0][n]) / (double)this.nr;
                            this.corners[n5][1][n] = ((double)(this.nr - n2 - 1) * this.center[n] + (double)(n2 + 1) * this.corners[n4][0][n]) / (double)this.nr;
                            this.corners[n5][2][n] = ((double)(this.nr - n2 - 1) * this.nextCenter[n] + (double)(n2 + 1) * this.corners[n4][3][n]) / (double)this.nr;
                            this.corners[n5][3][n] = ((double)(this.nr - n2) * this.nextCenter[n] + (double)n2 * this.corners[n4][3][n]) / (double)this.nr;
                        }
                        ++n2;
                        ++n5;
                    }
                    ++n3;
                    n4 += this.nu;
                }
            }
            if (this.closedLeft) {
                n4 = this.nu - 1;
                n3 = 0;
                while (n3 < this.nz) {
                    this.center[0] = this.x + this.sinv[n3] * this.vectorz[0];
                    this.center[1] = this.y + this.sinv[n3] * this.vectorz[1];
                    this.center[2] = this.z + this.sinv[n3] * this.vectorz[2];
                    this.nextCenter[0] = this.x + this.sinv[n3 + 1] * this.vectorz[0];
                    this.nextCenter[1] = this.y + this.sinv[n3 + 1] * this.vectorz[1];
                    this.nextCenter[2] = this.z + this.sinv[n3 + 1] * this.vectorz[2];
                    n2 = 0;
                    while (n2 < this.nr) {
                        for (n = 0; n < 3; ++n) {
                            this.corners[n5][0][n] = ((double)(this.nr - n2) * this.center[n] + (double)n2 * this.corners[n4][1][n]) / (double)this.nr;
                            this.corners[n5][1][n] = ((double)(this.nr - n2 - 1) * this.center[n] + (double)(n2 + 1) * this.corners[n4][1][n]) / (double)this.nr;
                            this.corners[n5][2][n] = ((double)(this.nr - n2 - 1) * this.nextCenter[n] + (double)(n2 + 1) * this.corners[n4][2][n]) / (double)this.nr;
                            this.corners[n5][3][n] = ((double)(this.nr - n2) * this.nextCenter[n] + (double)n2 * this.corners[n4][2][n]) / (double)this.nr;
                        }
                        ++n2;
                        ++n5;
                    }
                    ++n3;
                    n4 += this.nu;
                }
            }
        }
        this.transformCorners();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }
}

