/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetCursorPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class InteractiveCursor
extends AbstractInteractiveElement {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int CROSSHAIR = 2;
    private int type = 2;
    private int a1 = 0;
    private int b1 = 0;
    private int x1 = 0;
    private int x2 = 0;
    private int y1 = 0;
    private int y2 = 0;
    private double[] coordinates = new double[3];
    private double[] pixelOrigin = new double[3];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};

    public InteractiveCursor() {
        this(2);
    }

    public InteractiveCursor(int n) {
        this.setType(n);
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveCursor) {
            this.setType(((InteractiveCursor)interactiveElement).type);
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.positionEnabled) {
            double d = this.pixelOrigin[0] - (double)n;
            double d2 = this.pixelOrigin[1] - (double)n2;
            switch (this.type) {
                case 1: {
                    if (Math.abs(this.pixelOrigin[0] - (double)n) < (double)this.actualSensitivity) {
                        return new InteractionTargetCursorPosition(this, 0);
                    }
                }
                case 0: {
                    if (!(Math.abs(this.pixelOrigin[1] - (double)n2) < (double)this.actualSensitivity)) break;
                    return new InteractionTargetCursorPosition(this, 1);
                }
            }
            if (Math.abs(this.pixelOrigin[0] - (double)n) < (double)this.actualSensitivity) {
                if (Math.abs(this.pixelOrigin[1] - (double)n2) < (double)this.actualSensitivity) {
                    return new InteractionTargetCursorPosition(this, 2);
                }
                return new InteractionTargetCursorPosition(this, 0);
            }
            if (Math.abs(this.pixelOrigin[1] - (double)n2) < (double)this.actualSensitivity) {
                return new InteractionTargetCursorPosition(this, 1);
            }
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        Color color = drawingPanel3D.projectColor(this.style.edgeColor, this.objects[0].distance);
        this.drawIt(graphics2D, color);
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        this.drawIt(graphics2D, this.style.edgeColor);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.projectPoints(drawingPanel);
        this.drawIt((Graphics2D)graphics, this.style.edgeColor);
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        if (!(drawingPanel instanceof DrawingPanel3D)) {
            this.coordinates[0] = drawingPanel.getXMin();
            this.coordinates[1] = drawingPanel.getYMin();
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.x1 = (int)this.pixelOrigin[0];
            this.y1 = (int)this.pixelOrigin[1];
            this.coordinates[0] = drawingPanel.getXMax();
            this.coordinates[1] = drawingPanel.getYMax();
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.x2 = (int)this.pixelOrigin[0];
            this.y2 = (int)this.pixelOrigin[1];
        }
        if (this.group != null) {
            this.coordinates[0] = this.group.x + this.x * this.group.sizex;
            this.coordinates[1] = this.group.y + this.y * this.group.sizey;
            this.coordinates[2] = this.group.z + this.z * this.group.sizez;
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
        }
        drawingPanel.project(this.coordinates, this.pixelOrigin);
        this.objects[0].distance = this.pixelOrigin[2];
        this.a1 = (int)this.pixelOrigin[0];
        this.b1 = (int)this.pixelOrigin[1];
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
    }

    private void drawIt(Graphics2D graphics2D, Color color) {
        graphics2D.setColor(color);
        graphics2D.setStroke(this.style.edgeStroke);
        switch (this.type) {
            case 0: {
                graphics2D.drawLine(this.x1, this.b1, this.x2, this.b1);
                break;
            }
            case 1: {
                graphics2D.drawLine(this.a1, this.y1, this.a1, this.y2);
                break;
            }
            default: {
                graphics2D.drawLine(this.x1, this.b1, this.x2, this.b1);
                graphics2D.drawLine(this.a1, this.y1, this.a1, this.y2);
            }
        }
    }

    public boolean isMeasured() {
        return this.canBeMeasured && this.visible;
    }

    public double getXMin() {
        if (this.group == null) {
            return this.x;
        }
        return this.group.x + this.x;
    }

    public double getXMax() {
        if (this.group == null) {
            return this.x;
        }
        return this.group.x + this.x;
    }

    public double getYMin() {
        if (this.group == null) {
            return this.y;
        }
        return this.group.y + this.y;
    }

    public double getYMax() {
        if (this.group == null) {
            return this.y;
        }
        return this.group.y + this.y;
    }

    public double getZMin() {
        if (this.group == null) {
            return this.z;
        }
        return this.group.z + this.z;
    }

    public double getZMax() {
        if (this.group == null) {
            return this.z;
        }
        return this.group.z + this.z;
    }
}

