/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Body;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.numerics.Transformation;

public class InteractiveArrow
extends AbstractInteractiveElement
implements Body {
    public static final int ARROW = 0;
    public static final int SEGMENT = 1;
    public static final int BOX = 2;
    protected int arrowType = 0;
    protected Transformation transformation = null;
    protected double originx = 0.0;
    protected double originy = 0.0;
    protected double originz = 0.0;
    protected boolean originIsRelative = true;
    private int div = -1;
    protected double xmin = Double.NaN;
    protected double xmax = Double.NaN;
    protected double ymin = Double.NaN;
    protected double ymax = Double.NaN;
    protected double zmin = Double.NaN;
    protected double zmax = Double.NaN;
    private double[] coordinates = new double[3];
    private double[] pixel = new double[3];
    private Object3D[] objects = null;
    private int[] aCoord = null;
    private int[] bCoord = null;
    private double[][] points = null;
    protected double[] pixelOrigin = new double[3];
    protected double[] pixelEndpoint = new double[3];
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints = 0;
    private int[] headA = new int[10];
    private int[] headB = new int[10];

    public InteractiveArrow() {
        this(0);
    }

    public InteractiveArrow(int n) {
        this.setArrowType(n);
        this.div = -1;
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveArrow) {
            InteractiveArrow interactiveArrow = (InteractiveArrow)interactiveElement;
            this.setArrowType(interactiveArrow.arrowType);
            this.setOrigin(interactiveArrow.originx, interactiveArrow.originy, interactiveArrow.originz, interactiveArrow.originIsRelative);
            this.setTransformation(interactiveArrow.transformation);
        }
    }

    public void setArrowType(int n) {
        this.arrowType = n;
        this.panelWithValidProjection = null;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(drawingPanel);
        } else if (drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.sizeEnabled && Math.abs(this.pixelEndpoint[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelEndpoint[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementSize(this);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(drawingPanel3D);
        } else if (drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        Color color = drawingPanel3D.projectColor(this.style.edgeColor, this.objects[n].distance);
        if (n < this.div - 1 || this.arrowType == 1) {
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.setColor(color);
            graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n + 1], this.bCoord[n + 1]);
            return;
        }
        Paint paint = this.style.fillPattern;
        if (paint instanceof Color) {
            paint = drawingPanel3D.projectColor((Color)paint, this.objects[n].distance);
        }
        this.drawHead(drawingPanel3D, graphics2D, this.aCoord[n], this.bCoord[n], color, paint);
    }

    public synchronized void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(drawingPanel3D);
        } else if (drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        this.drawHead(drawingPanel3D, graphics2D, this.aCoord[0], this.bCoord[0], this.style.edgeColor, this.style.fillPattern);
    }

    public synchronized void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeDivisions();
            this.projectPoints(drawingPanel);
        } else {
            this.projectPoints(drawingPanel);
        }
        this.drawHead(drawingPanel, (Graphics2D)graphics, this.aCoord[0], this.bCoord[0], this.style.edgeColor, this.style.fillPattern);
    }

    public void setOrigin(double d, double d2, double d3, boolean bl) {
        this.originx = d;
        this.originy = d2;
        this.originz = d3;
        this.originIsRelative = bl;
        this.hasChanged = true;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation == null ? null : (Transformation)transformation.clone();
        this.hasChanged = true;
    }

    public void toSpaceFrame(double[] dArray) {
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        dArray[2] = dArray[2] + this.z;
    }

    public void toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        dArray[0] = dArray[0] - this.x;
        dArray[1] = dArray[1] - this.y;
        dArray[2] = dArray[2] - this.z;
        if (this.transformation != null) {
            this.transformation.inverse(dArray);
        }
    }

    public double getXMin() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmin)) {
            this.computeExtrema();
        }
        return this.xmin;
    }

    public double getXMax() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmax)) {
            this.computeExtrema();
        }
        return this.xmax;
    }

    public double getYMin() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymin)) {
            this.computeExtrema();
        }
        return this.ymin;
    }

    public double getYMax() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymax)) {
            this.computeExtrema();
        }
        return this.ymax;
    }

    public double getZMin() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmin)) {
            this.computeExtrema();
        }
        return this.zmin;
    }

    public double getZMax() {
        if (this.hasChanged) {
            this.computeDivisions();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmax)) {
            this.computeExtrema();
        }
        return this.zmax;
    }

    protected void computeExtrema() {
        this.zmin = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.zmax = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
        for (int i = 0; i <= this.div; ++i) {
            double d = this.points[i][0];
            if (d < this.xmin) {
                this.xmin = d;
            }
            if (d > this.xmax) {
                this.xmax = d;
            }
            if ((d = this.points[i][1]) < this.ymin) {
                this.ymin = d;
            }
            if (d > this.ymax) {
                this.ymax = d;
            }
            if ((d = this.points[i][2]) < this.zmin) {
                this.zmin = d;
            }
            if (!(d > this.zmax)) continue;
            this.zmax = d;
        }
        if (this.group != null) {
            this.xmin = this.group.x + this.xmin * this.group.sizex;
            this.xmax = this.group.x + this.xmax * this.group.sizex;
            this.ymin = this.group.y + this.ymin * this.group.sizey;
            this.ymax = this.group.y + this.ymax * this.group.sizey;
            this.zmin = this.group.z + this.zmin * this.group.sizez;
            this.zmax = this.group.z + this.zmax * this.group.sizez;
        }
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        if (this.group == null) {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            drawingPanel.project(this.coordinates, this.pixelEndpoint);
            for (int i = 0; i < this.div; ++i) {
                drawingPanel.project(this.points[i], this.pixel);
                this.aCoord[i] = (int)this.pixel[0];
                this.bCoord[i] = (int)this.pixel[1];
                for (int j = 0; j < 3; ++j) {
                    this.coordinates[j] = (this.points[i][j] + this.points[i + 1][j]) * 0.5;
                }
                drawingPanel.project(this.coordinates, this.pixel);
                this.objects[i].distance = this.pixel[2];
            }
            drawingPanel.project(this.points[this.div], this.pixel);
            this.aCoord[this.div] = (int)this.pixel[0];
            this.bCoord[this.div] = (int)this.pixel[1];
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixelEndpoint);
            for (int i = 0; i < this.div; ++i) {
                this.coordinates[0] = this.group.x + this.points[i][0] * this.group.sizex;
                this.coordinates[1] = this.group.y + this.points[i][1] * this.group.sizey;
                this.coordinates[2] = this.group.z + this.points[i][2] * this.group.sizez;
                drawingPanel.project(this.coordinates, this.pixel);
                this.aCoord[i] = (int)this.pixel[0];
                this.bCoord[i] = (int)this.pixel[1];
                for (int j = 0; j < 3; ++j) {
                    this.coordinates[j] = (this.points[i][j] + this.points[i + 1][j]) * 0.5;
                }
                this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
                this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
                this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
                drawingPanel.project(this.coordinates, this.pixel);
                this.objects[i].distance = this.pixel[2];
            }
            this.coordinates[0] = this.group.x + this.points[this.div][0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.points[this.div][1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.points[this.div][2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixel);
            this.aCoord[this.div] = (int)this.pixel[0];
            this.bCoord[this.div] = (int)this.pixel[1];
        }
        this.computeHead();
        this.panelWithValidProjection = drawingPanel;
    }

    protected void computeDivisions() {
        double d;
        int n = 1;
        if (this.resolution != null) {
            switch (this.resolution.type) {
                case 1: {
                    d = Math.sqrt(this.sizex * this.sizex + this.sizey * this.sizey + this.sizez * this.sizez);
                    n = Math.max((int)Math.round(0.49 + d / this.resolution.maxLength), 1);
                    break;
                }
                case 0: {
                    n = Math.max(this.resolution.n1, 1);
                }
            }
        }
        if (this.div != n) {
            this.div = n;
            this.points = new double[this.div + 1][3];
            this.aCoord = new int[this.div + 1];
            this.bCoord = new int[this.div + 1];
            this.objects = new Object3D[this.div];
            for (int i = 0; i < this.div; ++i) {
                this.objects[i] = new Object3D(this, i);
            }
        }
        this.points[0][0] = this.x;
        this.points[0][1] = this.y;
        this.points[0][2] = this.z;
        d = this.sizex;
        double d2 = this.sizey;
        double d3 = this.sizez;
        this.points[this.div][0] = this.x + d;
        this.points[this.div][1] = this.y + d2;
        this.points[this.div][2] = this.z + d3;
        d /= (double)this.div;
        d2 /= (double)this.div;
        d3 /= (double)this.div;
        for (int i = 1; i < this.div; ++i) {
            this.points[i][0] = this.x + (double)i * d;
            this.points[i][1] = this.y + (double)i * d2;
            this.points[i][2] = this.z + (double)i * d3;
        }
        this.transformDivisions();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }

    protected void computeAbsoluteDifference(double[] dArray) {
        dArray[0] = this.originx * this.sizex;
        dArray[1] = this.originy * this.sizey;
        dArray[2] = this.originz * this.sizez;
    }

    protected void transformPoint(double[] dArray, boolean bl) {
        if (bl) {
            double[] dArray2 = new double[3];
            this.computeAbsoluteDifference(dArray2);
            dArray[0] = dArray[0] - dArray2[0];
            dArray[1] = dArray[1] - dArray2[1];
            dArray[2] = dArray[2] - dArray2[2];
        }
        if (this.transformation != null) {
            dArray[0] = dArray[0] - this.x;
            dArray[1] = dArray[1] - this.y;
            dArray[2] = dArray[2] - this.z;
            this.transformation.direct(dArray);
            dArray[0] = dArray[0] + this.x;
            dArray[1] = dArray[1] + this.y;
            dArray[2] = dArray[2] + this.z;
        }
    }

    protected void transformDivisions() {
        if (this.originIsRelative) {
            this.computeAbsoluteDifference(this.coordinates);
        } else {
            this.coordinates[0] = this.originx;
            this.coordinates[1] = this.originy;
            this.coordinates[2] = this.originz;
        }
        for (int i = 0; i <= this.div; ++i) {
            double[] dArray = this.points[i];
            dArray[0] = dArray[0] - this.coordinates[0];
            double[] dArray2 = this.points[i];
            dArray2[1] = dArray2[1] - this.coordinates[1];
            double[] dArray3 = this.points[i];
            dArray3[2] = dArray3[2] - this.coordinates[2];
            if (this.transformation == null) continue;
            double[] dArray4 = this.points[i];
            dArray4[0] = dArray4[0] - this.x;
            double[] dArray5 = this.points[i];
            dArray5[1] = dArray5[1] - this.y;
            double[] dArray6 = this.points[i];
            dArray6[2] = dArray6[2] - this.z;
            this.transformation.direct(this.points[i]);
            double[] dArray7 = this.points[i];
            dArray7[0] = dArray7[0] + this.x;
            double[] dArray8 = this.points[i];
            dArray8[1] = dArray8[1] + this.y;
            double[] dArray9 = this.points[i];
            dArray9[2] = dArray9[2] + this.z;
        }
    }

    private void computeHead() {
        if (this.arrowType == 1) {
            this.headPoints = 0;
            return;
        }
        double d = this.aCoord[this.div] - this.aCoord[0];
        double d2 = this.bCoord[this.div] - this.bCoord[0];
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            this.headPoints = 0;
            return;
        }
        d = 0.35 * d / d3;
        d2 = 0.35 * d2 / d3;
        if (d3 > 25.0) {
            d *= 25.0 / d3;
            d2 *= 25.0 / d3;
        }
        int n = (int)((double)this.aCoord[this.div] - d * d3);
        int n2 = (int)((double)this.bCoord[this.div] - d2 * d3);
        d *= d3 / 2.0;
        d2 *= d3 / 2.0;
        switch (this.arrowType) {
            default: {
                this.headPoints = 6;
                this.headA[0] = n;
                this.headB[0] = n2;
                this.headA[1] = n - (int)d2;
                this.headB[1] = n2 + (int)d;
                this.headA[2] = this.aCoord[this.div];
                this.headB[2] = this.bCoord[this.div];
                this.headA[3] = n + (int)d2;
                this.headB[3] = n2 - (int)d;
                this.headA[4] = n;
                this.headB[4] = n2;
                break;
            }
            case 2: {
                this.headPoints = 7;
                this.headA[0] = n;
                this.headB[0] = n2;
                this.headA[1] = n - (int)d2;
                this.headB[1] = n2 + (int)d;
                this.headA[2] = this.aCoord[this.div] - (int)d2;
                this.headB[2] = this.bCoord[this.div] + (int)d;
                this.headA[3] = this.aCoord[this.div] + (int)d2;
                this.headB[3] = this.bCoord[this.div] - (int)d;
                this.headA[4] = n + (int)d2;
                this.headB[4] = n2 - (int)d;
                this.headA[5] = n;
                this.headB[5] = n2;
            }
        }
    }

    private void drawHead(DrawingPanel drawingPanel, Graphics2D graphics2D, int n, int n2, Color color, Paint paint) {
        graphics2D.setStroke(this.style.edgeStroke);
        if (this.headPoints == 0) {
            graphics2D.setColor(color);
            graphics2D.drawLine(n, n2, this.aCoord[this.div], this.bCoord[this.div]);
        } else {
            int n3 = this.headPoints - 1;
            this.headA[n3] = n;
            this.headB[n3] = n2;
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fillPolygon(this.headA, this.headB, n3);
            }
            graphics2D.setColor(color);
            graphics2D.drawPolyline(this.headA, this.headB, this.headPoints);
        }
    }
}

