/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractAxes;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.tools.FontSizer;

public class CartesianType1
extends AbstractAxes
implements CartesianAxes,
Dimensioned {
    double yMax;
    double yMin;
    double xMax;
    double xMin;
    boolean xlog = false;
    boolean ylog = false;
    static final double LOG10SCALE = 1.0 / Math.log(10.0);
    Color foreground = Color.black;
    double ytickMax;
    double ytickMin;
    double xtickMax;
    double xtickMin;
    int yExponent;
    int xExponent;
    FontMetrics labelFontMetrics = null;
    FontMetrics superscriptFontMetrics = null;
    FontMetrics titleFontMetrics = null;
    int gridCurJuke = 0;
    double gridBase;
    protected DrawableTextLine xLine = new DrawableTextLine("x", 0.0, 0.0);
    protected DrawableTextLine yLine = new DrawableTextLine("y", 0.0, 0.0);
    ArrayList xticks = null;
    ArrayList xticklabels = null;
    ArrayList yticks = null;
    ArrayList yticklabels = null;
    NumberFormat numberFormat = NumberFormat.getInstance();
    NumberFormat scientificFormat = new DecimalFormat("0.0E0");
    boolean drawMajorXGrid = true;
    boolean drawMinorXGrid = false;
    boolean drawMajorYGrid = true;
    boolean drawMinorYGrid = false;
    private int topGutter = 25;
    private int bottomGutter = 45;
    private int leftGutter = 45;
    private int rightGutter = 25;
    private int tickLength = 5;
    private boolean adjustGutters = true;
    private int yTickWidth = 0;

    public CartesianType1(PlottingPanel plottingPanel) {
        super(plottingPanel);
        this.defaultTopGutter = this.topGutter;
        this.defaultBottomGutter = this.bottomGutter;
        this.defaultLeftGutter = this.leftGutter;
        this.defaultRightGutter = this.rightGutter;
        this.labelFont = new Font("Dialog", 0, 12);
        this.superscriptFont = new Font("Dialog", 0, 9);
        this.xLine.setJustification(0);
        this.xLine.setFont(this.labelFont);
        this.xLine.setPixelXY(true);
        this.yLine.setJustification(0);
        this.yLine.setFont(this.labelFont);
        this.yLine.setTheta(1.5707963267948966);
        this.yLine.setPixelXY(true);
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        this.titleLine.setPixelXY(true);
        if (plottingPanel == null) {
            return;
        }
        plottingPanel.setPreferredGutters(this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter);
        this.measureFonts(plottingPanel);
        plottingPanel.setAxes(this);
        plottingPanel.setCoordinateStringBuilder(CoordinateStringBuilder.createCartesian());
        this.resizeFonts(FontSizer.getFactor(FontSizer.getLevel()), plottingPanel);
    }

    private int xToPix(double d, DrawingPanel drawingPanel) {
        double[] dArray = drawingPanel.getPixelMatrix();
        double d2 = dArray[0] * d + dArray[4];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    private int yToPix(double d, DrawingPanel drawingPanel) {
        double[] dArray = drawingPanel.getPixelMatrix();
        double d2 = dArray[3] * d + dArray[5];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    private int getLeftGutter(DrawingPanel drawingPanel) {
        int n = 40;
        if (this.ylog) {
            return n + 10;
        }
        int n2 = drawingPanel.getHeight() - this.topGutter - this.bottomGutter;
        int n3 = 2 + n2 / (this.labelFontMetrics.getHeight() + 10);
        n3 = (int)((double)n3 / drawingPanel.getImageRatio());
        double d = this.roundUp((this.ytickMax - this.ytickMin) / (double)n3);
        double d2 = d * Math.ceil(this.ytickMin / d);
        int n4 = this.numFracDigits(d);
        double d3 = Math.abs(d / 100.0);
        if (d == 0.0 || Math.abs((this.ytickMax - d2) / d) > 50.0) {
            return n;
        }
        double d4 = d2;
        this.yTickWidth = 0;
        int n5 = this.labelFontMetrics.getHeight();
        for (int i = 0; i <= n3; ++i) {
            String string = this.formatNum(d4, n4, d3);
            int n6 = this.labelFontMetrics.stringWidth(string);
            this.yTickWidth = Math.max(this.yTickWidth, n6);
            n = Math.max(n6 + 2 * n5, n);
            d4 += d;
        }
        return Math.min(n, drawingPanel.getWidth());
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        double d;
        if (!this.visible) {
            return;
        }
        this.topGutter = drawingPanel.getTopGutter();
        this.bottomGutter = drawingPanel.getBottomGutter();
        this.leftGutter = drawingPanel.getLeftGutter();
        this.rightGutter = drawingPanel.getRightGutter();
        this.yMax = drawingPanel.getYMax();
        this.yMin = drawingPanel.getYMin();
        this.xMax = drawingPanel.getXMax();
        this.xMin = drawingPanel.getXMin();
        if (this.xMax < this.xMin) {
            d = this.xMax;
            this.xMax = this.xMin;
            this.xMin = d;
        }
        if (this.yMax < this.yMin) {
            d = this.yMax;
            this.yMax = this.yMin;
            this.yMin = d;
        }
        this.setXRange(this.xMin, this.xMax);
        this.setYRange(this.yMin, this.yMax);
        if (this.adjustGutters && drawingPanel.isAutoscaleY()) {
            this.leftGutter = Math.max(this.leftGutter, this.getLeftGutter(drawingPanel));
            drawingPanel.setGutters(this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter);
            drawingPanel.recomputeTransform();
        }
        this.drawPlot(drawingPanel, graphics);
    }

    public void addXTick(String string, double d) {
        if (this.xticks == null) {
            this.xticks = new ArrayList();
            this.xticklabels = new ArrayList();
        }
        this.xticks.add(new Double(d));
        this.xticklabels.add(string);
    }

    public void addYTick(String string, double d) {
        if (this.yticks == null) {
            this.yticks = new ArrayList();
            this.yticklabels = new ArrayList();
        }
        this.yticks.add(new Double(d));
        this.yticklabels.add(string);
    }

    public void setLabelFont(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.labelFont = Font.decode(string);
    }

    public void setTitle(String string, String string2) {
        this.titleLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.titleLine.setFont(Font.decode(string2));
        this.setTitleFont(string2);
    }

    public void setTitleFont(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.titleFont = Font.decode(string);
        this.titleLine.setFont(this.titleFont);
    }

    public void setXLabel(String string, String string2) {
        this.xLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.xLine.setFont(Font.decode(string2));
        this.setLabelFont(string2);
    }

    public void setXLog(boolean bl) {
        this.xlog = bl;
    }

    public void setYLabel(String string, String string2) {
        this.yLine.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.yLine.setFont(Font.decode(string2));
        this.setLabelFont(string2);
    }

    public void setYLog(boolean bl) {
        this.ylog = bl;
    }

    public String getTitle() {
        return this.titleLine.getText();
    }

    public String getXLabel() {
        return this.xLine.getText();
    }

    public boolean isXLog() {
        return this.xlog;
    }

    public String getYLabel() {
        return this.yLine.getText();
    }

    public boolean isYLog() {
        return this.ylog;
    }

    public void resizeFonts(double d, DrawingPanel drawingPanel) {
        super.resizeFonts(d, drawingPanel);
        if (this.xLine == null) {
            return;
        }
        this.xLine.setFont(this.labelFont);
        this.yLine.setFont(this.labelFont);
        int n = (int)((double)this.defaultLeftGutter * d);
        int n2 = (int)((double)this.defaultBottomGutter * d);
        int n3 = (int)((double)this.defaultTopGutter * d);
        int n4 = (int)((double)this.defaultRightGutter * d);
        drawingPanel.setGutters(n, n3, n4, n2);
        this.measureFonts(drawingPanel);
    }

    protected void drawPlot(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        double d;
        double d2;
        int n2;
        double d3;
        int n3;
        Object object;
        int n4;
        int n5 = drawingPanel.getHeight();
        int n6 = drawingPanel.getWidth();
        Shape shape = graphics.getClip();
        Font font = graphics.getFont();
        graphics.clipRect(0, 0, n6, n5);
        graphics.setFont(this.labelFont);
        graphics.setColor(this.foreground);
        int n7 = n6 - this.rightGutter;
        int n8 = n5 - this.bottomGutter;
        int n9 = n4 = this.titleFontMetrics.getHeight();
        int n10 = this.labelFontMetrics.getHeight();
        int n11 = n10 / 2;
        int n12 = n5 - 5;
        int n13 = n6 - 5 - OSPLayout.macOffset;
        if (this.xlog) {
            this.xExponent = (int)Math.floor(this.xtickMin);
        }
        if (this.xExponent != 0 && this.xticks == null) {
            String string = Integer.toString(this.xExponent);
            n13 -= this.superscriptFontMetrics.stringWidth(string);
            graphics.setFont(this.superscriptFont);
            if (!this.xlog) {
                graphics.drawString(string, n13, n12 - n11);
                graphics.setFont(this.labelFont);
                graphics.drawString("x 10", n13 -= this.labelFontMetrics.stringWidth("x 10"), n12);
            }
        }
        int n14 = n5 - this.topGutter - this.bottomGutter;
        int n15 = 2 + n14 / (n10 + 10);
        n15 = (int)((double)n15 / drawingPanel.getImageRatio());
        double d4 = this.roundUp((this.ytickMax - this.ytickMin) / (double)n15);
        double d5 = d4 * Math.ceil(this.ytickMin / d4);
        int n16 = n6 - this.rightGutter - this.leftGutter;
        if (this.interiorColor != null) {
            graphics.setColor(this.interiorColor);
            graphics.fillRect(this.leftGutter, this.topGutter, n16, n14);
        }
        int n17 = this.leftGutter + this.tickLength;
        int n18 = n7 - this.tickLength;
        int n19 = this.numFracDigits(d4);
        if (this.yticks == null) {
            int n20;
            object = null;
            double d6 = d5;
            if (this.ylog) {
                object = this.gridInit(d5, d4, true, null);
                d6 = this.gridStep((ArrayList)object, d5, d4, this.ylog);
            }
            n3 = this.ylog;
            boolean bl = true;
            graphics.setColor(this.foreground);
            d3 = Math.abs(d4 / 100.0);
            n2 = n15;
            d2 = d6;
            while (d2 <= this.ytickMax && --n2 >= 0) {
                String string = null;
                if (this.ylog) {
                    string = this.formatLogNum(d2, n19);
                    if (string.indexOf(101) != -1) {
                        n3 = 0;
                    }
                } else {
                    string = this.formatNum(d2, n19, d3);
                }
                int n21 = 0;
                n21 = this.ylog || this.yExponent == 0 ? this.yToPix(d2, drawingPanel) : this.yToPix(d2 * Math.pow(10.0, this.yExponent), drawingPanel);
                int n22 = n10 / 4;
                if (bl && !this.ylog) {
                    bl = false;
                    n22 = 0;
                }
                graphics.drawLine(this.leftGutter, n21, n17, n21);
                graphics.drawLine(n16 + this.leftGutter - 1, n21, n18, n21);
                if (this.drawMajorYGrid && n21 >= this.topGutter && n21 <= n8) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(n17, n21, n18, n21);
                    graphics.setColor(this.foreground);
                }
                n20 = this.labelFontMetrics.stringWidth(string);
                graphics.drawString(string, this.leftGutter - n20 - 4, n21 + n22);
                d2 = this.gridStep((ArrayList)object, d2, d4, this.ylog);
            }
            if (this.ylog || this.drawMinorYGrid) {
                ArrayList arrayList = this.gridInit(d5, d4, false, (ArrayList)object);
                if (arrayList.size() > 0) {
                    d = d4 > 1.0 ? 1.0 : d4;
                    double d7 = this.gridStep(arrayList, d5, d, this.ylog);
                    while (d7 <= this.ytickMax) {
                        n20 = this.yToPix(d7, drawingPanel);
                        if (n20 != this.topGutter && n20 != n8) {
                            graphics.setColor(this.gridcolor);
                            graphics.drawLine(this.leftGutter + 1, n20, n7 - 1, n20);
                            graphics.setColor(this.foreground);
                        }
                        d7 = this.gridStep(arrayList, d7, d, this.ylog);
                    }
                }
                this.yExponent = n3 != 0 ? (int)Math.floor(d6) : 0;
            }
            if (this.yExponent != 0) {
                graphics.drawString("x 10", 2, n9);
                graphics.setFont(this.superscriptFont);
                graphics.drawString(Integer.toString(this.yExponent), this.labelFontMetrics.stringWidth("x 10") + 2, n9 - n11);
                graphics.setFont(this.labelFont);
            }
        } else {
            object = this.yticks.iterator();
            Iterator iterator = this.yticklabels.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                double d8 = (Double)object.next();
                if (d8 > this.yMax || d8 < this.yMin) continue;
                int n23 = this.yToPix(d8 * Math.pow(10.0, this.yExponent), drawingPanel);
                n = 0;
                if (d8 < (double)(n8 - n10)) {
                    n = n11;
                }
                graphics.drawLine(this.leftGutter, n23, n17, n23);
                graphics.drawLine(n16 + this.leftGutter - 1, n23, n18, n23);
                if (this.drawMajorYGrid && n23 >= this.topGutter && n23 <= n8) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(n17, n23, n18, n23);
                    graphics.setColor(this.foreground);
                }
                graphics.drawString(string, this.leftGutter - this.labelFontMetrics.stringWidth(string) - 3, n23 + n);
            }
        }
        int n24 = this.topGutter + this.tickLength;
        int n25 = n8 - this.tickLength;
        int n26 = this.labelFontMetrics.stringWidth("8");
        if (this.xticks == null) {
            Object object2;
            n3 = 10;
            n3 = (int)((double)n3 / drawingPanel.getImageRatio());
            double d9 = 0.0;
            n19 = 0;
            if (this.xlog) {
                n3 = 4 + n16 / (n26 * 6 + 10);
                n3 = (int)((double)n3 / drawingPanel.getImageRatio());
            } else {
                n = 0;
                while (n++ <= 10) {
                    int n27;
                    d9 = this.roundUp((this.xtickMax - this.xtickMin) / (double)n3);
                    n19 = this.numFracDigits(d9);
                    n2 = this.numIntDigits(this.xtickMax);
                    if (n2 < (n27 = this.numIntDigits(this.xtickMin))) {
                        n2 = n27;
                    }
                    int n28 = n26 * (n19 + 2 + n2);
                    int n29 = n3;
                    n3 = 2 + n16 / (n28 + 10);
                    if ((n3 = (int)((double)n3 / drawingPanel.getImageRatio())) - n29 > 1 && n29 - n3 > 1) continue;
                    break;
                }
            }
            d9 = this.xlog ? this.roundUp(0.8 * (this.xtickMax - this.xtickMin) / (double)n3) : this.roundUp((this.xtickMax - this.xtickMin) / (double)n3);
            n19 = this.numFracDigits(d9);
            double d10 = d9 * Math.ceil(this.xtickMin / d9);
            ArrayList arrayList = null;
            d = d10;
            if (this.xlog) {
                d10 = d9 * Math.floor(this.xtickMin / d9);
                arrayList = this.gridInit(d10, d9, true, null);
                d = this.gridRoundUp(arrayList, d10);
            }
            boolean bl = this.xlog;
            graphics.setColor(this.foreground);
            double d11 = Math.abs(d4 / 100.0);
            int n30 = n3;
            double d12 = d;
            while (d12 <= this.xtickMax && --n30 >= 0) {
                object2 = null;
                boolean bl2 = false;
                if (this.xlog) {
                    object2 = this.formatLogNum(d12, n19);
                    if (((String)object2).indexOf(101) != -1) {
                        bl = false;
                        bl2 = true;
                    }
                } else {
                    object2 = this.formatNum(d12, n19, d11);
                }
                n17 = this.xlog || this.xExponent == 0 ? this.xToPix(d12, drawingPanel) : this.xToPix(d12 * Math.pow(10.0, this.xExponent), drawingPanel);
                graphics.drawLine(n17, this.topGutter, n17, n24);
                graphics.drawLine(n17, n14 + this.topGutter - 1, n17, n25);
                if (this.drawMajorXGrid && n17 >= this.leftGutter && n17 <= n7) {
                    graphics.setColor(this.gridcolor);
                    graphics.drawLine(n17, n24, n17, n25);
                    graphics.setColor(this.foreground);
                }
                int n31 = n17 - this.labelFontMetrics.stringWidth((String)object2) / 2;
                if (bl2) {
                    graphics.drawString((String)object2, n31 + 7, n8 + 3 + n10);
                } else {
                    graphics.drawString((String)object2, n31, n8 + 3 + n10);
                }
                d12 = this.gridStep(arrayList, d12, d9, this.xlog);
            }
            if (this.xlog || this.drawMinorXGrid) {
                d12 = d9 > 1.0 ? 1.0 : d9;
                d = d12 * Math.ceil(this.xtickMin / d12);
                object2 = this.gridInit(d, d12, false, arrayList);
                if (((ArrayList)object2).size() > 0) {
                    double d13 = this.gridStep((ArrayList)object2, d, d12, this.xlog);
                    while (d13 <= this.xtickMax) {
                        n17 = this.xToPix(d13, drawingPanel);
                        if (n17 != this.leftGutter && n17 != n7) {
                            graphics.setColor(this.gridcolor);
                            graphics.drawLine(n17, this.topGutter + 1, n17, n8 - 1);
                            graphics.setColor(this.foreground);
                        }
                        d13 = this.gridStep((ArrayList)object2, d13, d12, this.xlog);
                    }
                }
                if (bl) {
                    this.xExponent = (int)Math.floor(d);
                    graphics.setFont(this.superscriptFont);
                    graphics.drawString(Integer.toString(this.xExponent), n13, n12 - n11);
                    graphics.setFont(this.labelFont);
                    graphics.drawString("x 10", n13 -= this.labelFontMetrics.stringWidth("x 10"), n12);
                } else {
                    this.xExponent = 0;
                }
            }
        } else {
            Iterator iterator = this.xticks.iterator();
            Iterator iterator2 = this.xticklabels.iterator();
            d3 = 0.0;
            while (iterator2.hasNext()) {
                int n32;
                String string = (String)iterator2.next();
                d2 = (Double)iterator.next();
                if (d2 > this.xMax || d2 < this.xMin || !((double)(n32 = (n17 = this.xToPix(d2 * Math.pow(10.0, this.xExponent), drawingPanel)) - this.labelFontMetrics.stringWidth(string) / 2) > d3)) continue;
                d3 = n17 + this.labelFontMetrics.stringWidth(string) / 2 + 10;
                graphics.drawString(string, n32, n8 + 3 + n10);
                graphics.drawLine(n17, this.topGutter, n17, n24);
                graphics.drawLine(n17, n14 + this.topGutter - 1, n17, n25);
                if (!this.drawMajorXGrid || n17 < this.leftGutter || n17 > n7) continue;
                graphics.setColor(this.gridcolor);
                graphics.drawLine(n17, n24, n17, n25);
                graphics.setColor(this.foreground);
            }
        }
        graphics.setColor(this.foreground);
        if (this.titleLine != null) {
            this.titleLine.setX(drawingPanel.getLeftGutter() / 2 + (drawingPanel.getWidth() - drawingPanel.getRightGutter()) / 2);
            if ((double)drawingPanel.getTopGutter() > 1.2 * (double)this.labelFontMetrics.getHeight()) {
                this.titleLine.setY((double)drawingPanel.getTopGutter() - 0.6 * (double)this.labelFontMetrics.getHeight());
            } else {
                this.titleLine.setY((double)drawingPanel.getTopGutter() + 1.5 * (double)this.labelFontMetrics.getHeight());
            }
            this.titleLine.draw(drawingPanel, graphics);
        }
        if (this.xLine != null) {
            double d14 = (double)this.leftGutter / 2.0 + (double)(drawingPanel.getWidth() - this.rightGutter) / 2.0;
            this.xLine.setX(d14);
            int n33 = drawingPanel.getBottomGutter() - 2 * this.labelFontMetrics.getHeight();
            this.xLine.setY(drawingPanel.getHeight() - Math.max(0, n33));
            this.xLine.draw(drawingPanel, graphics);
        }
        if (this.yLine != null) {
            double d15 = (double)this.topGutter / 2.0 + (double)((drawingPanel.getHeight() - this.bottomGutter) / 2);
            this.yLine.setY(d15);
            this.yLine.setX((double)(drawingPanel.getLeftGutter() - this.yTickWidth) - 0.7 * (double)this.labelFontMetrics.getHeight());
            this.yLine.draw(drawingPanel, graphics);
        }
        graphics.setColor(this.foreground);
        graphics.drawRect(this.leftGutter, this.topGutter, n16 - 1, n14 - 1);
        graphics.setFont(font);
        graphics.setClip(shape);
    }

    private String formatLogNum(double d, int n) {
        int n2 = (int)d;
        String string = n2 >= 0 && n2 < 10 ? "0" + n2 : (n2 < 0 && n2 > -10 ? "-0" + -n2 : Integer.toString(n2));
        string = d >= 0.0 ? (d - (double)((int)d) < 0.001 ? "1e" + string : this.formatNum(Math.pow(10.0, d - (double)((int)d)), n, 1.4E-45f)) : (-d - (double)((int)(-d)) < 0.001 ? "1e" + string : this.formatNum(Math.pow(10.0, d - (double)((int)d)) * 10.0, n, 1.4E-45f));
        return string;
    }

    private String formatNum(double d, int n, double d2) {
        NumberFormat numberFormat;
        if (Math.abs(d) < 0.01 && Math.abs(d) > d2) {
            numberFormat = this.scientificFormat;
        } else {
            numberFormat = this.numberFormat;
            numberFormat.setMinimumFractionDigits(n);
            numberFormat.setMaximumFractionDigits(n);
        }
        return numberFormat.format(d);
    }

    private ArrayList gridInit(double d, double d2, boolean bl, ArrayList arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>(10);
        double d3 = Math.pow(10.0, d2);
        int n = 1;
        if (bl) {
            if (d3 <= 3.5) {
                if (d3 > 2.0) {
                    n = 2;
                } else if (d3 > 1.26) {
                    n = 5;
                } else if (d3 > 1.125) {
                    n = 10;
                } else {
                    n = (int)Math.rint(1.0 / d2);
                    n = 10;
                }
            }
        } else {
            n = d3 > 10.0 ? 1 : (d3 > 3.0 ? 2 : (d3 > 2.0 ? 5 : (d3 > 1.125 ? 10 : 100)));
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d4 = (double)i * 1.0 / (double)n * 10.0;
            double d5 = LOG10SCALE * Math.log(d4);
            if (d5 == Double.NEGATIVE_INFINITY) {
                d5 = 0.0;
            }
            if (arrayList != null && n2 < arrayList.size()) {
                while (n2 < arrayList.size() && (Double)arrayList.get(n2) < d5) {
                    ++n2;
                }
                if (n2 < arrayList.size()) {
                    if (!(Math.abs((Double)arrayList.get(n2) - d5) > 1.0E-5)) continue;
                    arrayList2.add(new Double(d5));
                    continue;
                }
                arrayList2.add(new Double(d5));
                continue;
            }
            arrayList2.add(new Double(d5));
        }
        this.gridCurJuke = 0;
        if (d == -0.0) {
            d = 0.0;
        }
        this.gridBase = Math.floor(d);
        double d6 = d - this.gridBase;
        this.gridCurJuke = -1;
        while (this.gridCurJuke + 1 < arrayList2.size() && d6 >= (Double)arrayList2.get(this.gridCurJuke + 1)) {
            ++this.gridCurJuke;
        }
        return arrayList2;
    }

    private double gridRoundUp(ArrayList arrayList, double d) {
        int n;
        double d2 = d - Math.floor(d);
        for (n = 0; n < arrayList.size() && d2 >= (Double)arrayList.get(n); ++n) {
        }
        if (n >= arrayList.size()) {
            return d;
        }
        return Math.floor(d) + (Double)arrayList.get(n);
    }

    private double gridStep(ArrayList arrayList, double d, double d2, boolean bl) {
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        if (bl) {
            if (++this.gridCurJuke >= arrayList.size()) {
                this.gridCurJuke = 0;
                this.gridBase += Math.ceil(d2);
            }
            if (this.gridCurJuke >= arrayList.size()) {
                return d + d2;
            }
            return this.gridBase + (Double)arrayList.get(this.gridCurJuke);
        }
        if (d + d2 == d) {
            while (d + d2 == d) {
                d2 *= 2.0;
            }
            return d + d2;
        }
        return d + d2;
    }

    private void measureFonts(JPanel jPanel) {
        this.labelFontMetrics = jPanel.getFontMetrics(this.labelFont);
        this.superscriptFontMetrics = jPanel.getFontMetrics(this.superscriptFont);
        this.titleFontMetrics = jPanel.getFontMetrics(this.titleFont);
    }

    private int numFracDigits(double d) {
        int n;
        for (n = 0; n <= 15 && d != Math.floor(d); d *= 10.0, ++n) {
        }
        return n;
    }

    private int numIntDigits(double d) {
        int n;
        for (n = 0; n <= 15 && (double)((int)d) != 0.0; ++n) {
            d /= 10.0;
        }
        return n;
    }

    private double roundUp(double d) {
        int n;
        d = (d *= Math.pow(10.0, -(n = (int)Math.floor(Math.log(d) * LOG10SCALE)))) > 5.0 ? 10.0 : (d > 2.0 ? 5.0 : (d > 1.0 ? 2.0 : 1.0));
        return d *= Math.pow(10.0, n);
    }

    private void setXRange(double d, double d2) {
        double d3 = Math.max(Math.abs(this.xMin), Math.abs(this.xMax));
        double d4 = Math.abs(this.xMax - this.xMin);
        this.xExponent = this.xMin >= 0.0 && this.xMax <= 1000.0 && d4 > 0.1 && !this.xlog ? 0 : (int)Math.floor(Math.log(d3) * LOG10SCALE);
        if (this.xExponent > 1 || this.xExponent < -1) {
            double d5 = 1.0 / Math.pow(10.0, this.xExponent);
            this.xtickMin = this.xMin * d5;
            this.xtickMax = this.xMax * d5;
        } else {
            this.xtickMin = this.xMin;
            this.xtickMax = this.xMax;
            this.xExponent = 0;
        }
    }

    private void setYRange(double d, double d2) {
        double d3 = Math.max(Math.abs(this.yMin), Math.abs(this.yMax));
        this.yExponent = this.yMin >= 0.0 && this.yMax <= 1000.0 && !this.ylog ? 0 : (int)Math.floor(Math.log(d3) * LOG10SCALE);
        if (this.yExponent > 1 || this.yExponent < -1) {
            double d4 = 1.0 / Math.pow(10.0, this.yExponent);
            this.ytickMin = this.yMin * d4;
            this.ytickMax = this.yMax * d4;
        } else {
            this.ytickMin = this.yMin;
            this.ytickMax = this.yMax;
            this.yExponent = 0;
        }
    }

    public void setShowMajorXGrid(boolean bl) {
        this.drawMajorXGrid = bl;
        if (!bl) {
            this.drawMinorXGrid = bl;
        }
    }

    public void setShowMinorXGrid(boolean bl) {
        this.drawMinorXGrid = bl;
    }

    public void setShowMajorYGrid(boolean bl) {
        this.drawMajorYGrid = bl;
        if (!bl) {
            this.drawMinorYGrid = bl;
        }
    }

    public void setShowMinorYGrid(boolean bl) {
        this.drawMinorYGrid = bl;
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public double getX() {
        return 0.0;
    }

    public double getY() {
        return 0.0;
    }

    public Dimension getInterior(DrawingPanel drawingPanel) {
        this.adjustGutters = drawingPanel.getDimensionSetter() == null;
        return null;
    }
}

