/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;

public class XMLPropertyElement
implements XMLProperty {
    protected XMLProperty parent;
    protected String name;
    protected String type;
    protected String className;
    protected List content;

    public XMLPropertyElement(XMLProperty xMLProperty) {
        this.content = new ArrayList();
        this.parent = xMLProperty;
    }

    public XMLPropertyElement(XMLProperty xMLProperty, String string, String string2, Object object) {
        block8: {
            boolean bl;
            int n;
            block11: {
                block10: {
                    block9: {
                        block7: {
                            this(xMLProperty);
                            this.name = string;
                            this.type = string2;
                            if (!this.type.equals("string")) break block7;
                            if (XML.requiresCDATA((String)object)) {
                                this.content.add("<![CDATA[" + object + "]]>");
                            } else {
                                this.content.add(object.toString());
                            }
                            break block8;
                        }
                        if ("intdoubleboolean".indexOf(this.type) == -1) break block9;
                        this.content.add(object.toString());
                        break block8;
                    }
                    if (!this.type.equals("object")) break block10;
                    this.className = object.getClass().getName();
                    XMLControlElement xMLControlElement = new XMLControlElement(this);
                    xMLControlElement.saveObject(object);
                    this.content.add(xMLControlElement);
                    break block8;
                }
                if (!this.type.equals("collection")) break block11;
                this.className = object.getClass().getName();
                Iterator iterator = ((Collection)object).iterator();
                int n2 = 0;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    String string3 = XML.getDataType(e);
                    if (string3 == null) continue;
                    this.content.add(new XMLPropertyElement(this, "item", string3, e));
                    ++n2;
                }
                break block8;
            }
            if (!this.type.equals("array")) break block8;
            this.className = object.getClass().getName();
            Class<?> clazz = object.getClass().getComponentType();
            Object object2 = object;
            for (n = Array.getLength(object2); n > 0 && clazz.getComponentType() != null; n *= Array.getLength(object2)) {
                clazz = clazz.getComponentType();
                if ((object2 = Array.get(object2, 0)) == null) break;
            }
            boolean bl2 = bl = "intdoubleboolean".indexOf(clazz.getName()) != -1;
            if (bl && n > XMLControlElement.compactArraySize) {
                String string4 = this.getArrayString(object);
                this.content.add(new XMLPropertyElement(this, "array", "string", string4));
            } else {
                int n3 = Array.getLength(object);
                for (int i = 0; i < n3; ++i) {
                    Object object3 = Array.get(object, i);
                    String string5 = XML.getDataType(object3);
                    if (string5 == null) continue;
                    this.content.add(new XMLPropertyElement(this, "[" + i + "]", string5, object3));
                }
            }
        }
    }

    public String getPropertyName() {
        return this.name;
    }

    public String getPropertyType() {
        return this.type;
    }

    public Class getPropertyClass() {
        if (this.type.equals("int")) {
            return Integer.TYPE;
        }
        if (this.type.equals("double")) {
            return Double.TYPE;
        }
        if (this.type.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (this.type.equals("string")) {
            return String.class;
        }
        try {
            return Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public XMLProperty getParentProperty() {
        return this.parent;
    }

    public int getLevel() {
        return this.parent.getLevel() + 1;
    }

    public List getPropertyContent() {
        return this.content;
    }

    public XMLControl getChildControl(String string) {
        XMLControl[] xMLControlArray = this.getChildControls();
        for (int i = 0; i < xMLControlArray.length; ++i) {
            if (!xMLControlArray[i].getPropertyName().equals(string)) continue;
            return xMLControlArray[i];
        }
        return null;
    }

    public XMLControl[] getChildControls() {
        if (this.type.equals("object")) {
            XMLControl xMLControl = (XMLControl)this.getPropertyContent().get(0);
            return new XMLControl[]{xMLControl};
        }
        if ("arraycollection".indexOf(this.type) != -1) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.getPropertyContent().iterator();
            while (iterator.hasNext()) {
                XMLProperty xMLProperty = (XMLProperty)iterator.next();
                if (!xMLProperty.getPropertyType().equals("object")) continue;
                arrayList.add(xMLProperty.getPropertyContent().get(0));
            }
            return arrayList.toArray(new XMLControl[0]);
        }
        return new XMLControl[0];
    }

    public void setValue(String string) {
        boolean bl = true;
        try {
            if (this.type.equals("int")) {
                Integer.parseInt(string);
            } else if (this.type.equals("double")) {
                Double.parseDouble(string);
            } else if (this.type.equals("boolean")) {
                string = string.equals("true") ? "true" : "false";
            } else if ("objectarraycollection".indexOf(this.type) != -1) {
                bl = false;
            } else if (this.type.equals("string") && XML.requiresCDATA(string)) {
                string = "<![CDATA[" + string + "]]>";
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (bl) {
            this.content.clear();
            this.content.add(string);
        }
    }

    public String toString() {
        List list;
        StringBuffer stringBuffer = new StringBuffer(XML.NEW_LINE + this.indent(this.getLevel()) + "<property name=\"" + this.name + "\" type=\"" + this.type + "\"");
        if ("arraycollection".indexOf(this.type) != -1) {
            stringBuffer.append(" class=\"" + this.className + "\"");
        }
        if ((list = this.getPropertyContent()).isEmpty()) {
            stringBuffer.append("/>");
            return stringBuffer.toString();
        }
        stringBuffer.append(">");
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            bl = bl || e instanceof XMLProperty;
            stringBuffer.append(e);
        }
        if (bl) {
            stringBuffer.append(XML.NEW_LINE + this.indent(this.getLevel()));
        }
        stringBuffer.append("</property>");
        return stringBuffer.toString();
    }

    protected String indent(int n) {
        String string = "";
        for (int i = 0; i < 4 * n; ++i) {
            string = string + " ";
        }
        return string;
    }

    protected String getArrayString(Object object) {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2;
            if (i > 0) {
                stringBuffer.append(',');
            }
            if ((object2 = Array.get(object, i)) != null && object2.getClass().isArray()) {
                stringBuffer.append(this.getArrayString(object2));
                continue;
            }
            stringBuffer.append(object2);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

