/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.automaticcontrol;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.GroupDrawable;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionTargetPoligonPoint;
import org.opensourcephysics.displayejs.InteractiveArrow;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.ejs.Function;

public class Tank
extends GroupDrawable
implements InteractionListener {
    private static final boolean[] insideConnected = new boolean[]{true, true, true, true, true};
    private static final boolean[] insideEnabled = new boolean[]{false, true, true, true, false};
    private static final boolean[] sidesEnabled = new boolean[]{true, true, true, true, false, false};
    private static final boolean[] profileEnabled = new boolean[]{false, true, true, true};
    protected double height = 0.5;
    protected double width = 0.2;
    protected boolean interactive = true;
    protected boolean movable = false;
    protected boolean resizable = false;
    protected boolean profilable = false;
    protected boolean showProfiles = false;
    protected boolean showLevelOne = true;
    protected boolean showLevelTwo = false;
    protected boolean interactiveLevelOne = false;
    protected boolean interactiveLevelTwo = false;
    protected double levelOne = 0.2;
    protected double levelTwo = 0.0;
    protected boolean hasChanged = false;
    protected InteractivePoligon sides;
    protected InteractivePoligon inside;
    protected InteractiveArrow level_1;
    protected InteractiveArrow level_2;
    private double[][] data;
    private double[][] insideData;
    private boolean[] sidesConnected = new boolean[]{true, false, true, true, true, true};
    protected InteractivePoligon profileLeft;
    protected InteractivePoligon profileRight;
    private double[] profile = new double[]{1.0, 0.25, 0.25, 0.25};
    private double p1y = 1.0;
    private double p2x = 0.25;
    private double p2y = 0.25;
    private double p3x = 0.25;
    private double[][] profileData = new double[][]{{0.5, 0.0}, {0.5, this.p1y}, {this.p2x, this.p2y}, {this.p3x, 0.0}};
    public Function diameterFunction;

    public Tank() {
        this.sides = new InteractivePoligon();
        this.inside = new InteractivePoligon();
        this.updateCoordinates();
        this.sides.setConnections(this.sidesConnected);
        this.sides.setClosed(false);
        this.sides.setPointSizeEnableds(sidesEnabled);
        this.sides.addListener(this);
        this.inside.setConnections(insideConnected);
        this.inside.setClosed(true);
        this.inside.getStyle().setEdgeColor(Color.BLUE);
        this.inside.getStyle().setFillPattern(Color.BLUE);
        this.inside.setPointSizeEnableds(insideEnabled);
        this.inside.addListener(this);
        this.level_1 = new InteractiveArrow(1);
        this.level_2 = new InteractiveArrow(1);
        this.level_2.setVisible(false);
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
        this.profileLeft = new InteractivePoligon();
        this.profileRight = new InteractivePoligon();
        this.updateProfiles();
        this.profileLeft.setClosed(true);
        this.profileRight.setClosed(true);
        this.profileLeft.getStyle().setFillPattern(Color.GRAY);
        this.profileRight.getStyle().setFillPattern(Color.GRAY);
        this.profileLeft.setPointSizeEnableds(profileEnabled);
        this.profileRight.setPointSizeEnableds(profileEnabled);
        this.profileLeft.addListener(this);
        this.profileRight.addListener(this);
        super.add(this.inside);
        super.add(this.profileRight);
        super.add(this.profileLeft);
        super.add(this.sides);
        this.setEnabled(this.interactive);
        this.setMovable(this.movable);
        this.setResizable(this.resizable);
        this.setProfilable(this.profilable);
        this.setShowProfiles(this.showProfiles);
        this.diameterFunction = new DiameterFunction();
        this.hasChanged = true;
    }

    public void setWidth(double d) {
        if (d == this.width) {
            return;
        }
        this.width = d;
        this.hasChanged = true;
    }

    public double getWidth() {
        return this.width;
    }

    public void setHeight(double d) {
        if (d == this.height) {
            return;
        }
        this.height = d;
        this.hasChanged = true;
    }

    public double getHeight() {
        return this.height;
    }

    public void setFilled(boolean bl) {
        this.inside.setVisible(bl);
    }

    public boolean isMovable() {
        return this.movable;
    }

    public void setMovable(boolean bl) {
        this.sides.setEnabled(0, bl);
        this.movable = bl;
    }

    public boolean isEnabled() {
        return this.interactive;
    }

    public void setEnabled(boolean bl) {
        this.inside.setEnabled(1, bl);
        this.interactive = bl;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean bl) {
        this.sides.setEnabled(1, bl);
        this.resizable = bl;
    }

    public void setClosedOnTop(boolean bl) {
        if (this.sidesConnected[1] == bl) {
            return;
        }
        this.sidesConnected[1] = bl;
        this.sides.setConnections(this.sidesConnected);
    }

    public void setLineColor(Color color) {
        this.sides.getStyle().setEdgeColor(color);
        this.profileLeft.getStyle().setEdgeColor(color);
        this.profileRight.getStyle().setEdgeColor(color);
    }

    public void setLineStroke(Stroke stroke) {
        this.sides.getStyle().setEdgeStroke(stroke);
    }

    public void setFillColor(Color color) {
        this.inside.getStyle().setEdgeColor(color);
        this.inside.getStyle().setFillPattern(color);
    }

    public void setLevel(double d) {
        if (this.levelOne == d) {
            return;
        }
        this.insideData[3][1] = this.levelOne = d;
        this.insideData[2][1] = this.levelOne;
        this.insideData[1][1] = this.levelOne;
        this.inside.setData(this.insideData);
    }

    public double getLevel() {
        return this.levelOne;
    }

    public boolean isProfilable() {
        return this.profilable;
    }

    public void setProfilable(boolean bl) {
        this.profileLeft.setEnabled(1, bl);
        this.profileRight.setEnabled(1, bl);
        this.profilable = bl;
    }

    public boolean getShowProfiles() {
        return this.showProfiles;
    }

    public void setShowProfiles(boolean bl) {
        boolean bl2 = this.isVisible() && bl;
        this.profileLeft.setVisible(bl2);
        this.profileRight.setVisible(bl2);
        if (this.showProfiles != bl) {
            this.updateProfiles();
        }
        this.showProfiles = bl;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        boolean bl2 = bl && this.showProfiles;
        this.profileLeft.setVisible(bl2);
        this.profileRight.setVisible(bl2);
    }

    public void setProfileColor(Color color) {
        this.profileLeft.getStyle().setFillPattern(color);
        this.profileRight.getStyle().setFillPattern(color);
    }

    public void setProfile(double[] dArray) {
        if (dArray == null || dArray.length < 4) {
            this.p1y = 1.0;
            this.p2x = 0.25;
            this.p2y = 0.25;
            this.p3x = 0.25;
        } else {
            this.p1y = dArray[0];
            this.p2x = dArray[1];
            this.p2y = dArray[2];
            this.p3x = dArray[3];
        }
        this.updateProfiles();
    }

    public double[] getProfile() {
        this.profile[0] = this.p1y;
        this.profile[1] = this.p2x;
        this.profile[2] = this.p2y;
        this.profile[3] = this.p3x;
        return this.profile;
    }

    private void updateCoordinates() {
        this.data = new double[][]{{-this.width / 2.0, 0.0}, {-this.width / 2.0, this.height}, {this.width / 2.0, this.height}, {this.width / 2.0, 0.0}, {0.0, 0.0}, {-this.width / 2.0, 0.0}};
        this.insideData = new double[][]{{-this.width / 2.0, 0.0}, {-this.width / 2.0, this.levelOne}, {0.0, this.levelOne}, {this.width / 2.0, this.levelOne}, {this.width / 2.0, 0.0}};
        this.sides.setData(this.data);
        this.inside.setData(this.insideData);
        this.sides.setData(this.data);
        if (this.showProfiles) {
            this.updateProfiles();
        }
        this.hasChanged = false;
    }

    private void updateProfiles() {
        this.profileData = new double[][]{{this.width / 2.0, 0.0}, {this.width / 2.0, this.p1y * this.height}, {this.width * this.p2x, this.height * this.p2y}, {this.width * this.p3x, 0.0}};
        this.profileRight.setData(this.profileData);
        for (int i = 0; i < 4; ++i) {
            this.profileData[i][0] = -this.profileData[i][0];
        }
        this.profileLeft.setData(this.profileData);
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (this.hasChanged) {
            this.updateCoordinates();
        }
        return super.getObjects3D(drawingPanel3D);
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (this.hasChanged) {
            this.updateCoordinates();
        }
        super.drawQuickly(drawingPanel3D, graphics2D);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.hasChanged) {
            this.updateCoordinates();
        }
        super.draw(drawingPanel, graphics);
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        if (interactionEvent.getSource() == this.profileRight && interactionEvent.getTarget() instanceof InteractionTargetPoligonPoint) {
            InteractionTargetPoligonPoint interactionTargetPoligonPoint = (InteractionTargetPoligonPoint)interactionEvent.getTarget();
            int n = interactionTargetPoligonPoint.getPointIndex();
            switch (n) {
                case 1: {
                    this.p1y = this.height > 0.0 ? this.profileRight.getData()[1][n] / this.height : 0.0;
                    if (!(this.p1y < this.p2y)) break;
                    this.p2y = this.p1y;
                    break;
                }
                case 2: {
                    this.p2x = this.width > 0.0 ? this.profileRight.getData()[0][n] / this.width : 0.0;
                    this.p2y = this.height > 0.0 ? this.profileRight.getData()[1][n] / this.height : 0.0;
                    if (this.p1y < this.p2y) {
                        this.p1y = this.p2y;
                    }
                    if (!(this.p2x < this.p3x)) break;
                    this.p3x = this.p2x;
                    break;
                }
                case 3: {
                    this.p3x = this.width > 0.0 ? this.profileRight.getData()[0][n] / this.width : 0.0;
                    if (!(this.p2x < this.p3x)) break;
                    this.p2x = this.p3x;
                }
            }
        } else if (interactionEvent.getSource() == this.profileLeft && interactionEvent.getTarget() instanceof InteractionTargetPoligonPoint) {
            InteractionTargetPoligonPoint interactionTargetPoligonPoint = (InteractionTargetPoligonPoint)interactionEvent.getTarget();
            int n = interactionTargetPoligonPoint.getPointIndex();
            switch (n) {
                case 1: {
                    this.p1y = this.height > 0.0 ? this.profileLeft.getData()[1][n] / this.height : 0.0;
                    if (!(this.p1y < this.p2y)) break;
                    this.p2y = this.p1y;
                    break;
                }
                case 2: {
                    this.p2x = this.width > 0.0 ? -this.profileLeft.getData()[0][n] / this.width : 0.0;
                    this.p2y = this.height > 0.0 ? this.profileLeft.getData()[1][n] / this.height : 0.0;
                    if (this.p1y < this.p2y) {
                        this.p1y = this.p2y;
                    }
                    if (!(this.p2x < this.p3x)) break;
                    this.p3x = this.p2x;
                    break;
                }
                case 3: {
                    this.p3x = this.width > 0.0 ? -this.profileLeft.getData()[0][n] / this.width : 0.0;
                    if (!(this.p2x < this.p3x)) break;
                    this.p2x = this.p3x;
                }
            }
        } else if (interactionEvent.getSource() == this.sides && interactionEvent.getTarget() instanceof InteractionTargetPoligonPoint) {
            InteractionTargetPoligonPoint interactionTargetPoligonPoint = (InteractionTargetPoligonPoint)interactionEvent.getTarget();
            int n = interactionTargetPoligonPoint.getPointIndex();
            switch (n) {
                case 0: {
                    this.width = -2.0 * this.sides.getData()[0][n];
                    if (!(this.width < 0.0)) break;
                    this.width = 0.0;
                    break;
                }
                case 3: {
                    this.width = 2.0 * this.sides.getData()[0][n];
                    if (!(this.width < 0.0)) break;
                    this.width = 0.0;
                    break;
                }
                case 1: 
                case 2: {
                    this.height = this.sides.getData()[1][n];
                    if (!(this.height < 0.0)) break;
                    this.height = 0.0;
                }
            }
            this.data = new double[][]{{-this.width / 2.0, 0.0}, {-this.width / 2.0, this.height}, {this.width / 2.0, this.height}, {this.width / 2.0, 0.0}, {0.0, 0.0}, {-this.width / 2.0, 0.0}};
            this.sides.setData(this.data);
            this.insideData = new double[][]{{-this.width / 2.0, 0.0}, {-this.width / 2.0, this.levelOne}, {0.0, this.levelOne}, {this.width / 2.0, this.levelOne}, {this.width / 2.0, 0.0}};
            this.inside.setData(this.insideData);
        } else if (interactionEvent.getSource() == this.inside && interactionEvent.getTarget() instanceof InteractionTargetPoligonPoint) {
            InteractionTargetPoligonPoint interactionTargetPoligonPoint = (InteractionTargetPoligonPoint)interactionEvent.getTarget();
            this.levelOne = this.inside.getData()[1][interactionTargetPoligonPoint.getPointIndex()];
            if (this.levelOne < 0.0) {
                this.levelOne = 0.0;
            } else if (this.levelOne > this.height) {
                this.levelOne = this.height;
            }
            this.insideData = new double[][]{{-this.width / 2.0, 0.0}, {-this.width / 2.0, this.levelOne}, {0.0, this.levelOne}, {this.width / 2.0, this.levelOne}, {this.width / 2.0, 0.0}};
            this.inside.setData(this.insideData);
        }
        if (this.showProfiles) {
            if (this.p1y > 1.0) {
                this.p1y = 1.0;
            } else if (this.p1y < 0.0) {
                this.p1y = 0.0;
            }
            if (this.p2y > 1.0) {
                this.p2y = 1.0;
            } else if (this.p2y < 0.0) {
                this.p2y = 0.0;
            }
            if (this.p2x > 0.5) {
                this.p2x = 0.5;
            } else if (this.p2x < 0.0) {
                this.p2x = 0.0;
            }
            if (this.p3x > 0.5) {
                this.p3x = 0.5;
            } else if (this.p3x < 0.0) {
                this.p3x = 0.0;
            }
            this.updateProfiles();
        }
        this.invokeActions(interactionEvent);
    }

    private class DiameterFunction
    extends Function {
        private DiameterFunction() {
        }

        public double eval(double d) {
            if (Tank.this.showProfiles) {
                if (d >= Tank.this.p1y * Tank.this.height) {
                    return Tank.this.width;
                }
                if (d >= Tank.this.p2y * Tank.this.height) {
                    return Tank.this.width + Tank.this.width * (2.0 * Tank.this.p2x - 1.0) * (d - Tank.this.p1y * Tank.this.height) / ((Tank.this.p2y - Tank.this.p1y) * Tank.this.height);
                }
                return 2.0 * (Tank.this.p2x * Tank.this.width + Tank.this.width * (Tank.this.p3x - Tank.this.p2x) * (Tank.this.p2y * Tank.this.height - d) / (Tank.this.p2y * Tank.this.height));
            }
            return Tank.this.width;
        }
    }
}

