/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.automaticcontrol;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import org.opensourcephysics.displayejs.GroupDrawable;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionTargetGroupDrawableElement;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.InteractiveText;

public abstract class PoligonsAndTexts
extends GroupDrawable
implements InteractionListener {
    protected boolean filled = false;
    protected int type = 0;
    protected double angle = 0.0;
    protected double value = 0.0;
    protected double increment = 0.1;
    protected Paint fillPattern = null;
    protected DecimalFormat format = new DecimalFormat("0.000");
    protected boolean hasChanged = false;
    protected boolean showText = true;
    protected boolean showText2 = true;
    protected InteractivePoligon poligon = new InteractivePoligon();
    protected InteractivePoligon poligon2;
    protected InteractiveText text;
    protected InteractiveText text2;
    protected double textX = 0.0;
    protected double textY = 0.0;
    protected double text2X = 0.0;
    protected double text2Y = 0.0;
    protected double[][] data = null;
    protected double[][] data2 = null;
    private double origX = 0.0;
    private double origY = 0.0;
    private double newX = 0.0;
    private double newY = 0.0;

    public PoligonsAndTexts() {
        super.add(this.poligon);
        this.poligon2 = new InteractivePoligon();
        super.add(this.poligon2);
        this.text = new InteractiveText();
        super.add(this.text);
        this.text2 = new InteractiveText();
        super.add(this.text2);
        this.poligon.setClosed(true);
        this.poligon.getStyle().setFillPattern(null);
        this.poligon2.setClosed(true);
        this.poligon2.getStyle().setFillPattern(null);
        this.text.getStyle().setFont(new Font("Dialog", 0, 11));
        this.text2.getStyle().setFont(new Font("Dialog", 0, 11));
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
        this.setFilled(this.filled);
        this.setValue(this.value);
        this.setEnabled(true);
        this.setMovable(false);
        this.addListener(this);
        this.setGroupData();
        this.hasChanged = true;
    }

    public void setType(int n) {
        if (n != this.type) {
            this.type = n;
            this.setGroupData();
        }
    }

    public void setAngle(double d) {
        if (d != this.angle) {
            this.angle = d;
            this.setGroupData();
        }
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
        if (bl) {
            this.poligon.getStyle().setFillPattern(this.fillPattern);
        } else {
            this.poligon.getStyle().setFillPattern(null);
        }
    }

    public void setMovable(boolean bl) {
        this.poligon.setEnabled(0, bl);
        this.poligon2.setEnabled(0, bl);
    }

    public void setLineColor(Color color) {
        this.poligon.getStyle().setEdgeColor(color);
        this.poligon2.getStyle().setEdgeColor(color);
    }

    public void setLineStroke(Stroke stroke) {
        this.poligon.getStyle().setEdgeStroke(stroke);
        this.poligon2.getStyle().setEdgeStroke(stroke);
    }

    public void setFillColor(Paint paint) {
        this.fillPattern = paint;
        if (this.filled) {
            this.poligon.getStyle().setFillPattern(this.fillPattern);
        }
    }

    public void setFillColor2(Paint paint) {
        this.poligon2.getStyle().setFillPattern(paint);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.text.setVisible(this.showText);
            this.text2.setVisible(this.showText2);
        }
    }

    public InteractiveElement getText() {
        return this.text;
    }

    public void setShowText(boolean bl) {
        this.showText = bl;
        this.text.setVisible(this.showText);
    }

    public void setShowSecondText(boolean bl) {
        this.showText2 = bl;
        this.text2.setVisible(this.showText2);
    }

    public void setText(String string) {
        this.text.getStyle().setDisplayObject(string);
    }

    public void setText2(String string) {
        this.text2.getStyle().setDisplayObject(string);
    }

    public void setTextColor(Color color) {
        this.text.getStyle().setEdgeColor(color);
        this.text2.getStyle().setEdgeColor(color);
    }

    public void setTextFont(Font font) {
        this.text.getStyle().setFont(font);
        this.text2.getStyle().setFont(font);
    }

    public void setEnabled(boolean bl) {
        this.text.setEnabled(0, bl);
    }

    public void setValue(double d) {
        if (this.value == d) {
            return;
        }
        this.value = d;
        this.text.getStyle().setDisplayObject(this.format.format(this.value));
    }

    public double getValue() {
        return this.value;
    }

    public void setValueIncrement(double d) {
        this.increment = d;
    }

    public double getValueIncrement() {
        return this.increment;
    }

    public void setValueFormat(DecimalFormat decimalFormat) {
        if (this.format == decimalFormat) {
            return;
        }
        this.format = decimalFormat;
        this.text.getStyle().setDisplayObject(this.format.format(this.value));
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        if (interactionEvent.getTarget() instanceof InteractionTargetGroupDrawableElement && ((InteractionTargetGroupDrawableElement)interactionEvent.getTarget()).getElement() == this.text) {
            switch (interactionEvent.getID()) {
                case 2000: {
                    this.origX = this.newX = this.getX();
                    this.origY = this.newY = this.getY();
                    break;
                }
                case 2001: {
                    double d = this.getX();
                    double d2 = this.getY();
                    this.value = Math.abs(d - this.newX) > Math.abs(d2 - this.newY) ? (this.value += (d - this.newX) / this.getRadius() / this.getSizeX() * this.increment) : (this.value += (d2 - this.newY) / this.getRadius() / this.getSizeY() * this.increment);
                    this.setXY(this.origX, this.origY);
                    this.newX = d;
                    this.newY = d2;
                    this.text.getStyle().setDisplayObject(this.format.format(this.value));
                }
            }
        }
    }

    protected abstract double getRadius();

    protected abstract void setGroupData();

    protected void rotateData() {
        double d;
        int n;
        int n2;
        double d2 = Math.cos(this.angle);
        double d3 = Math.sin(this.angle);
        if (this.data != null) {
            n2 = this.data.length;
            for (n = 0; n < n2; ++n) {
                d = d2 * this.data[n][0] - d3 * this.data[n][1];
                this.data[n][1] = d3 * this.data[n][0] + d2 * this.data[n][1];
                this.data[n][0] = d;
            }
        }
        if (this.data2 != null) {
            n2 = this.data2.length;
            for (n = 0; n < n2; ++n) {
                d = d2 * this.data2[n][0] - d3 * this.data2[n][1];
                this.data2[n][1] = d3 * this.data2[n][0] + d2 * this.data2[n][1];
                this.data2[n][0] = d;
            }
        }
        d = d2 * this.textX - d3 * this.textY;
        this.textY = d3 * this.textX + d2 * this.textY;
        this.textX = d;
        d = d2 * this.text2X - d3 * this.text2Y;
        this.text2Y = d3 * this.text2X + d2 * this.text2Y;
        this.text2X = d;
    }
}

