/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.HighlightableDataset;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DatasetTab;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

public class DatasetTool
extends OSPFrame
implements Tool {
    public static boolean loadClass = false;
    protected static JFileChooser chooser;
    protected static OSPLog log;
    protected static Dimension dim;
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControl control = new XMLControlElement();
    protected JobManager jobManager = new JobManager(this);
    protected JMenu addMenu;
    protected JMenu subtractMenu;
    protected JMenu multiplyMenu;
    protected JMenu divideMenu;
    JMenu fileMenu;
    JMenuItem openItem;
    JMenuItem closeItem;
    JMenuItem closeAllItem;
    JMenuItem printItem;
    JMenuItem exitItem;
    JMenu editMenu;
    JMenu copyMenu;
    JMenuItem copyImageItem;
    JMenuItem copyXMLItem;
    JMenuItem pasteItem;
    JMenu helpMenu;
    JMenuItem logItem;
    JMenuItem aboutItem;
    static final DatasetTool DATASET_TOOL;

    public static DatasetTool getTool() {
        return DATASET_TOOL;
    }

    public DatasetTool() {
        super(ToolsRes.getString("Frame.Title"));
        String string = "DatasetTool";
        this.setName(string);
        this.createGUI();
        Toolbox.addTool(string, this);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DatasetTool.this.refreshGUI();
            }
        });
    }

    public DatasetTool(String string) {
        this();
        this.open(string);
    }

    public DatasetTool(Dataset dataset) {
        this();
        this.addTab(dataset);
    }

    public DatasetTool(XMLControl xMLControl) {
        this();
        this.loadDatasets(xMLControl);
    }

    public String open(String string) {
        OSPLog.fine("opening " + string);
        XMLControlElement xMLControlElement = new XMLControlElement(string);
        if (!this.loadDatasets(xMLControlElement).isEmpty()) {
            return string;
        }
        OSPLog.finest("no datasets found");
        return null;
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == Object.class) {
            return;
        }
        this.jobManager.log(job, tool);
        Collection collection = this.loadDatasets(xMLControlElement);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.jobManager.associate(job, iterator.next());
        }
    }

    public void setUseChooser(boolean bl) {
        this.useChooser = bl;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    public Collection loadDatasets(XMLControl xMLControl) {
        return this.loadDatasets(xMLControl, this.useChooser);
    }

    public Collection loadDatasets(XMLControl xMLControl, boolean bl) {
        List list;
        Iterator iterator;
        HashSet<Dataset> hashSet = new HashSet<Dataset>();
        if (bl) {
            iterator = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), this);
            list = ((XMLTreeChooser)((Object)iterator)).choose(xMLControl, Dataset.class);
        } else {
            iterator = new XMLTree(xMLControl);
            ((XMLTree)((Object)iterator)).setHighlightedClass(Dataset.class);
            ((XMLTree)((Object)iterator)).selectHighlightedProperties();
            list = ((XMLTree)((Object)iterator)).getSelectedProperties();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
        }
        if (!list.isEmpty()) {
            for (XMLControl xMLControl2 : list) {
                Dataset dataset = null;
                if (xMLControl2 instanceof XMLControlElement) {
                    XMLControlElement xMLControlElement = (XMLControlElement)xMLControl2;
                    dataset = (Dataset)xMLControlElement.loadObject(null, true, true);
                } else {
                    dataset = (Dataset)xMLControl2.loadObject(null);
                }
                this.addTab(dataset);
                hashSet.add(dataset);
            }
        }
        return hashSet;
    }

    public Collection getDatasets() {
        HashSet<Dataset> hashSet = new HashSet<Dataset>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            hashSet.add(datasetTab.getDataset());
        }
        return hashSet;
    }

    public Dataset getSelectedDataset() {
        DatasetTab datasetTab = this.getSelectedTab();
        if (datasetTab != null) {
            return datasetTab.getDataset();
        }
        return null;
    }

    public boolean addTab(Dataset dataset) {
        int n = this.getTabIndex(dataset);
        if (n >= 0) {
            this.tabbedPane.setSelectedIndex(n);
            double[] dArray = dataset.getXPoints();
            double[] dArray2 = dataset.getYPoints();
            DatasetTab datasetTab = this.getSelectedTab();
            datasetTab.original.setName(dataset.getName());
            datasetTab.dataset.clear();
            datasetTab.dataset.append(dArray, dArray2);
            datasetTab.dataset.setName(dataset.getName());
            datasetTab.dataTable.tableChanged(null);
            datasetTab.refresh();
            this.refreshTabTitles();
            return false;
        }
        final DatasetTab datasetTab = new DatasetTab(dataset);
        datasetTab.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (!datasetTab.fitCheckBox.isSelected()) {
                    datasetTab.splitPanes[1].setDividerLocation(1.0);
                }
                if (!datasetTab.statsCheckBox.isSelected()) {
                    datasetTab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        String string = GUIUtils.removeSubscripting(dataset.getColumnName(0));
        String string2 = GUIUtils.removeSubscripting(dataset.getColumnName(1));
        String string3 = dataset.getName() + " (" + string + ", " + string2 + ")";
        OSPLog.finer("adding tab " + string3);
        this.tabbedPane.addTab(string3, datasetTab);
        this.tabbedPane.setSelectedComponent(datasetTab);
        datasetTab.dataTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                DatasetTool.this.refreshTabTitles();
            }
        });
        this.validate();
        datasetTab.init();
        datasetTab.refresh();
        this.refreshTabTitles();
        return true;
    }

    protected DatasetTab getSelectedTab() {
        return (DatasetTab)this.tabbedPane.getSelectedComponent();
    }

    protected String open() {
        int n = OSPRuntime.getChooser().showOpenDialog(null);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string = XML.getRelativePath(string);
            return this.open(string);
        }
        return null;
    }

    protected int getTabIndex(Dataset dataset) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            Dataset dataset2 = datasetTab.getDataset();
            if (dataset2 != dataset && dataset2.getID() != dataset.getID()) continue;
            return i;
        }
        return -1;
    }

    protected Dataset getDataset(int n) {
        if (n < 0 || n >= this.tabbedPane.getTabCount()) {
            return null;
        }
        DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(n);
        return datasetTab.getDataset();
    }

    public void updateData(Dataset dataset) {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Dataset dataset2 = ((DatasetTab)this.tabbedPane.getComponentAt(i)).getDataset();
            if (dataset2 != dataset) continue;
            ((DatasetTab)this.tabbedPane.getComponentAt(i)).updateData();
        }
    }

    protected void removeTab(int n) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(n);
            this.refreshTabTitles();
        }
    }

    protected void removeAllButTab(int n) {
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            if (i == n) continue;
            String string = this.tabbedPane.getTitleAt(i);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(i);
        }
        this.refreshTabTitles();
    }

    protected void removeAllTabs() {
        for (int i = this.tabbedPane.getTabCount() - 1; i >= 0; --i) {
            String string = this.tabbedPane.getTitleAt(i);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(i);
        }
    }

    protected void refreshTabTitles() {
        int n;
        String[] stringArray = new String[this.tabbedPane.getTabCount()];
        String[] stringArray2 = new String[this.tabbedPane.getTabCount()];
        boolean bl = true;
        for (n = 0; n < stringArray.length; ++n) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(n);
            HighlightableDataset highlightableDataset = datasetTab.displayData;
            String string = GUIUtils.removeSubscripting(highlightableDataset.getColumnName(0));
            String string2 = GUIUtils.removeSubscripting(highlightableDataset.getColumnName(1));
            stringArray[n] = "(" + string + ", " + string2 + ")";
            stringArray2[n] = highlightableDataset.getName();
            if (stringArray2[n] == null || stringArray2[n].equals("")) {
                stringArray2[n] = ToolsRes.getString("Dataset.Name.Default");
            }
            bl = bl && stringArray2[n].equals(stringArray2[0]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (bl && stringArray2[n] == ToolsRes.getString("Dataset.Name.Default")) continue;
            stringArray[n] = stringArray2[n] + " " + stringArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.tabbedPane.setTitleAt(n, stringArray[n]);
        }
    }

    protected void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        this.setDefaultCloseOperation(1);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DatasetTab datasetTab = DatasetTool.this.getSelectedTab();
                if (datasetTab == null) {
                    return;
                }
                if (!datasetTab.fitCheckBox.isSelected()) {
                    datasetTab.splitPanes[1].setDividerLocation(1.0);
                }
                if (!datasetTab.statsCheckBox.isSelected()) {
                    datasetTab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        this.contentPane.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3 || mouseEvent.isControlDown() && System.getProperty("os.name", "").indexOf("Mac") > -1) {
                    final int n = DatasetTool.this.tabbedPane.getSelectedIndex();
                    DatasetTab datasetTab = (DatasetTab)DatasetTool.this.tabbedPane.getComponentAt(n);
                    final HighlightableDataset highlightableDataset = datasetTab.displayData;
                    String string = GUIUtils.removeSubscripting(highlightableDataset.getColumnName(0));
                    String string2 = GUIUtils.removeSubscripting(highlightableDataset.getColumnName(1));
                    final String string3 = string + ", " + string2;
                    JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DatasetTool.this.removeTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DatasetTool.this.removeAllButTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DatasetTool.this.removeAllTabs();
                        }
                    });
                    ArrayList<String> arrayList = new ArrayList<String>();
                    final String string4 = ToolsRes.getString("Dataset.Name.Default");
                    for (int i = 0; i < DatasetTool.this.tabbedPane.getTabCount(); ++i) {
                        if (i == n) continue;
                        datasetTab = (DatasetTab)DatasetTool.this.tabbedPane.getComponentAt(i);
                        HighlightableDataset highlightableDataset2 = datasetTab.displayData;
                        if (!highlightableDataset2.getColumnName(0).equals(highlightableDataset.getColumnName(0))) continue;
                        arrayList.add(String.valueOf(i));
                    }
                    if (!arrayList.isEmpty()) {
                        AbstractAction abstractAction = new AbstractAction(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Object object;
                                int n = Integer.parseInt(actionEvent.getActionCommand());
                                DatasetTab datasetTab = (DatasetTab)DatasetTool.this.tabbedPane.getComponentAt(n);
                                HighlightableDataset highlightableDataset2 = datasetTab.displayData;
                                String string = highlightableDataset.getName();
                                String string2 = highlightableDataset2.getName();
                                String string32 = GUIUtils.removeSubscripting(highlightableDataset.getColumnName(1));
                                String string42 = GUIUtils.removeSubscripting(highlightableDataset2.getColumnName(1));
                                if (string == null || string.equals("")) {
                                    string = string4;
                                }
                                if (string2 == null || string2.equals("")) {
                                    string2 = string4;
                                }
                                if (string.indexOf(" - ") > -1 || string.indexOf(" + ") > -1 || string.indexOf(" * ") > -1 || string.indexOf(" / ") > -1) {
                                    string = "(" + string + ")";
                                }
                                if (string32.indexOf("-") > -1 || string32.indexOf("+") > -1 || string32.indexOf("*") > -1 || string32.indexOf("/") > -1) {
                                    string32 = "(" + string32 + ")";
                                }
                                if (string2.indexOf(" - ") > -1 || string2.indexOf(" + ") > -1 || string2.indexOf(" * ") > -1 || string2.indexOf(" / ") > -1) {
                                    string2 = "(" + string2 + ")";
                                }
                                if (string42.indexOf("-") > -1 || string42.indexOf("+") > -1 || string42.indexOf("*") > -1 || string42.indexOf("/") > -1) {
                                    string42 = "(" + string42 + ")";
                                }
                                String string5 = "";
                                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                                if (jMenuItem.getParent() == DatasetTool.this.addMenu.getPopupMenu()) {
                                    string5 = "+";
                                }
                                if (jMenuItem.getParent() == DatasetTool.this.subtractMenu.getPopupMenu()) {
                                    string5 = "-";
                                } else if (jMenuItem.getParent() == DatasetTool.this.multiplyMenu.getPopupMenu()) {
                                    string5 = "*";
                                } else if (jMenuItem.getParent() == DatasetTool.this.divideMenu.getPopupMenu()) {
                                    string5 = "/";
                                }
                                String string6 = string;
                                if (!string.equals(string2)) {
                                    string6 = string6 + " " + string5 + " " + string2;
                                }
                                String string7 = string32 + string5 + string42;
                                for (int i = 0; i < DatasetTool.this.tabbedPane.getTabCount(); ++i) {
                                    datasetTab = (DatasetTab)DatasetTool.this.tabbedPane.getComponentAt(i);
                                    object = GUIUtils.removeSubscripting(datasetTab.dataset.getColumnName(0));
                                    if (!string6.equals(datasetTab.dataset.getName()) || !string3.equals((String)object + ", " + string7)) continue;
                                    DatasetTool.this.tabbedPane.setSelectedIndex(i);
                                    DatasetTool.this.getSelectedTab().dataTable.tableChanged(null);
                                    DatasetTool.this.getSelectedTab().refresh();
                                    DatasetTool.this.refreshTabTitles();
                                    return;
                                }
                                double[] dArray = highlightableDataset.getXPoints();
                                object = highlightableDataset.getYPoints();
                                double[] dArray2 = highlightableDataset2.getXPoints();
                                double[] dArray3 = highlightableDataset2.getYPoints();
                                int n2 = Math.min(((double[])object).length, dArray3.length);
                                Dataset dataset = new Dataset();
                                for (int i = 0; i < n2; ++i) {
                                    if (dArray[i] != dArray2[i]) continue;
                                    if (string5.equals("+")) {
                                        dataset.append(dArray[i], object[i] + dArray3[i]);
                                        continue;
                                    }
                                    if (string5.equals("-")) {
                                        dataset.append(dArray[i], object[i] - dArray3[i]);
                                        continue;
                                    }
                                    if (string5.equals("*")) {
                                        dataset.append(dArray[i], object[i] * dArray3[i]);
                                        continue;
                                    }
                                    if (!string5.equals("/")) continue;
                                    dataset.append(dArray[i], object[i] / dArray3[i]);
                                }
                                if (dataset.getRowCount() > 0) {
                                    if (!string6.equals(string4)) {
                                        dataset.setName(string6);
                                    }
                                    dataset.setXYColumnNames(highlightableDataset.getColumnName(0), highlightableDataset.getColumnName(1) + string5 + highlightableDataset2.getColumnName(1));
                                    dataset.setMarkerShape(highlightableDataset.getMarkerShape());
                                    dataset.setMarkerSize(highlightableDataset.getMarkerSize());
                                    dataset.setConnected(highlightableDataset.isConnected());
                                    dataset.setLineColor(highlightableDataset.getLineColor());
                                    dataset.setMarkerColor(highlightableDataset.getFillColor(), highlightableDataset.getEdgeColor());
                                    DatasetTool.this.addTab(dataset);
                                } else {
                                    String string8 = ToolsRes.getString("Dialog.AddFailed.Title");
                                    if (jMenuItem.getParent() == DatasetTool.this.subtractMenu.getPopupMenu()) {
                                        string8 = ToolsRes.getString("Dialog.SubtractFailed.Title");
                                    } else if (jMenuItem.getParent() == DatasetTool.this.divideMenu.getPopupMenu()) {
                                        string8 = ToolsRes.getString("Dialog.DivideFailed.Title");
                                    }
                                    JOptionPane.showMessageDialog(DatasetTool.this.tabbedPane, ToolsRes.getString("Dialog.OperationFailed.Message"), string8, 2);
                                }
                            }
                        };
                        DatasetTool.this.addMenu = new JMenu(ToolsRes.getString("Menu.Add"));
                        DatasetTool.this.subtractMenu = new JMenu(ToolsRes.getString("Menu.Subtract"));
                        DatasetTool.this.multiplyMenu = new JMenu(ToolsRes.getString("Menu.MultiplyBy"));
                        DatasetTool.this.divideMenu = new JMenu(ToolsRes.getString("Menu.DivideBy"));
                        jPopupMenu.addSeparator();
                        jPopupMenu.add(DatasetTool.this.addMenu);
                        jPopupMenu.add(DatasetTool.this.subtractMenu);
                        jPopupMenu.add(DatasetTool.this.multiplyMenu);
                        jPopupMenu.add(DatasetTool.this.divideMenu);
                        for (String string5 : arrayList) {
                            int n2 = Integer.parseInt(string5);
                            jMenuItem = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string5);
                            jMenuItem.addActionListener(abstractAction);
                            DatasetTool.this.addMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string5);
                            jMenuItem.addActionListener(abstractAction);
                            DatasetTool.this.subtractMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string5);
                            jMenuItem.addActionListener(abstractAction);
                            DatasetTool.this.multiplyMenu.add(jMenuItem);
                            jMenuItem = new JMenuItem(DatasetTool.this.tabbedPane.getTitleAt(n2));
                            jMenuItem.setActionCommand(string5);
                            jMenuItem.addActionListener(abstractAction);
                            DatasetTool.this.divideMenu.add(jMenuItem);
                        }
                    }
                    jPopupMenu.show(DatasetTool.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        jMenuBar.add(this.fileMenu);
        this.openItem = new JMenuItem();
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTool.this.open();
            }
        });
        this.fileMenu.add(this.openItem);
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DatasetTool.this.tabbedPane.getSelectedIndex();
                DatasetTool.this.removeTab(n);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTool.this.removeAllTabs();
            }
        });
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().printImage(DatasetTool.this);
            }
        });
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTool.this.removeAllTabs();
                System.exit(0);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu();
        this.editMenu.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!DatasetTool.this.editMenu.isPopupMenuVisible()) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        DatasetTool.this.control.readXML((String)transferable.getTransferData(DataFlavor.stringFlavor));
                        DatasetTool.this.pasteItem.setEnabled(!DatasetTool.this.control.failedToRead());
                    }
                    catch (Exception exception) {
                        DatasetTool.this.pasteItem.setEnabled(false);
                    }
                } else {
                    DatasetTool.this.pasteItem.setEnabled(false);
                }
            }
        });
        jMenuBar.add(this.editMenu);
        this.copyMenu = new JMenu();
        this.editMenu.add(this.copyMenu);
        this.copyImageItem = new JMenuItem();
        this.copyImageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().copyImage(DatasetTool.this);
            }
        });
        this.copyImageItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
        this.copyMenu.add(this.copyImageItem);
        this.copyXMLItem = new JMenuItem();
        this.copyXMLItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Dataset dataset = DatasetTool.this.getSelectedDataset();
                if (dataset == null) {
                    return;
                }
                int n = DatasetTool.this.tabbedPane.getSelectedIndex();
                String string = DatasetTool.this.tabbedPane.getTitleAt(n);
                OSPLog.finest("copying " + string);
                XMLControlElement xMLControlElement = new XMLControlElement(dataset);
                StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        this.copyMenu.add(this.copyXMLItem);
        this.pasteItem = new JMenuItem();
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string != null) {
                        XMLControlElement xMLControlElement = new XMLControlElement();
                        xMLControlElement.readXML(string);
                        if (!xMLControlElement.failedToRead()) {
                            OSPLog.finest("pasting");
                        }
                        if (DatasetTool.this.loadDatasets(xMLControlElement).isEmpty()) {
                            OSPLog.finest("no datasets found");
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, n));
        this.editMenu.add(this.pasteItem);
        this.helpMenu = new JMenu();
        jMenuBar.add(this.helpMenu);
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DatasetTool.log.getLocation().x == 0 && DatasetTool.log.getLocation().y == 0) {
                    Point point = DatasetTool.this.getLocation();
                    log.setLocation(point.x + 28, point.y + 28);
                }
                log.setVisible(true);
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasetTool.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(jMenuBar);
        this.refreshGUI();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (dimension.width - this.getBounds().width) / 2;
        int n3 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n2, n3);
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("Frame.Title"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.openItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.closeItem.setText(ToolsRes.getString("MenuItem.Close"));
        this.closeAllItem.setText(ToolsRes.getString("MenuItem.CloseAll"));
        this.printItem.setText(ToolsRes.getString("DatasetTool.MenuItem.Print"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.editMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.copyMenu.setText(ToolsRes.getString("DatasetTool.Menu.Copy"));
        this.copyImageItem.setText(ToolsRes.getString("DatasetTool.MenuItem.CopyImage"));
        this.copyXMLItem.setText(ToolsRes.getString("DatasetTool.MenuItem.CopyXML"));
        this.pasteItem.setText(ToolsRes.getString("MenuItem.Paste"));
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            DatasetTab datasetTab = (DatasetTab)this.tabbedPane.getComponentAt(i);
            datasetTab.refreshGUI();
        }
    }

    protected void showAboutDialog() {
        String string = this.getName() + " 1.0  Jan 2006\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, string, ToolsRes.getString("Dialog.About.Title") + " " + this.getName(), 1);
    }

    public static void main(String[] stringArray) {
        DatasetTool datasetTool = DatasetTool.getTool();
        datasetTool.setVisible(true);
    }

    static {
        log = OSPLog.getOSPLog();
        dim = new Dimension(720, 500);
        DATASET_TOOL = new DatasetTool();
    }
}

