/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode.IRK;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.ode.IRK.AlgebraicEquationSimpleSolver;
import org.opensourcephysics.ode.IRK.IRKAlgebraicEquation;
import org.opensourcephysics.ode.IRK.IRKSimplifiedNewtonStep;

public class Radau5Light
implements ODESolver {
    protected ODE ode;
    protected double stepSize = 1.0E-6;
    protected int numEqn;
    protected int jacobianAge = 0;
    private int nSteps = 0;
    protected double[] state;
    protected double[] rate;
    protected double[][] intermediateStagesIncrement;
    protected AlgebraicEquationSimpleSolver aeSolver;
    protected static int maxNewtonIterations = 7;

    public Radau5Light(ODE oDE) {
        this.ode = oDE;
        this.state = oDE.getState();
        this.numEqn = this.state.length;
        this.rate = new double[this.numEqn];
        this.intermediateStagesIncrement = new double[3][this.numEqn];
        this.aeSolver = this.getInnerSolver(new DifferenceSchemeEquation(this.numEqn));
    }

    protected AlgebraicEquationSimpleSolver getInnerSolver(IRKAlgebraicEquation iRKAlgebraicEquation) {
        return new IRKSimplifiedNewtonStep(iRKAlgebraicEquation);
    }

    protected void preStepPreparations() {
        this.ode.getRate(this.state, this.rate);
    }

    protected void performStep() {
        double d = 0.0;
        for (int i = 0; i < maxNewtonIterations; ++i) {
            d += this.aeSolver.resolve() / (double)maxNewtonIterations;
        }
        this.aeSolver.restart(d > 0.001);
    }

    protected void commitStepResults() {
        for (int i = 0; i < this.numEqn; ++i) {
            int n = i;
            this.state[n] = this.state[n] + this.intermediateStagesIncrement[2][i];
        }
    }

    public double step() {
        this.preStepPreparations();
        this.commitStepResults();
        this.aeSolver.restart(++this.nSteps % 4 == 0);
        return this.stepSize;
    }

    public void setStepSize(double d) {
        this.stepSize = d;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void initialize(double d) {
    }

    protected class DifferenceSchemeEquation
    implements IRKAlgebraicEquation {
        private double[] realEigenvalues = new double[]{3.6378342527444962};
        private double[] complexEigenvalues = new double[]{2.6810828736277523, 3.0504301992474105};
        private double[][] T = new double[][]{{0.09123239487089295, -0.1412552950209542, -0.030029194105147424}, {0.241717932707107, 0.20412935229379994, 0.3829421127572619}, {0.966048182615093, 1.0, 0.0}};
        private double[][] inverseT = new double[][]{{4.325579890063155, 0.33919925181580984, 0.5417705399358749}, {-4.178718591551905, -0.32768282076106237, 0.47662355450055044}, {-0.5028726349457868, 2.571926949855605, -0.5960392048282249}};
        private int nStgs = 3;
        private double[] someState;
        private double[] someRate;
        double uRound = 2.220446049250313E-16;

        public void evaluate(double[][] dArray, double[][] dArray2) {
            int n;
            int n2;
            int n3;
            double[][] dArray3 = new double[3][3];
            double[][] dArray4 = new double[3][3];
            dArray3[0][0] = this.realEigenvalues[0];
            dArray3[1][1] = this.complexEigenvalues[0];
            dArray3[1][2] = -this.complexEigenvalues[1];
            dArray3[2][1] = this.complexEigenvalues[1];
            dArray3[2][2] = this.complexEigenvalues[0];
            for (n3 = 0; n3 < 3; ++n3) {
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray4[n3][n2] = 0.0;
                    for (n = 0; n < 3; ++n) {
                        double[] dArray5 = dArray4[n3];
                        int n4 = n2;
                        dArray5[n4] = dArray5[n4] + this.T[n3][n] * dArray3[n][n2];
                    }
                }
            }
            for (n3 = 0; n3 < 3; ++n3) {
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray3[n3][n2] = 0.0;
                    for (n = 0; n < 3; ++n) {
                        double[] dArray6 = dArray3[n3];
                        int n5 = n2;
                        dArray6[n5] = dArray6[n5] + dArray4[n3][n] * this.inverseT[n][n2];
                    }
                }
            }
            double[][] dArray7 = new double[3][Radau5Light.this.numEqn];
            for (n2 = 0; n2 < 3; ++n2) {
                this.evaluateNonLinearComponent(dArray[n2], dArray7[n2]);
            }
            for (n2 = 0; n2 < Radau5Light.this.numEqn; ++n2) {
                for (n = 0; n < 3; ++n) {
                    for (int i = 0; i < 3; ++i) {
                        dArray2[n][n2] = dArray3[n][i] * dArray7[i][n2];
                    }
                }
            }
            for (n2 = 0; n2 < Radau5Light.this.numEqn; ++n2) {
                for (n = 0; n < 3; ++n) {
                    double[] dArray8 = dArray2[n];
                    int n6 = n2;
                    dArray8[n6] = dArray8[n6] - dArray[n][n2] / Radau5Light.this.stepSize;
                }
            }
        }

        public DifferenceSchemeEquation(int n) {
            this.someState = new double[n];
            this.someRate = new double[n];
        }

        public double[][] getApproximation() {
            return Radau5Light.this.intermediateStagesIncrement;
        }

        public double[] getComplexEigenvalues() {
            return this.complexEigenvalues;
        }

        public double[] getRealEigenvalues() {
            return this.realEigenvalues;
        }

        public double getScalarMultiplier() {
            return 1.0 / Radau5Light.this.stepSize;
        }

        public void evaluateNonLinearComponent(double[] dArray, double[] dArray2) {
            for (int i = 0; i < Radau5Light.this.numEqn; ++i) {
                this.someState[i] = Radau5Light.this.state[i] + dArray[i];
            }
            Radau5Light.this.ode.getRate(this.someState, dArray2);
        }

        public void evaluateNonLinearComponentJacobian(double[] dArray, double[][] dArray2) {
            System.arraycopy(Radau5Light.this.state, 0, this.someState, 0, Radau5Light.this.numEqn);
            for (int i = 0; i < Radau5Light.this.numEqn; ++i) {
                double d = Math.sqrt(this.uRound * Math.max(1.0E-5, Math.abs(Radau5Light.this.state[i])));
                int n = i;
                this.someState[n] = this.someState[n] + d;
                Radau5Light.this.ode.getRate(this.someState, this.someRate);
                int n2 = i;
                this.someState[n2] = this.someState[n2] - d;
                for (int j = 0; j < Radau5Light.this.numEqn; ++j) {
                    dArray2[j][i] = (this.someRate[j] - Radau5Light.this.rate[j]) / d;
                }
            }
            Radau5Light.this.jacobianAge = 0;
        }

        public void directChangeOfVariables(double[][] dArray, double[][] dArray2) {
            for (int i = 0; i < Radau5Light.this.numEqn; ++i) {
                for (int j = 0; j < this.nStgs; ++j) {
                    dArray2[j][i] = 0.0;
                    for (int k = 0; k < this.nStgs; ++k) {
                        double[] dArray3 = dArray2[j];
                        int n = i;
                        dArray3[n] = dArray3[n] + this.inverseT[j][k] * dArray[k][i];
                    }
                }
            }
        }

        public void inverseChangeOfVariables(double[][] dArray, double[][] dArray2) {
            for (int i = 0; i < Radau5Light.this.numEqn; ++i) {
                for (int j = 0; j < this.nStgs; ++j) {
                    dArray2[j][i] = 0.0;
                    for (int k = 0; k < this.nStgs; ++k) {
                        double[] dArray3 = dArray2[j];
                        int n = i;
                        dArray3[n] = dArray3[n] + this.T[j][k] * dArray[k][i];
                    }
                }
            }
        }
    }
}

