/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ode;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.ode.ODEInterpolator;

public abstract class ExplicitRKSolver
implements ODEInterpolator {
    int error_code = 0;
    protected int nStages;
    protected int methodOrder;
    protected double[][] a;
    protected double[] b;
    protected double stepSize = 0.1;
    protected double takenStepSize = 0.0;
    protected double tolerance = 1.0E-6;
    protected int numEqn = 0;
    protected double[] state;
    protected double[] initialState;
    protected double[][] intermidiateStages;
    protected ODE ode;
    private double errOld = 1.0E-4;
    private double fac = 0.0;
    protected boolean interpolationIsValid = false;
    protected int nInterpolationStages;

    public ExplicitRKSolver(ODE oDE, double[][] dArray, double[] dArray2, int n, int n2, int n3) {
        this.nInterpolationStages = n3;
        this.nStages = n2;
        this.methodOrder = n;
        this.a = dArray;
        this.b = dArray2;
        this.ode = oDE;
        this.state = this.ode.getState();
        this.numEqn = this.state.length;
        this.initialState = new double[this.numEqn];
        this.intermidiateStages = new double[n2 + n3][this.numEqn];
    }

    public void initialize(double d) {
        this.stepSize = d;
        this.interpolationIsValid = false;
        if (this.state != this.ode.getState()) {
            this.state = this.ode.getState();
            this.numEqn = this.state.length;
            this.initialState = new double[this.numEqn];
            this.intermidiateStages = new double[this.nStages + this.nInterpolationStages][this.numEqn];
        }
    }

    public final double step() {
        this.error_code = 0;
        this.interpolationIsValid = false;
        if (this.state.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        double d = 0.0;
        int n = 500;
        if (this.takenStepSize == 0.0) {
            this.stepSize = this.getInitialStepSize(this.stepSize);
        }
        System.arraycopy(this.state, 0, this.initialState, 0, this.numEqn);
        this.ode.getRate(this.state, this.intermidiateStages[0]);
        do {
            int n2;
            int n3;
            --n;
            this.takenStepSize = this.stepSize;
            for (n3 = 1; n3 < this.nStages; ++n3) {
                for (n2 = 0; n2 < this.numEqn; ++n2) {
                    this.state[n2] = this.initialState[n2];
                    for (int i = 0; i < n3; ++i) {
                        int n4 = n2;
                        this.state[n4] = this.state[n4] + this.stepSize * this.a[n3 - 1][i] * this.intermidiateStages[i][n2];
                    }
                }
                this.ode.getRate(this.state, this.intermidiateStages[n3]);
            }
            for (n2 = 0; n2 < this.numEqn; ++n2) {
                this.state[n2] = this.initialState[n2];
                for (n3 = 0; n3 < this.nStages; ++n3) {
                    int n5 = n2;
                    this.state[n5] = this.state[n5] + this.stepSize * this.b[n3] * this.intermidiateStages[n3][n2];
                }
            }
            d = this.estimateError();
            this.stepSize = this.estimateStepSize(d);
            if (n >= 499) continue;
            this.stepSize = Math.min(this.stepSize, this.takenStepSize);
        } while (d > 1.0 && n > 0);
        if (d > 1.0 || Double.isNaN(d)) {
            System.err.println("Method did not converge");
            this.error_code = 1;
        }
        return this.takenStepSize;
    }

    public int getErrorCode() {
        return this.error_code;
    }

    protected abstract double estimateError();

    private double estimateStepSize(double d) {
        double d2 = 0.33;
        double d3 = 6.0;
        double d4 = 0.0;
        double d5 = 0.9;
        double d6 = 1.0 / (double)this.methodOrder - d4 * 0.75;
        double d7 = 0.0;
        double d8 = 0.0;
        if (d != 0.0) {
            d8 = Math.exp(d6 * Math.log(d));
            this.fac = d8 / Math.exp(d4 * Math.log(this.errOld));
            this.fac = Math.max(1.0 / d3, Math.min(1.0 / d2, this.fac / d5));
        } else {
            d8 = 1.0 / d2;
            this.fac = 1.0 / d3;
        }
        if (d <= 1.0) {
            this.errOld = Math.max(d, 1.0E-4);
            d7 = this.stepSize / this.fac;
        } else {
            d7 = this.stepSize / Math.min(1.0 / d2, d8 / d5);
        }
        return d7;
    }

    public double getInitialStepSize(double d) {
        double d2;
        int n;
        double[] dArray = this.state;
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray2.length];
        double[] dArray4 = new double[dArray2.length];
        int n2 = d < 0.0 ? -1 : 1;
        d = Math.abs(d);
        this.ode.getRate(dArray, dArray4);
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.numEqn; ++n) {
            d2 = this.tolerance + this.tolerance * Math.abs(dArray[n]);
            d3 += Math.pow(dArray4[n] / d2, 2.0);
            d4 += Math.pow(dArray[n] / d2, 2.0);
        }
        double d5 = d3 <= 1.0E-10 || d4 <= 1.0E-10 ? 1.0E-6 : Math.sqrt(d4 / d3) * 0.01;
        d5 = (double)n2 * Math.min(d5, d);
        for (n = 0; n < this.numEqn; ++n) {
            dArray2[n] = dArray[n] + d5 * dArray4[n];
        }
        this.ode.getRate(dArray2, dArray3);
        double d6 = 0.0;
        for (n = 0; n < dArray2.length; ++n) {
            d2 = this.tolerance + this.tolerance * Math.abs(dArray[n]);
            d6 += Math.pow((dArray3[n] - dArray4[n]) / d2, 2.0);
        }
        d6 = Math.sqrt(d6) / d5;
        double d7 = Math.max(Math.abs(d6), Math.sqrt(d3));
        double d8 = 0.0;
        d8 = d7 <= 1.0E-15 ? Math.max(1.0E-6, Math.abs(d5) * 0.001) : Math.exp(1.0 / (double)this.methodOrder * Math.log(0.01 / d7));
        d5 = (double)n2 * Math.min(100.0 * d5, d8);
        if (d != 0.0) {
            d5 = (double)n2 * Math.min(Math.abs(d5), d);
        }
        return d5;
    }

    public void setStepSize(double d) {
        this.stepSize = d;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setTolerance(double d) {
        this.tolerance = Math.abs(d);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void doInterpolation(double d, double[] dArray) {
        if (dArray != this.state) {
            for (int i = 0; i < this.numEqn; ++i) {
                dArray[i] = this.initialState[i] + (this.state[i] - this.initialState[i]) * d / this.takenStepSize;
            }
        } else {
            System.err.println("Cann't interpolate to the internal state vector. Please call initialize(double, double []) method");
        }
    }
}

