/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.AbstractODESolver;
import org.opensourcephysics.numerics.ODE;

public class Ralston2
extends AbstractODESolver {
    private double[] rate1;
    private double[] rate2;
    private double[] estimated_state;

    public Ralston2(ODE oDE) {
        super(oDE);
    }

    public void initialize(double d) {
        super.initialize(d);
        this.rate1 = new double[this.numEqn];
        this.rate2 = new double[this.numEqn];
        this.estimated_state = new double[this.numEqn];
    }

    public double step() {
        int n;
        double[] dArray = this.ode.getState();
        if (dArray.length != this.numEqn) {
            this.initialize(this.stepSize);
        }
        this.ode.getRate(dArray, this.rate1);
        for (n = 0; n < this.numEqn; ++n) {
            this.estimated_state[n] = dArray[n] + 0.75 * this.stepSize * this.rate1[n];
        }
        this.ode.getRate(this.estimated_state, this.rate2);
        for (n = 0; n < this.numEqn; ++n) {
            dArray[n] = dArray[n] + this.stepSize * (this.rate1[n] + 2.0 * this.rate2[n]) / 3.0;
        }
        return this.stepSize;
    }
}

