/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import java.util.ArrayList;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Root;
import org.opensourcephysics.numerics.Util;

public class Polynomial
implements Function {
    protected double[] coefficients;

    public Polynomial(double[] dArray) {
        this.coefficients = dArray;
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    public Polynomial(String[] stringArray) {
        this.coefficients = new double[stringArray.length];
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                this.coefficients[i] = Double.parseDouble(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.coefficients[i] = 0.0;
            }
        }
    }

    public static double evalPolynomial(double d, double[] dArray) {
        int n = dArray.length - 1;
        double d2 = dArray[n];
        for (int i = n - 1; i >= 0; --i) {
            d2 = dArray[i] + d2 * d;
        }
        return d2;
    }

    public Polynomial add(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[n];
        dArray[0] = this.coefficients[0] + d;
        for (int i = 1; i < n; ++i) {
            dArray[i] = this.coefficients[i];
        }
        return new Polynomial(dArray);
    }

    public Polynomial add(Polynomial polynomial) {
        int n = Math.max(polynomial.degree(), this.degree()) + 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coefficient(i) + polynomial.coefficient(i);
        }
        return new Polynomial(dArray);
    }

    public double coefficient(int n) {
        return n < this.coefficients.length ? this.coefficients[n] : 0.0;
    }

    public Polynomial deflate(double d) {
        int n = this.degree();
        double d2 = this.coefficients[n];
        double[] dArray = new double[n];
        for (int i = n - 1; i >= 0; --i) {
            dArray[i] = d2;
            d2 = d2 * d + this.coefficients[i];
        }
        return new Polynomial(dArray);
    }

    public int degree() {
        return this.coefficients.length - 1;
    }

    public Polynomial derivative() {
        int n = this.degree();
        if (n == 0) {
            double[] dArray = new double[]{0.0};
            return new Polynomial(dArray);
        }
        double[] dArray = new double[n];
        for (int i = 1; i <= n; ++i) {
            dArray[i - 1] = this.coefficients[i] * (double)i;
        }
        return new Polynomial(dArray);
    }

    public Polynomial divide(double d) {
        return this.multiply(1.0 / d);
    }

    public Polynomial divide(Polynomial polynomial) {
        return this.divideWithRemainder(polynomial)[0];
    }

    public Polynomial[] divideWithRemainder(Polynomial polynomial) {
        int n;
        int n2;
        Polynomial[] polynomialArray = new Polynomial[2];
        int n3 = this.degree();
        if (n3 < (n2 = polynomial.degree())) {
            double[] dArray = new double[]{0.0};
            polynomialArray[0] = new Polynomial(dArray);
            polynomialArray[1] = polynomial;
            return polynomialArray;
        }
        double[] dArray = new double[n3 - n2 + 1];
        double[] dArray2 = new double[n3 + 1];
        for (int i = 0; i <= n3; ++i) {
            dArray2[i] = this.coefficients[i];
        }
        double d = 1.0 / polynomial.coefficient(n2);
        for (int i = n3 - n2; i >= 0; --i) {
            dArray[i] = dArray2[n2 + i] * d;
            for (n = n2 + i - 1; n >= i; --n) {
                int n4 = n;
                dArray2[n4] = dArray2[n4] - dArray[i] * polynomial.coefficient(n - i);
            }
        }
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[n] = dArray2[n];
        }
        polynomialArray[0] = new Polynomial(dArray);
        polynomialArray[1] = new Polynomial(dArray3);
        return polynomialArray;
    }

    public Polynomial integral() {
        return this.integral(0.0);
    }

    public Polynomial integral(double d) {
        int n = this.coefficients.length + 1;
        double[] dArray = new double[n];
        dArray[0] = d;
        for (int i = 1; i < n; ++i) {
            dArray[i] = this.coefficients[i - 1] / (double)i;
        }
        return new Polynomial(dArray);
    }

    public Polynomial multiply(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coefficients[i] * d;
        }
        return new Polynomial(dArray);
    }

    public Polynomial multiply(Polynomial polynomial) {
        int n = polynomial.degree() + this.degree();
        double[] dArray = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray[i] = 0.0;
            for (int j = 0; j <= i; ++j) {
                int n2 = i;
                dArray[n2] = dArray[n2] + polynomial.coefficient(j) * this.coefficient(i - j);
            }
        }
        return new Polynomial(dArray);
    }

    public double[] roots() {
        return this.roots(Util.defaultNumericalPrecision);
    }

    public double[] roots(double d) {
        double d2;
        int n;
        double d3 = 0.0;
        if (this.degree() < 1) {
            return new double[0];
        }
        Polynomial polynomial = this.derivative();
        for (n = 0; n < 100 && Math.abs(polynomial.evaluate(d3)) < d; ++n) {
            d3 = Math.random();
        }
        Polynomial polynomial2 = this;
        ArrayList<Double> arrayList = new ArrayList<Double>(this.degree());
        while (!Double.isNaN(d2 = Root.newton(polynomial2, polynomial, d3, d))) {
            arrayList.add(new Double(d2));
            polynomial2 = polynomial2.deflate(d2);
            if (polynomial2.degree() == 0) break;
            polynomial = polynomial2.derivative();
            d3 = 0.0;
            for (n = 0; n < 100 && Math.abs(polynomial.evaluate(d3)) < d; ++n) {
                d3 = Math.random();
            }
        }
        double[] dArray = new double[arrayList.size()];
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            dArray[i] = (Double)arrayList.get(i);
        }
        return dArray;
    }

    public Polynomial subtract(double d) {
        return this.add(-d);
    }

    public Polynomial subtract(Polynomial polynomial) {
        int n = Math.max(polynomial.degree(), this.degree()) + 1;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.coefficient(i) - polynomial.coefficient(i);
        }
        return new Polynomial(dArray);
    }

    public String toString() {
        if (this.coefficients == null || this.coefficients.length < 1) {
            return "Polynomial coefficients are undefined.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = this.coefficients.length;
        for (int i = 0; i < n; ++i) {
            if (this.coefficients[i] == 0.0) continue;
            if (bl) {
                stringBuffer.append(this.coefficients[i] > 0.0 ? " + " : " ");
            } else {
                bl = true;
            }
            if (i == 0 || this.coefficients[i] != 1.0) {
                stringBuffer.append(Double.toString(this.coefficients[i]));
            }
            if (i <= 0) continue;
            stringBuffer.append(" x^" + i);
        }
        String string = stringBuffer.toString();
        if (string.equals("")) {
            return "0";
        }
        return string;
    }

    public double evaluate(double d) {
        int n = this.coefficients.length;
        double d2 = this.coefficients[--n];
        while (n > 0) {
            d2 = d2 * d + this.coefficients[--n];
        }
        return d2;
    }

    public double[] valueAndDerivative(double d) {
        int n = this.coefficients.length;
        double[] dArray = new double[]{this.coefficients[--n], 0.0};
        while (n > 0) {
            dArray[1] = dArray[1] * d + dArray[0];
            dArray[0] = dArray[0] * d + this.coefficients[--n];
        }
        return dArray;
    }
}

