/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.Function;

public class LagrangeInterpolator
implements Function {
    protected double[] hornerCoef;
    double[] xd;
    double[] yd;

    public LagrangeInterpolator(double[] dArray, double[] dArray2) {
        this.hornerCoef = new double[dArray.length];
        this.xd = dArray;
        this.yd = dArray2;
        this.computeCoefficients(dArray, dArray2);
    }

    private void computeCoefficients(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            this.hornerCoef[n] = dArray2[n];
        }
        --n2;
        for (n = 0; n < n2; ++n) {
            for (int i = n2; i > n; --i) {
                int n3 = i - 1;
                int n4 = i - (n + 1);
                this.hornerCoef[i] = (this.hornerCoef[i] - this.hornerCoef[n3]) / (dArray[i] - dArray[n4]);
            }
        }
    }

    public double evaluate(double d) {
        int n = this.hornerCoef.length;
        double d2 = this.hornerCoef[--n];
        while (--n >= 0) {
            d2 = d2 * (d - this.xd[n]) + this.hornerCoef[n];
        }
        return d2;
    }

    public double[] getCoefficients() {
        int n;
        int n2 = this.xd.length;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        dArray[n2 - 1] = -this.xd[0];
        for (n = 1; n < n2; ++n) {
            for (int i = n2 - n - 1; i < n2 - 1; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] - this.xd[n] * dArray[i + 1];
            }
            int n4 = n2 - 1;
            dArray[n4] = dArray[n4] - this.xd[n];
        }
        for (n = 0; n < n2; ++n) {
            double d = n2;
            for (int i = n2 - 1; i >= 1; --i) {
                d = (double)i * dArray[i] + this.xd[n] * d;
            }
            double d2 = this.yd[n] / d;
            double d3 = 1.0;
            for (int i = n2 - 1; i >= 0; --i) {
                int n5 = i;
                dArray2[n5] = dArray2[n5] + d3 * d2;
                d3 = dArray[i] + this.xd[n] * d3;
            }
        }
        return dArray2;
    }
}

